/**
 * Flowaxy Admin Panel - Main JavaScript
 * Основные функции для работы админ-панели
 */

(function() {
    'use strict';

    /**
     * WordPress-подібна функціональність sidebar
     * Управляет состоянием sidebar и обновляет отступы основного контента
     */
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebarMenu');
        const main = document.querySelector('main.col-md-9.ms-sm-auto.col-lg-10');

        if (sidebar) {
            sidebar.classList.toggle('collapsed');

            // Оновлюємо відступ основного контенту
            if (main) {
                if (sidebar.classList.contains('collapsed')) {
                    main.style.marginLeft = '36px';
                    main.style.marginTop = '40px';
                } else {
                    main.style.marginLeft = '160px';
                    main.style.marginTop = '40px';
                }
            }
        }
    }

    /**
     * Переключення мобільного sidebar
     */
    function toggleMobileSidebar() {
        const sidebar = document.getElementById('sidebarMenu');
        const overlay = document.getElementById('mobileSidebarOverlay');

        if (sidebar && overlay) {
            const isOpen = sidebar.classList.contains('mobile-show');

            if (isOpen) {
                // Закрываем
                sidebar.classList.remove('mobile-show');
                overlay.classList.remove('show');
                document.body.style.overflow = ''; // Разрешаем скролл
            } else {
                // Открываем
                sidebar.classList.add('mobile-show');
                overlay.classList.add('show');
                document.body.style.overflow = 'hidden'; // Блокируем скролл
            }
        }
    }

    /**
     * Переключення підменю
     */
    function toggleSubmenu(element, event) {
        // Запобігаємо сплиттю події та переходу за посиланням
        if (event) {
            event.preventDefault();
            event.stopPropagation();
        }

        const parentItem = element.closest('.has-submenu');
        if (parentItem) {
            // Проверяем, есть ли активный пункт в подменю
            const hasActiveSubmenu = parentItem.querySelector('.submenu li.active') !== null;

            // Если есть активный пункт, не закрываем подменю
            if (hasActiveSubmenu && !parentItem.classList.contains('open')) {
                // Открываем, если закрыто
                parentItem.classList.add('open');
                const submenu = parentItem.querySelector('.submenu');
                if (submenu) {
                    submenu.classList.add('show');
                }
                return;
            }

            // Переключаем класс open на родительском элементе
            parentItem.classList.toggle('open');

            // Также добавляем класс show для совместимости
            const submenu = parentItem.querySelector('.submenu');
            if (submenu) {
                if (parentItem.classList.contains('open')) {
                    submenu.classList.add('show');
                } else {
                    submenu.classList.remove('show');
                }
            }
        }
    }

    /**
     * Инициализация: автоматически открываем подменю с активными пунктами
     */
    function initSidebarSubmenus() {
        const sidebar = document.getElementById('sidebarMenu');
        if (sidebar) {
            sidebar.querySelectorAll('.has-submenu').forEach(function(parentItem) {
                const hasActiveSubmenu = parentItem.querySelector('.submenu li.active') !== null;
                if (hasActiveSubmenu) {
                    parentItem.classList.add('open');
                    const submenu = parentItem.querySelector('.submenu');
                    if (submenu) {
                        submenu.classList.add('show');
                    }
                }
            });
        }
    }

    // Инициализируем при загрузке страницы
    // Используем несколько способов для надежности
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            initSidebarSubmenus();
        });
    } else {
        // Если DOM уже загружен, выполняем сразу
        initSidebarSubmenus();
    }

    // Также инициализируем после полной загрузки страницы (на случай если что-то загружается асинхронно)
    window.addEventListener('load', function() {
        initSidebarSubmenus();
    });

    /**
     * Закрытие мобильного сайдбара при клике на ссылку
     */
    function closeMobileSidebarOnLinkClick() {
        const sidebar = document.getElementById('sidebarMenu');
        if (sidebar) {
            const links = sidebar.querySelectorAll('a.nav-link, a.submenu-link');
            links.forEach(function(link) {
                link.addEventListener('click', function() {
                    // Закрываем сайдбар только если это не подменю и на мобильном устройстве
                    if (!link.classList.contains('submenu-toggle') && window.innerWidth <= 767.98) {
                        setTimeout(function() {
                            toggleMobileSidebar();
                        }, 100);
                    }
                });
            });
        }
    }

    // Инициализируем закрытие при клике на ссылки
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            closeMobileSidebarOnLinkClick();
        });
    } else {
        closeMobileSidebarOnLinkClick();
    }

    // Експортуємо функції в глобальну область видимості
    window.toggleSidebar = toggleSidebar;
    window.toggleMobileSidebar = toggleMobileSidebar;
    window.toggleSubmenu = toggleSubmenu;
    window.initSidebarSubmenus = initSidebarSubmenus;
})();
