<?php
/**
 * Layout: Header админ-панели
 * Может быть заменен плагином через хук
 */
?>
<nav class="navbar navbar-expand-lg navbar-dark fixed-top">
    <div class="container-fluid">
        <!-- Левая часть навбара -->
        <div class="d-flex align-items-center">
            <!-- Кнопка мобильного меню -->
            <button class="mobile-menu-btn" onclick="toggleMobileSidebar()" aria-label="Відкрити меню" title="Відкрити меню">
                <i class="fas fa-bars"></i>
            </button>

            <!-- Логотип -->
            <a class="navbar-brand d-none d-md-flex align-items-center header-logo" href="<?= admin_url('dashboard') ?>">
                <img src="<?= asset('images/brand/logo-white.png') ?>" alt="Flowaxy CMS" class="admin-logo-img">
            </a>
        </div>

        <!-- Правая часть навбара - иконки в ряд -->
        <div class="d-flex align-items-center gap-2 header-right-actions">
            <!-- Иконки быстрого доступа к разделам -->
            <?php
            // Определяем текущую страницу
            $currentPage = get_current_admin_page();
            $isDashboard = ($currentPage === 'dashboard');
            $isPlugins = ($currentPage === 'plugins');
            $isThemes = ($currentPage === 'themes');
            $isSettings = ($currentPage === 'settings' || $currentPage === 'site-settings');

            // Проверка прав доступа
            $session = function_exists('sessionManager') ? sessionManager() : null;
            $userId = $session ? (int)($session->get('admin_user_id') ?? 0) : 0;
            $hasPluginsAccess = function_exists('current_user_can') && current_user_can('admin.access');
            $hasThemesAccess = function_exists('current_user_can') && current_user_can('admin.access');
            $hasSettingsAccess = function_exists('current_user_can') && current_user_can('admin.access');
            ?>
            <div class="header-quick-actions d-flex align-items-center" style="position: relative; overflow: visible;">
                <!-- Панель управления - доступна всем авторизованным -->
                <a href="<?= admin_url('dashboard') ?>" class="header-quick-action-btn <?= $isDashboard ? 'active' : '' ?>" title="Панель управління">
                    <i class="fas fa-home"></i>
                    <span class="d-none d-md-inline ms-1">Панель</span>
                </a>

                <!-- Плагины -->
                <?php if ($hasPluginsAccess): ?>
                <a href="<?= admin_url('plugins') ?>" class="header-quick-action-btn <?= $isPlugins ? 'active' : '' ?>" title="Плагіни">
                    <i class="fas fa-puzzle-piece"></i>
                    <span class="d-none d-md-inline ms-1">Плагіни</span>
                </a>
                <?php endif; ?>

                <!-- Темы -->
                <?php if ($hasThemesAccess): ?>
                <a href="<?= admin_url('themes') ?>" class="header-quick-action-btn <?= $isThemes ? 'active' : '' ?>" title="Теми">
                    <i class="fas fa-palette"></i>
                    <span class="d-none d-md-inline ms-1">Теми</span>
                </a>
                <?php endif; ?>

                <!-- Налаштування -->
                <?php if ($hasSettingsAccess): ?>
                <a href="<?= admin_url('settings') ?>" class="header-quick-action-btn <?= $isSettings ? 'active' : '' ?>" title="Налаштування">
                    <i class="fas fa-cog"></i>
                    <span class="d-none d-md-inline ms-1">Налаштування</span>
                </a>
                <?php endif; ?>
            </div>

            <!-- Дополнительные иконки -->
            <div class="header-icon-actions d-flex align-items-center gap-2">
                <!-- Иконка Expand/External Link -->
                <button class="header-icon-btn" title="Розгорнути" onclick="window.open(window.location.href, '_blank')">
                    <i class="fas fa-external-link-alt"></i>
                </button>

                <!-- Иконка Database -->
                <?php
                // Проверяем статус БД для тултипа
                $dbConnected = false;
                if (function_exists('is_database_available') && is_database_available()) {
                    $dbConnected = true;
                } elseif (defined('DB_HOST') && defined('DB_NAME') && !empty(DB_HOST) && !empty(DB_NAME)) {
                    try {
                        if (class_exists('\Flowaxy\Infrastructure\Persistence\Database\Database')) {
                            $db = \Flowaxy\Infrastructure\Persistence\Database\Database::getInstance();
                            $dbConnected = $db->isAvailable();
                        }
                    } catch (\Exception $e) {
                        $dbConnected = false;
                    }
                }
                $dbTitle = $dbConnected ? 'База даних' : 'База даних не налаштована';
                $dbClass = $dbConnected ? 'header-icon-btn' : 'header-icon-btn';
                $dbStyle = $dbConnected ? '' : 'opacity: 0.6;';
                ?>
                <a href="<?= admin_url('database') ?>" class="<?= $dbClass ?>" title="<?= htmlspecialchars($dbTitle) ?>" style="<?= $dbStyle ?>">
                    <i class="fas fa-database"></i>
                </a>

                <!-- Иконка Cache -->
                <a href="<?= admin_url('cache-clear') ?>" class="header-icon-btn" title="Очистити кеш">
                    <i class="fas fa-bolt"></i>
                </a>

                <!-- Меню пользователя -->
                <div class="dropdown">
                    <button class="header-icon-btn dropdown-toggle" type="button" id="userMenuDropdown" data-bs-toggle="dropdown" aria-expanded="false" title="Профіль користувача">
                        <i class="fas fa-user"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userMenuDropdown">
                        <li class="dropdown-header">
                            <i class="fas fa-user me-2"></i>
                            <?= htmlspecialchars($session ? ($session->get('admin_username') ?? 'Користувач') : 'Користувач') ?>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?= admin_url('profile') ?>"><i class="fas fa-user me-2"></i>Профіль</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?= admin_url('logout') ?>"><i class="fas fa-sign-out-alt me-2"></i>Вихід</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</nav>
