<?php

/**
 * Страница управления виджетами темы
 */

function admin_widgets_page()
{
    // Получаем виджеты темы через хук
    $widgets = [];
    if (function_exists('apply_filters')) {
        $widgets = apply_filters('theme_widgets', $widgets);
    }

    if (!is_array($widgets)) {
        $widgets = [];
    }

    $content = '<div class="container-fluid">
        <h1 class="mb-4">Виджеты темы</h1>
        <p class="text-muted mb-3">
            Здесь вы можете управлять виджетами активной темы.
            Виджеты - это переиспользуемые блоки контента, которые можно размещать в различных областях темы.
        </p>';

    if (empty($widgets)) {
        $content .= '<div class="alert alert-info">
            <i class="fas fa-info-circle"></i> Активная тема не предоставила виджеты или они еще не зарегистрированы.
        </div>';
    } else {
        $content .= '<div class="card">
            <div class="card-header">
                <i class="fas fa-puzzle-piece"></i> Доступные виджеты темы
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered mb-0">
                        <thead>
                            <tr>
                                <th style="width: 220px;">Идентификатор</th>
                                <th>Название</th>
                                <th>Описание</th>
                                <th style="width: 120px;">Действия</th>
                            </tr>
                        </thead>
                        <tbody>';
        foreach ($widgets as $widgetId => $widgetData) {
            $name = is_array($widgetData) ? ($widgetData['name'] ?? $widgetId) : (string)$widgetId;
            $description = is_array($widgetData) ? ($widgetData['description'] ?? '') : '';
            $content .= '<tr>
                <td><code>' . htmlspecialchars((string)$widgetId, ENT_QUOTES, 'UTF-8') . '</code></td>
                <td><strong>' . htmlspecialchars((string)$name, ENT_QUOTES, 'UTF-8') . '</strong></td>
                <td>' . htmlspecialchars((string)$description, ENT_QUOTES, 'UTF-8') . '</td>
                <td>
                    <button class="btn btn-sm btn-primary" onclick="alert(\'Редактирование виджетов будет реализовано позже\')">
                        <i class="fas fa-edit"></i> Настроить
                    </button>
                </td>
            </tr>';
        }
        $content .= '        </tbody>
                    </table>
                </div>
                <p class="mt-3 text-muted">
                    Управление размещением виджетов в областях темы будет добавлено позже.
                </p>
            </div>
        </div>';
    }

    $content .= '</div>';

    if (function_exists('render_admin_layout')) {
        return render_admin_layout([
            'title' => 'Виджеты темы - Flowaxy CMS',
            'content' => $content,
            'pageHeaderIcon' => 'fas fa-puzzle-piece',
            'pageBreadcrumbs' => [
                ['title' => 'Головна', 'url' => admin_url('dashboard'), 'page' => 'dashboard'],
                ['title' => 'Виджеты темы', 'page' => 'widgets'],
            ],
        ]);
    }

    echo $content;
}
