<?php
/**
 * Шаблон сторінки управління темами
 * Стиль як у plugins: статистичні картки зверху, список тем, інформаційний блок
 */
$componentsPath = $componentsPath ?? (__DIR__ . DS . '..' . DS . '..' . DS . 'components' . DS);
$stats = $stats ?? [
    'total' => 0,
    'installed' => 0,
    'active' => 0,
    'inactive' => 0,
];
$installedThemes = $installedThemes ?? [];

// Получаем flash сообщения из сессии
$session = function_exists('sessionManager') ? sessionManager() : null;
$flashMessage = null;
$flashMessageType = 'info';
if ($session !== null) {
    // Используем flash() для получения flash-сообщения (автоматически удаляется после чтения)
    if (method_exists($session, 'flash')) {
        $flashMessage = $session->flash('admin_message');
        $flashMessageType = $session->flash('admin_message_type', 'info');
    } else {
        // Fallback: используем get и затем forget
        $flashMessage = $session->get('admin_message');
        $flashMessageType = $session->get('admin_message_type', 'info');
        if ($flashMessage !== null) {
            $session->forget('admin_message');
            $session->forget('admin_message_type');
        }
    }
}

// Показуємо кастомне уведомлення замість стандартного alert
$message = $message ?? $flashMessage;
if (!empty($message)) {
    $type = $messageType ?? 'info';
    // JavaScript функция showNotification использует innerHTML, поэтому HTML будет работать
    // Используем json_encode БЕЗ JSON_HEX_TAG, чтобы HTML-теги передавались правильно
    $messageJson = json_encode($message, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    $typeEscaped = htmlspecialchars($type, ENT_QUOTES, 'UTF-8');
    echo '<div id="notification-data" data-message=' . $messageJson . ' data-type="' . $typeEscaped . '" style="display: none;"></div>';
}
?>
<div class="themes-page">
    <!-- Статистичні картки -->
    <div class="themes-stats-section">
        <?php
        $cards = [
            [
                'title' => 'Всього тем',
                'value' => number_format($stats['total'], 0, ',', ' '),
                'icon' => 'palette',
                'color' => 'primary'
            ],
            [
                'title' => 'Встановлено',
                'value' => number_format($stats['installed'], 0, ',', ' '),
                'icon' => 'check-circle',
                'color' => 'info'
            ],
            [
                'title' => 'Активні',
                'value' => $stats['active'] > 0
                    ? '<span class="text-success">' . number_format($stats['active'], 0, ',', ' ') . '</span>'
                    : '<span class="text-muted">0</span>',
                'icon' => 'power-off',
                'color' => $stats['active'] > 0 ? 'success' : 'secondary',
                'valueClass' => 'h5'
            ],
            [
                'title' => 'Неактивні',
                'value' => $stats['inactive'] > 0
                    ? '<span class="text-warning">' . number_format($stats['inactive'], 0, ',', ' ') . '</span>'
                    : '<span class="text-muted">0</span>',
                'icon' => 'pause-circle',
                'color' => $stats['inactive'] > 0 ? 'warning' : 'secondary',
                'valueClass' => 'h5'
            ]
        ];
        // Використовуємо компонент stats-cards якщо він є
        $statsCardsPath = $componentsPath . 'layout' . DS . 'stats-cards.php';
        if (file_exists($statsCardsPath)) {
            include $statsCardsPath;
        } else {
            // Fallback - виводимо картки напряму з іконками (якщо компонент не знайдено)
            echo '<div class="stats-cards"><div class="row g-3">';
            foreach ($cards as $card) {
                $icon = $card['icon'] ?? '';
                $color = $card['color'] ?? 'primary';
                $valueClass = $card['valueClass'] ?? 'h4';
                $colorMap = [
                    'primary' => '#0073aa',
                    'info' => '#00a0d2',
                    'success' => '#46b450',
                    'warning' => '#ffb900',
                    'danger' => '#dc3232',
                    'secondary' => '#646970'
                ];
                $iconColor = $colorMap[$color] ?? $colorMap['primary'];
                echo '<div class="col-md-3">';
                echo '<div class="card border-left-' . htmlspecialchars($color) . ' h-100">';
                echo '<div class="card-body">';
                echo '<div class="row align-items-center">';
                echo '<div class="col">';
                echo '<div class="stats-card-title">' . htmlspecialchars($card['title']) . '</div>';
                echo '<div class="stats-card-value ' . htmlspecialchars($valueClass) . ' mb-0 font-weight-bold">' . $card['value'] . '</div>';
                echo '</div>';
                if (!empty($icon)) {
                    echo '<div class="col-auto">';
                    echo '<i class="fas fa-' . htmlspecialchars($icon) . ' stats-card-icon" style="color: ' . htmlspecialchars($iconColor) . ';"></i>';
                    echo '</div>';
                }
                echo '</div>';
                echo '</div></div></div>';
            }
            echo '</div></div>';
        }
        ?>
    </div>

    <!-- Список тем -->
    <div class="themes-list-section">
        <div class="card border-0">
            <div class="card-body p-0">
                <?php if (!empty($installedThemes)): ?>
                    <div class="themes-list">
                        <div class="row">
                            <?php foreach ($installedThemes as $theme): ?>
                                <?php
                                $colClass = 'col-12 col-sm-6 col-lg-4 col-xl-3';

                                // Подготавливаем данные для компонента
                                $isActive = ($theme['is_active'] ?? 0) == 1;
                                $supportsCustomization = isset($theme['supports_customization']) && $theme['supports_customization'];

                                // Получаем дополнительные данные о теме через ThemeManager
                                if (function_exists('themeManager')) {
                                    $themeManager = themeManager();
                                    if ($themeManager) {
                                        if (method_exists($themeManager, 'supportsCustomization')) {
                                            $supportsCustomization = $themeManager->supportsCustomization($theme['slug'] ?? '');
                                        }
                                        if (method_exists($themeManager, 'supportsNavigation')) {
                                            $supportsNavigation = $themeManager->supportsNavigation($theme['slug'] ?? '');
                                        } else {
                                            $supportsNavigation = false;
                                        }
                                    } else {
                                        $supportsNavigation = false;
                                    }
                                } else {
                                    $supportsNavigation = false;
                                }

                                $hasSettings = isset($theme['has_settings']) && $theme['has_settings'];
                                $features = isset($theme['features']) ? $theme['features'] : [];

                                // Використовуємо універсальний компонент package-card якщо він є
                                $type = 'theme';
                                $package = $theme;
                                $packageCardPath = $componentsPath . 'layout' . DS . 'package-card.php';
                                if (file_exists($packageCardPath)) {
                                    include $packageCardPath;
                                } else {
                                    // Fallback - простий вивід
                                    echo '<div class="' . $colClass . ' mb-3">';
                                    echo '<div class="card">';
                                    echo '<div class="card-body">';
                                    echo '<h5>' . htmlspecialchars($theme['name'] ?? 'Unknown') . '</h5>';
                                    echo '<p class="text-muted small">' . htmlspecialchars($theme['description'] ?? '') . '</p>';
                                    echo '</div></div></div>';
                                }
                                ?>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php else: ?>
                    <?php
                    // Порожній стан
                    $icon = 'palette';
                    $title = 'Теми відсутні';
                    $message = 'Встановіть тему за замовчуванням або завантажте нову тему з маркетплейсу.';
                    if (file_exists($componentsPath . 'layout' . DS . 'empty-state.php')) {
                        include $componentsPath . 'layout' . DS . 'empty-state.php';
                    } else {
                        echo '<div class="alert alert-info">' . htmlspecialchars($message) . '</div>';
                    }
                    ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Інформаційний блок -->
    <div class="themes-info-section">
        <?php
        $title = 'Про теми';
        $titleIcon = 'info-circle';
        $sections = [
            [
                'title' => 'Що таке теми:',
                'icon' => 'question-circle',
                'iconColor' => 'primary',
                'items' => [
                    'Визначають дизайн та зовнішній вигляд сайту',
                    'Дозволяють змінювати стилі без змін ядра',
                    'Можуть бути активовані та деактивовані в будь-який час',
                    'Встановлюються через ZIP архів з файлом theme.json'
                ]
            ],
            [
                'title' => 'Управління темами:',
                'icon' => 'cog',
                'iconColor' => 'info',
                'items' => [
                    'Активуйте теми для їх використання',
                    'Одна тема може бути активною одночасно',
                    'Перевіряйте сумісність з версією системи',
                    'Регулярно оновлюйте для безпеки та нових функцій'
                ]
            ]
        ];
        if (file_exists($componentsPath . 'layout' . DS . 'info-block.php')) {
            include $componentsPath . 'layout' . DS . 'info-block.php';
        }
        ?>
    </div>
</div>

<!-- Модальное окно для загрузки темы -->
<div class="modal fade" id="uploadThemeModal" tabindex="-1" aria-labelledby="uploadThemeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="uploadThemeModalLabel">
                    <i class="fas fa-upload"></i> Завантажити тему
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="uploadThemeForm" method="POST" enctype="multipart/form-data" action="<?= admin_url('themes') ?>">
                <div class="modal-body">
                    <input type="hidden" name="csrf_token" value="<?= class_exists('\Flowaxy\Support\Helpers\SecurityHelper') ? \Flowaxy\Support\Helpers\SecurityHelper::csrfToken() : (function_exists('csrf_token') ? csrf_token() : '') ?>">
                    <input type="hidden" name="action" value="upload_theme">

                    <div class="mb-3">
                        <label for="theme_file" class="form-label">ZIP архів з темою</label>
                        <input type="file" class="form-control" id="theme_file" name="theme_file[]" accept=".zip" multiple>
                        <div class="form-text">Можна вибрати декілька ZIP-архівів. Максимальний розмір: 50 МБ</div>
                    </div>

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> Тема повинна містити файл <code>Theme.php</code> з метаданими.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Скасувати</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload"></i> Завантажити
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- JavaScript винесений в scripts/themes.js -->

<!-- Стилі винесені в SCSS: pages/_packages.scss -->
