<?php

/**
 * Страница настройки меню навигации темы
 */

function admin_theme_navigation_page()
{
    // Получаем поддерживаемые темой локации меню через хук
    $locations = [];
    if (function_exists('apply_filters')) {
        $locations = apply_filters('theme_navigation_locations', $locations);
    }

    if (!is_array($locations)) {
        $locations = [];
    }

    $content = '<div class="container-fluid">
        <h1 class="mb-4">Навигация темы</h1>
        <p class="text-muted mb-3">
            Здесь вы можете увидеть, какие области меню поддерживает активная тема.
            Настройка конкретных меню и пунктов будет реализована в следующих версиях.
        </p>';

    if (empty($locations)) {
        $content .= '<div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle"></i> Активная тема не зарегистрировала области меню.
        </div>';
    } else {
        $content .= '<div class="card">
            <div class="card-header">
                <i class="fas fa-bars"></i> Области меню темы
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered mb-0">
                        <thead>
                            <tr>
                                <th style="width: 220px;">Идентификатор</th>
                                <th>Название</th>
                            </tr>
                        </thead>
                        <tbody>';
        foreach ($locations as $key => $label) {
            $content .= '<tr>
                <td><code>' . htmlspecialchars((string)$key, ENT_QUOTES, 'UTF-8') . '</code></td>
                <td>' . htmlspecialchars((string)$label, ENT_QUOTES, 'UTF-8') . '</td>
            </tr>';
        }
        $content .= '        </tbody>
                    </table>
                </div>
                <p class="mt-3 text-muted">
                    Интеграция с редактором меню (создание, привязка и управление пунктами) будет добавлена пізніше.
                </p>
            </div>
        </div>';
    }

    $content .= '</div>';

    if (function_exists('render_admin_layout')) {
        return render_admin_layout([
            'title' => 'Навигация темы - Flowaxy CMS',
            'content' => $content,
            'pageHeaderIcon' => 'fas fa-bars',
            'pageBreadcrumbs' => [
                ['title' => 'Головна', 'url' => admin_url('dashboard'), 'page' => 'dashboard'],
                ['title' => 'Навигация темы', 'page' => 'theme-navigation'],
            ],
        ]);
    }

    echo $content;
}
