<?php
/**
 * Шаблон страницы настроек сайта
 */

// Перевірка прав доступу на редагування
$session = function_exists('sessionManager') ? sessionManager() : null;
$userId = $session ? (int)($session->get('admin_user_id') ?? 0) : 0;

// Проверяем права доступа
$hasEditAccess = ($userId === 0 || $userId === 1) ||
                 (function_exists('user_has_role') && $userId > 0 && user_has_role($userId, 'developer')) ||
                 (function_exists('current_user_can') && current_user_can('admin.access'));

$readonlyAttr = $hasEditAccess ? '' : 'readonly disabled';
$readonlyClass = $hasEditAccess ? '' : 'bg-light';
?>

<!-- Кастомні уведомлення -->
<?php
// Показуємо кастомне уведомлення замість стандартного alert
if (!empty($message)) {
    $type = $messageType ?? 'info';
    $messageEscaped = htmlspecialchars($message, ENT_QUOTES, 'UTF-8');
    $typeEscaped = htmlspecialchars($type, ENT_QUOTES, 'UTF-8');
    echo '<div id="notification-data" data-message="' . $messageEscaped . '" data-type="' . $typeEscaped . '" style="display: none;"></div>';
}
?>

<?php if (! $hasEditAccess): ?>
<div class="alert alert-info">
    <i class="fas fa-info-circle me-2"></i>
    У вас є право тільки на перегляд налаштувань. Для зміни налаштувань потрібне право "Зміна налаштувань".
</div>
<?php endif; ?>

<div class="site-settings-page">
<form id="site-settings-form" method="POST" class="settings-form" <?= ! $hasEditAccess ? 'onsubmit="return false;"' : '' ?>>
    <input type="hidden" name="csrf_token" value="<?= class_exists('\Flowaxy\Support\Helpers\SecurityHelper') ? \Flowaxy\Support\Helpers\SecurityHelper::csrfToken() : (function_exists('csrf_token') ? csrf_token() : '') ?>">
    <input type="hidden" name="save_settings" value="1">

    <div class="row g-3">
        <!-- Загальні налаштування -->
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6>
                        <i class="fas fa-cog me-2 text-primary"></i>Загальні налаштування
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="siteName" class="form-label fw-medium small">
                                Назва сайту
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <input type="text"
                                   class="form-control <?= $readonlyClass ?>"
                                   id="siteName"
                                   name="settings[site_name]"
                                   value="<?= htmlspecialchars($settings['site_name'] ?? 'Flowaxy CMS') ?>"
                                   placeholder="Flowaxy CMS"
                                   <?= $readonlyAttr ?>>
                            <div class="form-text small"><i class="fas fa-heading me-1"></i>Назва вашого сайту</div>
                        </div>
                        <div class="col-md-6">
                            <label for="siteTagline" class="form-label fw-medium small">
                                Ключова фраза
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <input type="text"
                                   class="form-control <?= $readonlyClass ?>"
                                   id="siteTagline"
                                   name="settings[site_tagline]"
                                   value="<?= htmlspecialchars($settings['site_tagline'] ?? '') ?>"
                                   placeholder="Короткий опис сайту"
                                   <?= $readonlyAttr ?>>
                            <div class="form-text small"><i class="fas fa-quote-left me-1"></i>Коротка фраза, яка описує ваш сайт</div>
                        </div>
                        <div class="col-md-6">
                            <label for="siteUrl" class="form-label fw-medium small">
                                Адреса сайту (URL)
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <input type="url"
                                   class="form-control <?= $readonlyClass ?>"
                                   id="siteUrl"
                                   name="settings[site_url]"
                                   value="<?= htmlspecialchars($settings['site_url'] ?? '') ?>"
                                   placeholder="https://example.com"
                                   <?= $readonlyAttr ?>>
                            <div class="form-text small"><i class="fas fa-link me-1"></i>Повна адреса сайту</div>
                        </div>
                        <div class="col-md-6">
                            <label for="adminEmail" class="form-label fw-medium small">Email адміністратора</label>
                            <input type="email"
                                   class="form-control <?= $readonlyClass ?>"
                                   id="adminEmail"
                                   name="settings[admin_email]"
                                   value="<?= htmlspecialchars($settings['admin_email'] ?? '') ?>"
                                   placeholder="admin@example.com"
                                   <?= $readonlyAttr ?>>
                            <div class="form-text small"><i class="fas fa-envelope me-1"></i>Email адреса для системних повідомлень</div>
                        </div>
                        <div class="col-md-6">
                            <label for="siteProtocol" class="form-label fw-medium small">Протокол сайту</label>
                            <select class="form-select <?= $readonlyClass ?>" id="siteProtocol" name="settings[site_protocol]" <?= $readonlyAttr ?>>
                                <option value="auto" <?= ($settings['site_protocol'] ?? 'auto') === 'auto' ? 'selected' : '' ?>>Автоматично (визначається автоматично)</option>
                                <option value="https" <?= ($settings['site_protocol'] ?? '') === 'https' ? 'selected' : '' ?>>HTTPS (захищений)</option>
                                <option value="http" <?= ($settings['site_protocol'] ?? '') === 'http' ? 'selected' : '' ?>>HTTP (незахищений)</option>
                            </select>
                            <div class="form-text small"><i class="fas fa-shield-alt me-1"></i>Протокол для URL сайту. "Автоматично" визначає протокол на основі запиту</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Локалізація та форматування -->
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6>
                        <i class="fas fa-language me-2 text-primary"></i>Локалізація та форматування
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="timezone" class="form-label fw-medium small">Часовий пояс</label>
                            <div class="timezone-select-wrapper">
                                <input type="text"
                                       class="form-control timezone-search-input <?= $readonlyClass ?>"
                                       id="timezoneSearch"
                                       placeholder="Пошук часового поясу..."
                                       autocomplete="off"
                                       style="display: none; position: absolute; top: 0; left: 0; right: 0; z-index: 10;"
                                       <?= $readonlyAttr ?>>
                                <select class="form-select timezone-select <?= $readonlyClass ?>" id="timezone" name="settings[timezone]" size="10" style="display: none;" <?= $readonlyAttr ?>>
                                    <?php
                                    // Завантажуємо значення timezone з БД (без дефолтних значень)
                                    // SiteSettingsPage вже обробило значення з БД
                                    // Використовуємо те, що передано з контролера (може бути порожнім)
                                    // ВАЖЛИВО: Використовуємо array_key_exists замість isset, бо isset поверне false для порожніх рядків
                                    $currentTimezone = '';
                                    if (isset($settings) && is_array($settings) && array_key_exists('timezone', $settings)) {
                                        $currentTimezone = is_string($settings['timezone']) ? trim($settings['timezone']) : '';
                                    }

                                    // Автоматичне оновлення старого часового поясу на новий
                                    if ($currentTimezone === 'Europe/Kiev') {
                                        $currentTimezone = 'Europe/Kyiv';
                                    }

                                    // Додаємо опцію "Не вибрано" для порожнього значення
                                    if (empty($currentTimezone)) {
                                        echo '<option value="" selected data-text="Не вибрано">Не вибрано</option>';
                                    } else {
                                        echo '<option value="" data-text="Не вибрано">Не вибрано</option>';
                                    }

                                    // Завантажуємо всі часові пояси через TimezoneManager
                                    try {
                                        if (function_exists('getTimezoneOptions')) {
                                            $timezoneOptions = getTimezoneOptions($currentTimezone);

                                            // Додаємо всі часові пояси
                                            foreach ($timezoneOptions as $value => $text) {
                                                $selected = (!empty($currentTimezone) && $currentTimezone === $value) ? 'selected' : '';
                                                echo '<option value="' . htmlspecialchars($value) . '" ' . $selected . ' data-text="' . htmlspecialchars($text) . '">' . htmlspecialchars($text) . '</option>';
                                            }
                                        } else {
                                            // Fallback - додаємо популярні часові пояси
                                            $popularTimezones = [
                                                'UTC' => '(UTC+00:00) UTC',
                                                'Europe/London' => '(UTC+00:00) Лондон',
                                                'Europe/Berlin' => '(UTC+01:00) Берлін',
                                                'Europe/Paris' => '(UTC+01:00) Париж',
                                                'Europe/Kyiv' => '(UTC+02:00) Київ',
                                                'Europe/Moscow' => '(UTC+03:00) Москва',
                                                'Europe/Minsk' => '(UTC+03:00) Мінськ',
                                                'America/New_York' => '(UTC-05:00) Нью-Йорк',
                                                'America/Los_Angeles' => '(UTC-08:00) Лос-Анджелес',
                                                'Asia/Tokyo' => '(UTC+09:00) Токіо',
                                                'Asia/Shanghai' => '(UTC+08:00) Шанхай',
                                            ];

                                            foreach ($popularTimezones as $value => $text) {
                                                $selected = ($currentTimezone === $value) ? 'selected' : '';
                                                echo '<option value="' . htmlspecialchars($value) . '" ' . $selected . ' data-text="' . htmlspecialchars($text) . '">' . htmlspecialchars($text) . '</option>';
                                            }
                                        }
                                    } catch (Exception $e) {
                                        // При помилці використовуємо мінімальний набір
                                        $fallbackTimezones = [
                                            'UTC' => '(UTC+00:00) UTC',
                                            'Europe/Kyiv' => '(UTC+02:00) Київ',
                                        ];
                                        foreach ($fallbackTimezones as $value => $text) {
                                            $selected = ($currentTimezone === $value) ? 'selected' : '';
                                            echo '<option value="' . htmlspecialchars($value) . '" ' . $selected . ' data-text="' . htmlspecialchars($text) . '">' . htmlspecialchars($text) . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                                <div class="timezone-display-input">
                                    <?php
                                    // Встановлюємо початкове значення для відображення
                                    // ВАЖЛИВО: Використовуємо те ж саме значення, що вже обраховано вище ($currentTimezone)
                                    // Якщо в БД є значення (навіть порожнє), воно має пріоритет
                                    $displayText = '';

                                    // Використовуємо $currentTimezone, який вже правильно встановлений вище
                                    $timezoneToDisplay = $currentTimezone;
                                    $displayText = '';

                                    // Отримуємо текст для відображення через TimezoneManager
                                    // ВАЖЛИВО: Використовуємо значення з БД ($timezoneToDisplay = $currentTimezone)
                                    if (!empty($timezoneToDisplay) && $timezoneToDisplay !== '') {
                                        try {
                                            // Спочатку пробуємо отримати через getTimezone (більш точно)
                                            if (function_exists('getTimezone')) {
                                                $tz = getTimezone($timezoneToDisplay);
                                                if ($tz) {
                                                    $displayText = $tz->getText();
                                                }
                                            }

                                            // Якщо не знайшли через getTimezone, пробуємо через getTimezoneOptions
                                            if (empty($displayText) && function_exists('getTimezoneOptions')) {
                                                $allOptions = getTimezoneOptions();
                                                if (isset($allOptions[$timezoneToDisplay])) {
                                                    $displayText = $allOptions[$timezoneToDisplay];
                                                }
                                            }
                                        } catch (Exception $e) {
                                            // Якщо помилка, використовуємо fallback
                                            if (function_exists('logger')) {
                                                logger()->logError('Error getting timezone display: ' . $e->getMessage(), [
                                                    'timezone' => $timezoneToDisplay,
                                                    'exception' => $e->getMessage(),
                                                ]);
                                            }
                                        }
                                    }

                                    // Якщо все ще не знайдено, показуємо порожнє значення або сам ідентифікатор
                                    if (empty($displayText)) {
                                        if (!empty($timezoneToDisplay) && $timezoneToDisplay !== '') {
                                            // Якщо є значення, але не знайдено відображення, показуємо сам ідентифікатор
                                            $displayText = $timezoneToDisplay;
                                        } else {
                                            // Якщо значення порожнє, показуємо "Не вибрано"
                                            $displayText = 'Не вибрано';
                                        }
                                    }
                                    ?>
                                    <input type="text"
                                           class="form-control timezone-display <?= $readonlyClass ?>"
                                           id="timezoneDisplay"
                                           readonly
                                           value="<?= htmlspecialchars($displayText) ?>"
                                           placeholder="Не вибрано"
                                           <?= $readonlyAttr ?>>
                                    <i class="fas fa-chevron-down timezone-arrow"></i>
                                </div>
                                <div class="timezone-dropdown" id="timezoneDropdown" style="display: none;"></div>
                            </div>
                            <div class="form-text small">
                                <span id="timezone-current-time" data-timezone="<?= htmlspecialchars($currentTimezone ?: (function_exists('getTimezoneFromDatabase') ? getTimezoneFromDatabase() : 'UTC')) ?>">
                                    <i class="fas fa-clock me-2"></i>Поточний час: <span id="current-time-display"><?php
                                    // Показуємо поточну дату та час з урахуванням вибраного часового поясу
                                    $displayTimezone = !empty($currentTimezone) ? $currentTimezone : (function_exists('getTimezoneFromDatabase') ? getTimezoneFromDatabase() : 'UTC');
                                    if (empty($displayTimezone)) {
                                        $displayTimezone = 'UTC';
                                    }

                                    try {
                                        $timezoneObj = new DateTimeZone($displayTimezone);
                                        $now = new DateTime('now', $timezoneObj);
                                        $currentDateTime = $now->format('d.m.Y H:i:s');
                                        echo htmlspecialchars($currentDateTime);
                                    } catch (Exception $e) {
                                        // Якщо не вдалося створити DateTimeZone, показуємо системний час
                                        $currentDateTime = date('d.m.Y H:i:s');
                                        echo htmlspecialchars($currentDateTime);
                                    }
                                    ?></span>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label for="siteLanguage" class="form-label fw-medium small">
                                Мова сайту
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <select class="form-select <?= $readonlyClass ?>" id="siteLanguage" name="settings[site_language]" <?= $readonlyAttr ?>>
                                <option value="uk" <?= ($settings['site_language'] ?? 'uk') === 'uk' ? 'selected' : '' ?>>Українська</option>
                                <option value="en" <?= ($settings['site_language'] ?? '') === 'en' ? 'selected' : '' ?>>English</option>
                                <option value="ru" <?= ($settings['site_language'] ?? '') === 'ru' ? 'selected' : '' ?>>Русский</option>
                            </select>
                            <div class="form-text small"><i class="fas fa-globe me-1"></i>Основна мова сайту</div>
                        </div>
                        <div class="col-md-6">
                            <label for="dateFormat" class="form-label fw-medium small">
                                Формат дати
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <select class="form-select <?= $readonlyClass ?>" id="dateFormat" name="settings[date_format]" <?= $readonlyAttr ?>>
                                <option value="d.m.Y" <?= ($settings['date_format'] ?? 'd.m.Y') === 'd.m.Y' ? 'selected' : '' ?>>дд.мм.рррр (01.12.2025)</option>
                                <option value="Y-m-d" <?= ($settings['date_format'] ?? '') === 'Y-m-d' ? 'selected' : '' ?>>рррр-мм-дд (2025-12-01)</option>
                                <option value="d/m/Y" <?= ($settings['date_format'] ?? '') === 'd/m/Y' ? 'selected' : '' ?>>дд/мм/рррр (01/12/2025)</option>
                                <option value="m/d/Y" <?= ($settings['date_format'] ?? '') === 'm/d/Y' ? 'selected' : '' ?>>мм/дд/рррр (12/01/2025)</option>
                            </select>
                            <div class="form-text small"><i class="fas fa-calendar me-1"></i>Формат відображення дати</div>
                        </div>
                        <div class="col-md-6">
                            <label for="timeFormat" class="form-label fw-medium small">
                                Формат часу
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <select class="form-select <?= $readonlyClass ?>" id="timeFormat" name="settings[time_format]" <?= $readonlyAttr ?>>
                                <option value="H:i:s" <?= ($settings['time_format'] ?? 'H:i:s') === 'H:i:s' ? 'selected' : '' ?>>24 години (19:30:45)</option>
                                <option value="H:i" <?= ($settings['time_format'] ?? '') === 'H:i' ? 'selected' : '' ?>>24 години без секунд (19:30)</option>
                                <option value="h:i:s A" <?= ($settings['time_format'] ?? '') === 'h:i:s A' ? 'selected' : '' ?>>12 годин (07:30:45 PM)</option>
                                <option value="h:i A" <?= ($settings['time_format'] ?? '') === 'h:i A' ? 'selected' : '' ?>>12 годин без секунд (07:30 PM)</option>
                            </select>
                            <div class="form-text small"><i class="fas fa-clock me-1"></i>Формат відображення часу</div>
                        </div>
                        <div class="col-md-6">
                            <label for="weekStartsOn" class="form-label fw-medium small">
                                Тиждень починається з
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <select class="form-select <?= $readonlyClass ?>" id="weekStartsOn" name="settings[week_starts_on]" <?= $readonlyAttr ?>>
                                <option value="1" <?= ($settings['week_starts_on'] ?? '1') === '1' ? 'selected' : '' ?>>Понеділок</option>
                                <option value="0" <?= ($settings['week_starts_on'] ?? '') === '0' ? 'selected' : '' ?>>Неділя</option>
                            </select>
                            <div class="form-text small"><i class="fas fa-calendar-week me-1"></i>Перший день тижня</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Користувачі та доступ -->
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6>
                        <i class="fas fa-users me-2 text-primary"></i>Користувачі та доступ
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label fw-medium small d-block mb-2">
                                Членство
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <div class="form-check form-switch">
                                <input class="form-check-input"
                                       type="checkbox"
                                       id="usersCanRegister"
                                       name="settings[users_can_register]"
                                       value="1"
                                       <?= ($settings['users_can_register'] ?? '1') === '1' ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label fw-medium" for="usersCanRegister">
                                    Реєструватись може кожен
                                </label>
                            </div>
                            <div class="form-text small mt-1"><i class="fas fa-user-plus me-1"></i>Дозволити реєстрацію нових користувачів</div>
                        </div>
                        <div class="col-md-6">
                            <label for="defaultUserRole" class="form-label fw-medium small">
                                Роль нового користувача за замовчуванням
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <select class="form-select <?= $readonlyClass ?>" id="defaultUserRole" name="settings[default_user_role]" <?= $readonlyAttr ?>>
                                <?php
                                $selectedRole = $settings['default_user_role'] ?? '2';
                                if (isset($roles) && is_array($roles)) {
                                    foreach ($roles as $role) {
                                        $roleId = (int)($role['id'] ?? 0);
                                        $roleName = htmlspecialchars($role['name'] ?? '');
                                        $selected = ($roleId == $selectedRole) ? 'selected' : '';
                                        echo '<option value="' . $roleId . '" ' . $selected . '>' . $roleName . '</option>';
                                    }
                                } else {
                                    echo '<option value="2" ' . ($selectedRole == '2' ? 'selected' : '') . '>Користувач</option>';
                                }
                                ?>
                            </select>
                            <div class="form-text small"><i class="fas fa-user-tag me-1"></i>Роль, яку отримує новий користувач під час реєстрації</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Безпека та сесії -->
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6>
                        <i class="fas fa-shield-alt me-2 text-primary"></i>Безпека та сесії
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="sessionLifetime" class="form-label fw-medium small">
                                Час життя сесії (секунди)
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <input type="number"
                                   class="form-control <?= $readonlyClass ?>"
                                   id="sessionLifetime"
                                   name="settings[session_lifetime]"
                                   value="<?= htmlspecialchars($settings['session_lifetime'] ?? '7200') ?>"
                                   min="60"
                                   step="60"
                                   placeholder="7200"
                                   <?= $readonlyAttr ?>>
                            <div class="form-text small"><i class="fas fa-hourglass-half me-1"></i>Час життя сесії користувача (за замовчуванням: 7200 сек = 2 години)</div>
                        </div>
                        <div class="col-md-6">
                            <label for="cookieLifetime" class="form-label fw-medium small">
                                Час життя куків (секунди)
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <input type="number"
                                   class="form-control <?= $readonlyClass ?>"
                                   id="cookieLifetime"
                                   name="settings[cookie_lifetime]"
                                   value="<?= htmlspecialchars($settings['cookie_lifetime'] ?? '86400') ?>"
                                   min="60"
                                   step="60"
                                   placeholder="86400"
                                   <?= $readonlyAttr ?>>
                            <div class="form-text small"><i class="fas fa-cookie me-1"></i>Час життя куків (за замовчуванням: 86400 сек = 24 години)</div>
                        </div>
                        <div class="col-md-6">
                            <label for="cookiePath" class="form-label fw-medium small">
                                Шлях для куків
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <input type="text"
                                   class="form-control <?= $readonlyClass ?>"
                                   id="cookiePath"
                                   name="settings[cookie_path]"
                                   value="<?= htmlspecialchars($settings['cookie_path'] ?? '/') ?>"
                                   placeholder="/"
                                   <?= $readonlyAttr ?>>
                            <div class="form-text small"><i class="fas fa-route me-1"></i>Шлях на сервері, для якого доступні куки</div>
                        </div>
                        <div class="col-md-6">
                            <label for="cookieDomain" class="form-label fw-medium small">
                                Домен для куків
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <input type="text"
                                   class="form-control <?= $readonlyClass ?>"
                                   id="cookieDomain"
                                   name="settings[cookie_domain]"
                                   value="<?= htmlspecialchars($settings['cookie_domain'] ?? '') ?>"
                                   placeholder="example.com"
                                   <?= $readonlyAttr ?>>
                            <div class="form-text small"><i class="fas fa-globe me-1"></i>Домен, для якого доступні куки (залиште порожнім для поточного домену)</div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-medium small d-block mb-2">
                                Безпечні куки (HTTPS only)
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <div class="form-check form-switch">
                                <input class="form-check-input"
                                       type="checkbox"
                                       id="cookieSecure"
                                       name="settings[cookie_secure]"
                                       value="1"
                                       <?= ($settings['cookie_secure'] ?? '0') === '1' ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label fw-medium" for="cookieSecure">
                                    Безпечні куки (HTTPS only)
                                </label>
                            </div>
                            <div class="form-text small mt-1"><i class="fas fa-lock me-1"></i>Куки будуть передаватись тільки через HTTPS</div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-medium small d-block mb-2">
                                HttpOnly куки
                                <span class="badge bg-warning text-dark ms-2">В розробці</span>
                            </label>
                            <div class="form-check form-switch">
                                <input class="form-check-input"
                                       type="checkbox"
                                       id="cookieHttpOnly"
                                       name="settings[cookie_httponly]"
                                       value="1"
                                       <?= ($settings['cookie_httponly'] ?? '1') === '1' ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label fw-medium" for="cookieHttpOnly">
                                    HttpOnly куки
                                </label>
                            </div>
                            <div class="form-text small mt-1"><i class="fas fa-shield-alt me-1"></i>Запобігає доступу до куків через JavaScript</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Продуктивність -->
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6>
                        <i class="fas fa-database me-2 text-primary"></i>Продуктивність
                    </h6>
                    <div class="form-check form-switch">
                        <input class="form-check-input"
                               type="checkbox"
                               id="cacheEnabled"
                               name="settings[cache_enabled]"
                               value="1"
                               <?= ($settings['cache_enabled'] ?? '1') === '1' ? 'checked' : '' ?>
                               <?= $readonlyAttr ?>
                               title="Увімкнути кешування">
                    </div>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="cacheDefaultTtl" class="form-label fw-medium small">Час життя кешу (секунди)</label>
                            <input type="number"
                                   class="form-control <?= $readonlyClass ?>"
                                   id="cacheDefaultTtl"
                                   name="settings[cache_default_ttl]"
                                   value="<?= htmlspecialchars($settings['cache_default_ttl'] ?? '3600') ?>"
                                   min="60"
                                   step="60"
                                   placeholder="3600"
                                   <?= $readonlyAttr ?>>
                            <div class="form-text small"><i class="fas fa-hourglass-half me-1"></i>Стандартний час життя кешу (за замовчуванням: 3600 сек = 1 година)</div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-medium small d-block mb-2">Автоматична очистка</label>
                            <div class="form-check form-switch">
                                <input class="form-check-input"
                                       type="checkbox"
                                       id="cacheAutoCleanup"
                                       name="settings[cache_auto_cleanup]"
                                       value="1"
                                       <?= ($settings['cache_auto_cleanup'] ?? '1') === '1' ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label fw-medium" for="cacheAutoCleanup">
                                    Автоматична очистка застарілого кешу
                                </label>
                            </div>
                            <div class="form-text small mt-1"><i class="fas fa-broom me-1"></i>Автоматично видаляти прострочений кеш</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Логування та діагностика -->
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6>
                        <i class="fas fa-file-alt me-2 text-primary"></i>Логування та діагностика
                    </h6>
                    <div class="form-check form-switch">
                        <input class="form-check-input"
                               type="checkbox"
                               id="loggingEnabled"
                               name="settings[logging_enabled]"
                               value="1"
                               <?= ($settings['logging_enabled'] ?? '1') === '1' ? 'checked' : '' ?>
                               <?= $readonlyAttr ?>
                               title="Увімкнути логування">
                    </div>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label fw-medium small">Рівні логування</label>
                            <?php
                            // Преобразуем в массив, если это строка
                            $selectedLevels = [];
                            if (isset($settings['logging_levels'])) {
                                if (is_array($settings['logging_levels'])) {
                                    $selectedLevels = $settings['logging_levels'];
                                } elseif (!empty($settings['logging_levels'])) {
                                    $selectedLevels = explode(',', $settings['logging_levels']);
                                }
                                // Если пустая строка или пустой массив, оставляем пустым
                            }
?>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="logLevelDebug" name="settings[logging_levels][]" value="DEBUG"
                                       <?= in_array('DEBUG', $selectedLevels) ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label" for="logLevelDebug">
                                    DEBUG - Всі події
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="logLevelInfo" name="settings[logging_levels][]" value="INFO"
                                       <?= in_array('INFO', $selectedLevels) ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label" for="logLevelInfo">
                                    INFO - Інформаційні події
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="logLevelWarning" name="settings[logging_levels][]" value="WARNING"
                                       <?= in_array('WARNING', $selectedLevels) ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label" for="logLevelWarning">
                                    WARNING - Попередження
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="logLevelError" name="settings[logging_levels][]" value="ERROR"
                                       <?= in_array('ERROR', $selectedLevels) ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label" for="logLevelError">
                                    ERROR - Помилки
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="logLevelCritical" name="settings[logging_levels][]" value="CRITICAL"
                                       <?= in_array('CRITICAL', $selectedLevels) ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label" for="logLevelCritical">
                                    CRITICAL - Критичні помилки
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-medium small">Типи логування</label>
                            <?php
                            // Преобразуем в массив, если это строка
                            $selectedTypes = [];
                            if (isset($settings['logging_types'])) {
                                if (is_array($settings['logging_types'])) {
                                    $selectedTypes = $settings['logging_types'];
                                } elseif (!empty($settings['logging_types'])) {
                                    $selectedTypes = explode(',', $settings['logging_types']);
                                }
                                // Если пустая строка или пустой массив, оставляем пустым
                            }
                            ?>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="logToFile" name="settings[logging_types][]" value="file"
                                       <?= in_array('file', $selectedTypes) ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label" for="logToFile">
                                    Логування у файл
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="logToErrorLog" name="settings[logging_types][]" value="error_log"
                                       <?= in_array('error_log', $selectedTypes) ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label" for="logToErrorLog">
                                    Логування в error_log PHP
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="logDbQueries" name="settings[logging_types][]" value="db_queries"
                                       <?= in_array('db_queries', $selectedTypes) ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label" for="logDbQueries">
                                    Логування SQL запитів
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="logDbErrors" name="settings[logging_types][]" value="db_errors"
                                       <?= in_array('db_errors', $selectedTypes) ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label" for="logDbErrors">
                                    Логування помилок БД
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="logSlowQueries" name="settings[logging_types][]" value="slow_queries"
                                       <?= in_array('slow_queries', $selectedTypes) ? 'checked' : '' ?>
                                       <?= $readonlyAttr ?>>
                                <label class="form-check-label" for="logSlowQueries">
                                    Логування повільних запитів
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label for="loggingMaxFileSize" class="form-label fw-medium small">Максимальний розмір файлу (байти)</label>
                            <input type="number"
                                   class="form-control <?= $readonlyClass ?>"
                                   id="loggingMaxFileSize"
                                   name="settings[logging_max_file_size]"
                                   value="<?= htmlspecialchars($settings['logging_max_file_size'] ?? '10485760') ?>"
                                   min="1048576"
                                   step="1048576"
                                   placeholder="10485760"
                                   <?= $readonlyAttr ?>>
                            <div class="form-text small"><i class="fas fa-file me-1"></i>Максимальний розмір файлу логу (за замовчуванням: 10 MB)</div>
                        </div>
                        <div class="col-md-6">
                            <label for="loggingRetentionDays" class="form-label fw-medium small">Зберігати логи (днів)</label>
                            <input type="number"
                                   class="form-control <?= $readonlyClass ?>"
                                   id="loggingRetentionDays"
                                   name="settings[logging_retention_days]"
                                   value="<?= htmlspecialchars($settings['logging_retention_days'] ?? '30') ?>"
                                   min="1"
                                   max="365"
                                   placeholder="30"
                                   <?= $readonlyAttr ?>>
                            <div class="form-text small"><i class="fas fa-calendar me-1"></i>Кількість днів зберігання логів (за замовчуванням: 30 днів)</div>
                        </div>
                        <div class="col-md-6">
                            <label for="loggingRotationType" class="form-label fw-medium small">Тип ротації</label>
                            <select class="form-select <?= $readonlyClass ?>" id="loggingRotationType" name="settings[logging_rotation_type]" <?= $readonlyAttr ?>>
                                <option value="size" <?= ($settings['logging_rotation_type'] ?? 'size') === 'size' ? 'selected' : '' ?>>По розміру</option>
                                <option value="time" <?= ($settings['logging_rotation_type'] ?? 'size') === 'time' ? 'selected' : '' ?>>По часу</option>
                                <option value="both" <?= ($settings['logging_rotation_type'] ?? 'size') === 'both' ? 'selected' : '' ?>>По розміру та часу</option>
                            </select>
                            <div class="form-text small"><i class="fas fa-sync-alt me-1"></i>Коли виконувати ротацію логів</div>
                        </div>
                        <div class="col-md-6" id="rotationTimeGroup" style="display: <?= in_array($settings['logging_rotation_type'] ?? 'size', ['time', 'both']) ? 'block' : 'none' ?>;">
                            <label for="loggingRotationTime" class="form-label fw-medium small">Ротація по часу</label>
                            <div class="input-group">
                                <input type="number"
                                       class="form-control <?= $readonlyClass ?>"
                                       id="loggingRotationTime"
                                       name="settings[logging_rotation_time]"
                                       value="<?= htmlspecialchars($settings['logging_rotation_time'] ?? '24') ?>"
                                       min="1"
                                       placeholder="24"
                                       <?= $readonlyAttr ?>>
                                <select class="form-select <?= $readonlyClass ?>" id="loggingRotationTimeUnit" name="settings[logging_rotation_time_unit]" style="max-width: 120px;" <?= $readonlyAttr ?>>
                                    <option value="hours" <?= ($settings['logging_rotation_time_unit'] ?? 'hours') === 'hours' ? 'selected' : '' ?>>Годин</option>
                                    <option value="days" <?= ($settings['logging_rotation_time_unit'] ?? 'hours') === 'days' ? 'selected' : '' ?>>Днів</option>
                                </select>
                            </div>
                            <div class="form-text small">Період ротації логів по часу</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- JavaScript винесений в scripts/site-settings.js -->

    </div>

    <!-- Кнопки действий -->
    <div class="form-actions mt-4 mb-3">
        <div class="d-flex justify-content-end gap-2">
            <button type="submit" class="btn btn-primary" <?= ! $hasEditAccess ? 'disabled' : '' ?>>
                <i class="fas fa-save me-2"></i>Зберегти налаштування
            </button>
        </div>
    </div>
</form>
</div>

<!-- Стилі винесені в SCSS: pages/_site-settings.scss -->
