<?php
/**
 * Шаблон страницы настроек (карточки в сетке по категориям)
 *
 * @var array $settingsCategories Категории настроек
 */
?>

<?php foreach ($settingsCategories as $categoryKey => $category): ?>
    <?php if (! empty($category['items'])): ?>
        <div class="settings-category mb-5">
            <h4 class="settings-category-title mb-3">
                <i class="<?= htmlspecialchars($category['icon']) ?> me-2"></i>
                <?= htmlspecialchars($category['title']) ?>
            </h4>
            <div class="row g-3">
                <?php foreach ($category['items'] as $item): ?>
                    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-12">
                        <a href="<?= htmlspecialchars($item['url']) ?>" class="settings-card-link">
                            <div class="settings-card">
                                <div class="settings-card-icon">
                                    <i class="<?= htmlspecialchars($item['icon']) ?>"></i>
                                </div>
                                <div class="settings-card-content">
                                    <h5 class="settings-card-title"><?= htmlspecialchars($item['title']) ?></h5>
                                    <p class="settings-card-description"><?= htmlspecialchars($item['description'] ?? '') ?></p>
                                </div>
                                <div class="settings-card-arrow">
                                    <i class="fas fa-arrow-right"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
<?php endforeach; ?>

<!-- Стилі винесені в SCSS: pages/_settings.scss -->
