<?php
/**
 * Страница настроек (функция вместо класса)
 *
 * Примечание: Авторизация обрабатывается автоматически через middleware 'admin.auth'
 * Разработчикам не нужно проверять авторизацию вручную - фреймворк делает это автоматически
 */

function admin_settings_page() {

    // Получаем категории настроек через хуки
    $settingsCategories = get_default_settings_categories();

    if (function_exists('apply_filters')) {
        $settingsCategories = apply_filters('settings_categories', $settingsCategories);
    }

    // Фильтруем элементы по правам доступа
    foreach ($settingsCategories as $key => $category) {
        if (isset($category['items']) && is_array($category['items'])) {
            $settingsCategories[$key]['items'] = array_filter($category['items'], function ($item) {
                if (isset($item['permission']) && $item['permission'] !== null) {
                    $session = function_exists('sessionManager') ? sessionManager() : null;
                    $userId = $session ? (int)($session->get('admin_user_id') ?? 0) : 0;
                    // Root пользователь (userId = 0) и первый пользователь (userId = 1) имеют полный доступ
                    if ($userId === 0 || $userId === 1) {
                        return true;
                    }
                    return function_exists('current_user_can') && current_user_can($item['permission']);
                }
                return true;
            });
        }
    }

    // Удаляем пустые категории
    $settingsCategories = array_filter($settingsCategories, function ($category) {
        return !empty($category['items']);
    });

    $data = get_content_data('settings_data', [
        'settingsCategories' => $settingsCategories,
    ]);

    $layout = [
        'title' => 'Налаштування - Flowaxy CMS',
        'content' => render_settings_content($data),
        'pageHeaderIcon' => 'fas fa-cog',
        'pageBreadcrumbs' => [
            ['title' => 'Головна', 'url' => admin_url('dashboard'), 'page' => 'dashboard'],
            ['title' => 'Налаштування', 'page' => 'settings'],
        ],
    ];

    return render_admin_layout($layout);
}

function render_settings_content($data) {
    ob_start();
    $templatePath = __DIR__ . DS . 'settings' . DS . 'template.php';
    if (file_exists($templatePath)) {
        extract($data);
        include $templatePath;
    }
    return ob_get_clean();
}

function get_default_settings_categories() {
    return [
        'system' => [
            'title' => 'Система',
            'icon' => 'fas fa-server',
            'items' => [
                [
                    'title' => 'Налаштування сайту',
                    'description' => 'Основні налаштування сайту',
                    'url' => admin_url('site-settings'),
                    'icon' => 'fas fa-globe',
                    'permission' => 'admin.settings.manage',
                ],
                [
                    'title' => 'База даних',
                    'description' => 'Управління підключенням до бази даних',
                    'url' => admin_url('database'),
                    'icon' => 'fas fa-database',
                    'permission' => 'admin.settings.manage',
                ],
                [
                    'title' => 'Користувачі',
                    'description' => 'Управління користувачами',
                    'url' => admin_url('users'),
                    'icon' => 'fas fa-users',
                    'permission' => 'admin.users.manage',
                ],
                [
                    'title' => 'Ролі та права',
                    'description' => 'Управління ролями та правами доступу',
                    'url' => admin_url('roles'),
                    'icon' => 'fas fa-user-shield',
                    'permission' => 'admin.roles.manage',
                ],
            ],
        ],
    ];
}
