<?php
/**
 * Страница профиля пользователя (функция вместо класса)
 */

function admin_profile_page() {
    // Проверка авторизации
    if (!function_exists('is_admin_logged_in') || !is_admin_logged_in()) {
        if (function_exists('admin_redirect')) {
            admin_redirect('login');
        }
        return;
    }

    // Обработка POST запросов
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_profile'])) {
        handle_save_profile();
    }

    // Получаем данные текущего пользователя
    $user = get_current_admin_user();

    $data = get_content_data('profile_data', [
        'user' => $user,
    ]);

    $layout = [
        'title' => 'Профіль користувача - Flowaxy CMS',
        'content' => render_profile_content($data),
        'pageHeaderIcon' => 'fas fa-user',
        'pageBreadcrumbs' => [
            ['title' => 'Головна', 'url' => admin_url('dashboard'), 'page' => 'dashboard'],
            ['title' => 'Профіль користувача', 'page' => 'profile'],
        ],
        'additionalJS' => [
            asset('scripts/profile.js'),
        ],
    ];

    return render_admin_layout($layout);
}

function render_profile_content($data) {
    ob_start();
    $templatePath = __DIR__ . DS . 'profile' . DS . 'template.php';
    if (file_exists($templatePath)) {
        extract($data);
        include $templatePath;
    }
    return ob_get_clean();
}

function get_current_admin_user() {
    $session = function_exists('sessionManager') ? sessionManager() : null;
    $userId = $session ? (int)($session->get('admin_user_id') ?? 0) : 0;

    if (!$userId) {
        return null;
    }

    return db_fetch_one('SELECT id, username, email FROM users WHERE id = ?', [$userId]);
}

function handle_save_profile() {
    $session = function_exists('sessionManager') ? sessionManager() : null;
    $userId = $session ? (int)($session->get('admin_user_id') ?? 0) : 0;

    if (!$userId) {
        set_flash_message('Користувач не знайдено', 'danger');
        return;
    }

    $email = sanitize_input($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($email)) {
        set_flash_message('Email обов\'язковий', 'danger');
        return;
    }

    // Обновляем email
    $stmt = db_query('UPDATE users SET email = ? WHERE id = ?', [$email, $userId]);

    // Обновляем пароль если указан
    if (!empty($password)) {
        if (strlen($password) < 8) {
            set_flash_message('Пароль має бути не менше 8 символів', 'danger');
            return;
        }
        $passwordHash = password_hash($password, PASSWORD_DEFAULT);
        db_query('UPDATE users SET password = ? WHERE id = ?', [$passwordHash, $userId]);
    }

    if ($stmt) {
        set_flash_message('Профіль успішно оновлено', 'success');
        admin_redirect('profile');
    } else {
        set_flash_message('Помилка при оновленні профілю', 'danger');
    }
}
