<?php
/**
 * Шаблон сторінки управління плагінами
 * Стиль як у cache-view: статистичні картки зверху, список плагінів, інформаційний блок
 */
$componentsPath = $componentsPath ?? (__DIR__ . DS . '..' . DS . '..' . DS . 'components' . DS);
$stats = $stats ?? [
    'total' => 0,
    'installed' => 0,
    'active' => 0,
    'inactive' => 0,
];
$installedPlugins = $installedPlugins ?? [];

// Получаем flash сообщения из сессии
$session = function_exists('sessionManager') ? sessionManager() : null;
$flashMessage = null;
$flashMessageType = 'info';
if ($session !== null) {
    // Используем flash() для получения flash-сообщения (автоматически удаляется после чтения)
    if (method_exists($session, 'flash')) {
        $flashMessage = $session->flash('admin_message');
        $flashMessageType = $session->flash('admin_message_type', 'info');
    } else {
        // Fallback: используем get и затем forget
        $flashMessage = $session->get('admin_message');
        $flashMessageType = $session->get('admin_message_type', 'info');
        if ($flashMessage !== null) {
            $session->forget('admin_message');
            $session->forget('admin_message_type');
        }
    }
}

// Показуємо кастомне уведомлення замість стандартного alert
$message = $message ?? $flashMessage;
if (!empty($message)) {
    $type = $messageType ?? 'info';
    // JavaScript функция showNotification использует innerHTML, поэтому HTML будет работать
    // Используем json_encode БЕЗ JSON_HEX_TAG, чтобы HTML-теги передавались правильно
    $messageJson = json_encode($message, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    $typeEscaped = htmlspecialchars($type, ENT_QUOTES, 'UTF-8');
    echo '<div id="notification-data" data-message=' . $messageJson . ' data-type="' . $typeEscaped . '" style="display: none;"></div>';
}
?>
<div class="plugins-page">
    <!-- Статистичні картки -->
    <div class="plugins-stats-section">
        <?php
        $cards = [
            [
                'title' => 'Всього плагінів',
                'value' => number_format($stats['total'], 0, ',', ' '),
                'icon' => 'puzzle-piece',
                'color' => 'primary'
            ],
            [
                'title' => 'Встановлено',
                'value' => number_format($stats['installed'], 0, ',', ' '),
                'icon' => 'check-circle',
                'color' => 'info'
            ],
            [
                'title' => 'Активні',
                'value' => $stats['active'] > 0
                    ? '<span class="text-success">' . number_format($stats['active'], 0, ',', ' ') . '</span>'
                    : '<span class="text-muted">0</span>',
                'icon' => 'power-off',
                'color' => $stats['active'] > 0 ? 'success' : 'secondary',
                'valueClass' => 'h5'
            ],
            [
                'title' => 'Неактивні',
                'value' => $stats['inactive'] > 0
                    ? '<span class="text-warning">' . number_format($stats['inactive'], 0, ',', ' ') . '</span>'
                    : '<span class="text-muted">0</span>',
                'icon' => 'pause-circle',
                'color' => $stats['inactive'] > 0 ? 'warning' : 'secondary',
                'valueClass' => 'h5'
            ]
        ];
        // Використовуємо компонент stats-cards якщо він є
        $statsCardsPath = $componentsPath . 'layout' . DS . 'stats-cards.php';
        if (file_exists($statsCardsPath)) {
            include $statsCardsPath;
        } else {
            // Fallback - виводимо картки напряму з іконками (якщо компонент не знайдено)
            echo '<div class="stats-cards"><div class="row g-3">';
            foreach ($cards as $card) {
                $icon = $card['icon'] ?? '';
                $color = $card['color'] ?? 'primary';
                $valueClass = $card['valueClass'] ?? 'h4';
                $colorMap = [
                    'primary' => '#0073aa',
                    'info' => '#00a0d2',
                    'success' => '#46b450',
                    'warning' => '#ffb900',
                    'danger' => '#dc3232',
                    'secondary' => '#646970'
                ];
                $iconColor = $colorMap[$color] ?? $colorMap['primary'];
                echo '<div class="col-md-3">';
                echo '<div class="card border-left-' . htmlspecialchars($color) . ' h-100">';
                echo '<div class="card-body">';
                echo '<div class="row align-items-center">';
                echo '<div class="col">';
                echo '<div class="stats-card-title">' . htmlspecialchars($card['title']) . '</div>';
                echo '<div class="stats-card-value ' . htmlspecialchars($valueClass) . ' mb-0 font-weight-bold">' . $card['value'] . '</div>';
                echo '</div>';
                if (!empty($icon)) {
                    echo '<div class="col-auto">';
                    echo '<i class="fas fa-' . htmlspecialchars($icon) . ' stats-card-icon" style="color: ' . htmlspecialchars($iconColor) . ';"></i>';
                    echo '</div>';
                }
                echo '</div>';
                echo '</div></div></div>';
            }
            echo '</div></div>';
        }
        ?>
    </div>

    <!-- Список плагінів -->
    <div class="plugins-list-section">
        <div class="card border-0">
            <div class="card-body p-0">
                <?php if (!empty($installedPlugins)): ?>
                    <div class="plugins-list">
                        <div class="row">
                            <?php foreach ($installedPlugins as $plugin): ?>
                                <?php
                                $colClass = 'col-12 col-sm-6 col-lg-4 col-xl-3';
                                // Використовуємо універсальний компонент package-card якщо він є
                                $type = 'plugin';
                                $package = $plugin;
                                $packageCardPath = $componentsPath . 'layout' . DS . 'package-card.php';
                                if (file_exists($packageCardPath)) {
                                    include $packageCardPath;
                                } else {
                                    // Fallback - простий вивід
                                    echo '<div class="' . $colClass . ' mb-3">';
                                    echo '<div class="card">';
                                    echo '<div class="card-body">';
                                    echo '<h5>' . htmlspecialchars($plugin['name'] ?? 'Unknown') . '</h5>';
                                    echo '<p class="text-muted small">' . htmlspecialchars($plugin['description'] ?? '') . '</p>';
                                    echo '</div></div></div>';
                                }
                                ?>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php else: ?>
                    <?php
                    // Порожній стан
                    $icon = 'puzzle-piece';
                    $title = 'Плагіни відсутні';
                    $message = 'Встановіть плагін за замовчуванням або завантажте новий плагін з маркетплейсу.';
                    if (file_exists($componentsPath . 'layout' . DS . 'empty-state.php')) {
                        include $componentsPath . 'layout' . DS . 'empty-state.php';
                    } else {
                        echo '<div class="alert alert-info">' . htmlspecialchars($message) . '</div>';
                    }
                    ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Інформаційний блок -->
    <div class="plugins-info-section">
        <?php
        $title = 'Про плагіни';
        $titleIcon = 'info-circle';
        $sections = [
            [
                'title' => 'Що таке плагіни:',
                'icon' => 'question-circle',
                'iconColor' => 'primary',
                'items' => [
                    'Розширюють функціональність системи',
                    'Дозволяють додавати нові можливості без змін ядра',
                    'Можуть бути активовані та деактивовані в будь-який час',
                    'Встановлюються через ZIP архів з файлом plugin.php'
                ]
            ],
            [
                'title' => 'Управління плагінами:',
                'icon' => 'cog',
                'iconColor' => 'info',
                'items' => [
                    'Активуйте плагіни для їх використання',
                    'Деактивуйте перед видаленням',
                    'Перевіряйте сумісність з версією системи',
                    'Регулярно оновлюйте для безпеки та нових функцій'
                ]
            ]
        ];
        if (file_exists($componentsPath . 'layout' . DS . 'info-block.php')) {
            include $componentsPath . 'layout' . DS . 'info-block.php';
        }
        ?>
    </div>
</div>

<!-- Модальное окно для загрузки плагина -->
<div class="modal fade" id="uploadPluginModal" tabindex="-1" aria-labelledby="uploadPluginModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="uploadPluginModalLabel">
                    <i class="fas fa-upload"></i> Завантажити плагін
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="uploadPluginForm" method="POST" enctype="multipart/form-data" action="<?= admin_url('plugins') ?>">
                <div class="modal-body">
                    <input type="hidden" name="csrf_token" value="<?= class_exists('\Flowaxy\Support\Helpers\SecurityHelper') ? \Flowaxy\Support\Helpers\SecurityHelper::csrfToken() : (function_exists('csrf_token') ? csrf_token() : '') ?>">
                    <input type="hidden" name="action" value="upload_plugin">

                    <div class="mb-3">
                        <label for="plugin_file" class="form-label">ZIP архіви з плагінами</label>
                        <input type="file" class="form-control" id="plugin_file" name="plugin_file[]" accept=".zip" multiple>
                        <div class="form-text">Можна вибрати декілька ZIP-архівів. Максимальний розмір: 50 МБ</div>
                    </div>

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> Плагін повинен містити файл <code>plugin.php</code> з метаданими.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Скасувати</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload"></i> Завантажити
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- JavaScript винесений в scripts/plugins.js -->

<!-- Стилі винесені в SCSS: pages/_packages.scss -->
