<?php

declare(strict_types=1);

/**
 * Страница выхода из админки (функция вместо класса)
 * Оптимизировано для PHP 8.4+
 */

/**
 * @return never
 */
function admin_logout_page(): never {
    // Выход из системы через функцию-хелпер
    if (function_exists('admin_logout')) {
        admin_logout();
    }

    // Перенаправляем на страницу входа
    if (function_exists('admin_redirect')) {
        admin_redirect('login');
    } else {
        header('Location: ' . admin_url('login'));
        exit;
    }
}
