<?php

declare(strict_types=1);

/**
 * Страница Dashboard (функция вместо класса)
 * Оптимизировано для PHP 8.4+
 */

/**
 * @param array<string, mixed> $params
 * @return string|null
 */
/**
 * @param array<string, mixed> $params
 * @return string|null
 */
function admin_dashboard_page(array $params = []): ?string {
    /**
     * Примечание: Авторизация обрабатывается автоматически через middleware 'admin.auth'
     * Разработчикам не нужно проверять авторизацию вручную - фреймворк делает это автоматически
     */

    // Получаем данные для dashboard через хуки
    $data = [];
    if (function_exists('apply_filters')) {
        $data = apply_filters('dashboard_data', $data);
    }

    // Рендерим страницу через layout
    $layout = [
        'title' => 'Панель управління - Flowaxy CMS',
        'content' => render_dashboard_content($data),
    ];

    return render_admin_layout($layout);
}

/**
 * @param array<string, mixed> $data
 * @return string
 */
function render_dashboard_content(array $data): string {
    ob_start();
    $templatePath = __DIR__ . DS . 'dashboard' . DS . 'template.php';
    if (file_exists($templatePath)) {
        include $templatePath;
    }
    return ob_get_clean();
}
