<!DOCTYPE html>
<html lang="uk">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title ?? 'Адмін-панель', ENT_QUOTES, 'UTF-8') ?></title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?= asset('images/brand/favicon.png') ?>">
    <link rel="shortcut icon" type="image/png" href="<?= asset('images/brand/favicon.png') ?>">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?= asset('library/bootstrap/bootstrap.min.css') ?>">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?= asset('library/font-awesome/css/all.min.css') ?>">

    <!-- Flowaxy Admin CSS -->
    <?php
    // SCSS компілюється ТІЛЬКИ через CLI-команду (без автокомпіляції під час HTTP-запиту)
    $flowaxyCssUrl = asset('styles/flowaxy.css');
    ?>

    <link rel="stylesheet" href="<?= $flowaxyCssUrl ?>">
    <!-- <link rel="stylesheet" href="<?= asset('styles/source.css') ?>"> -->
    <link rel="stylesheet" href="<?= asset('styles/css-fixes.css') ?>">


    <?php if (!empty($additionalCSS ?? [])): ?>
        <!-- Додаткові CSS файли -->
        <?php foreach ($additionalCSS as $css): ?>
            <link rel="stylesheet" href="<?= htmlspecialchars($css, ENT_QUOTES, 'UTF-8') ?>">
        <?php endforeach; ?>
    <?php endif; ?>

    <?php if (!empty($additionalInlineCSS ?? '')): ?>
        <style>
            <?= $additionalInlineCSS ?>
        </style>
    <?php endif; ?>
</head>
<body class="admin-body">
    <?php
    // Загружаем partial Header
    $headerPath = __DIR__ . DS . '..' . DS . 'partials' . DS . 'header.php';
    if (file_exists($headerPath)) {
        include $headerPath;
    }
    ?>

    <div class="container-fluid">
        <div class="row">
            <?php
            // Загружаем partial Sidebar
            $sidebarPath = __DIR__ . DS . '..' . DS . 'partials' . DS . 'sidebar.php';
            if (file_exists($sidebarPath)) {
                include $sidebarPath;
            }
            ?>

            <main class="col-md-9 ms-sm-auto col-lg-10">
                <div class="admin-content-container">
                    <?php
                    // Загружаем компонент Breadcrumbs с поддержкой иконки и кнопки
                    if (!empty($pageBreadcrumbs ?? [])) {
                        includeComponent('layout/breadcrumbs', [
                            'pageBreadcrumbs' => $pageBreadcrumbs,
                            'pageBreadcrumbIcon' => $pageHeaderIcon ?? '',
                            'pageBreadcrumbButtons' => $pageHeaderButtons ?? '',
                        ]);
                    }
                    ?>

                    <!-- Основной контент страницы -->
                    <?php
                    // Если есть кастомный шаблон плагина, используем его
                    if (isset($customTemplateFile) && file_exists($customTemplateFile)) {
                        include $customTemplateFile;
                    } elseif (!empty($templateName ?? '')) {
                        // Иначе используем стандартный шаблон
                        $templateFile = __DIR__ . DS . $templateName . '.php';
                        if (file_exists($templateFile)) {
                            include $templateFile;
                        }
                    } elseif (isset($content)) {
                        // Если передан контент напрямую
                        echo $content;
                    }
                    ?>
                </div>
            </main>
        </div>
    </div>

    <?php
    // Загружаем partial Footer
    $footerPath = __DIR__ . DS . '..' . DS . 'partials' . DS . 'footer.php';
    if (file_exists($footerPath)) {
        include $footerPath;
    }
    ?>

    <?php
    // Загружаем компонент Notifications
    includeComponent('notification/notifications');
    ?>

    <?php
    // Загружаем компонент Scripts
    includeComponent('layout/scripts');
    ?>

    <!-- Flowaxy Admin JS подключается через компонент layout/scripts -->

    <?php if (!empty($additionalJS ?? [])): ?>
        <!-- Додаткові JS файли -->
        <?php foreach ($additionalJS as $js): ?>
            <script src="<?= htmlspecialchars($js, ENT_QUOTES, 'UTF-8') ?>"></script>
        <?php endforeach; ?>
    <?php endif; ?>
</body>
</html>
