<!DOCTYPE html>
<html lang="uk">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Вхід в адмін-панель - Flowaxy CMS</title>
    <link href="<?= asset('library/bootstrap/bootstrap.min.css') ?>" rel="stylesheet">
    <link href="<?= asset('library/font-awesome/css/all.min.css') ?>" rel="stylesheet">
    <?php
    // SCSS компілюється ТІЛЬКИ через CLI-команду (без автокомпіляції під час HTTP-запиту)
    $flowaxyCssUrl = asset('styles/flowaxy.css');
    ?>
    <link rel="stylesheet" href="<?= $flowaxyCssUrl ?>">
</head>
<body class="login-page">
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <div class="logo-icon">
                    <i class="fas fa-shield-halved"></i>
                </div>
                <h1>Flowaxy CMS</h1>
                <p>Адміністративна панель</p>
            </div>

            <div class="login-body">
                <?php if (!empty($error ?? '')): ?>
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        <?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8') ?>
                    </div>
                <?php endif; ?>

                <?php if (isset($_GET['message']) && $_GET['message'] === 'session_expired'): ?>
                    <div class="alert alert-warning" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Ваш аккаунт був використаний з іншого пристрою або браузера. Будь ласка, увійдіть знову.
                    </div>
                <?php endif; ?>

                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrfToken ?? '', ENT_QUOTES, 'UTF-8') ?>">

                    <div class="form-group">
                        <label for="username" class="form-label">Логін</label>
                        <div class="input-wrapper">
                            <i class="fas fa-user input-icon"></i>
                            <input
                                type="text"
                                class="form-control"
                                id="username"
                                name="username"
                                placeholder="Введіть ваш логін"
                                required
                                autofocus
                            >
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password" class="form-label">Пароль</label>
                        <div class="input-wrapper">
                            <i class="fas fa-lock input-icon"></i>
                            <input
                                type="password"
                                class="form-control"
                                id="password"
                                name="password"
                                placeholder="Введіть ваш пароль"
                                required
                            >
                        </div>
                    </div>

                    <button type="submit" class="btn btn-login">
                        <i class="fas fa-sign-in-alt me-2"></i>Увійти в систему
                    </button>
                </form>

                <div class="security-badge">
                    <small>
                        <?php if (isset($isSecureConnection) && $isSecureConnection): ?>
                            <i class="fas fa-shield-alt" style="color: #27ae60;"></i>
                            <span style="color: #27ae60;">Захищено SSL та CSRF токеном</span>
                        <?php else: ?>
                            <i class="fas fa-shield-alt" style="color: #f39c12;"></i>
                            <span style="color: #f39c12;">Захищено CSRF токеном</span>
                        <?php endif; ?>
                    </small>
                </div>
            </div>
        </div>

        <div class="back-link">
            <a href="/">
                <i class="fas fa-arrow-left"></i>
                Повернутися на сайт
            </a>
        </div>
    </div>
</body>
</html>
