<?php
/**
 * Функции для работы с компонентами админки
 * Используют хелперы фреймворка для рендеринга из массивов конфигурации
 */

declare(strict_types=1);

if (!defined('DS')) {
    define('DS', DIRECTORY_SEPARATOR);
}

/**
 * Рендеринг кнопки из массива конфигурации
 */
if (!function_exists('render_button')) {
    function render_button(array $config): void {
    if (class_exists('\Flowaxy\Support\Helpers\ButtonHelper')) {
        echo \Flowaxy\Support\Helpers\ButtonHelper::render($config);
    } else {
        // Fallback - используем include файл
        extract($config, EXTR_SKIP);
        include __DIR__ . DS . '..' . DS . 'components' . DS . 'button' . DS . 'button.php';
    }
}
}

/**
 * Рендеринг уведомления из массива конфигурации
 */
if (!function_exists('render_notification')) {
    function render_notification(array $config): void {
    if (class_exists('\Flowaxy\Support\Helpers\NotificationHelper')) {
        echo \Flowaxy\Support\Helpers\NotificationHelper::render($config);
    } else {
        // Fallback - используем include файл
        extract($config, EXTR_SKIP);
        include __DIR__ . DS . '..' . DS . 'components' . DS . 'notification' . DS . 'alert.php';
    }
}
}

/**
 * Рендеринг формы из массива конфигурации
 */
if (!function_exists('render_form')) {
    function render_form(array $config): void {
    if (class_exists('\Flowaxy\Support\Helpers\FormHelper')) {
        echo \Flowaxy\Support\Helpers\FormHelper::render($config);
    }
}
}

/**
 * Рендеринг модального окна из массива конфигурации
 */
if (!function_exists('render_modal')) {
    function render_modal(array $config): void {
    if (class_exists('\Flowaxy\Support\Helpers\ModalHelper')) {
        echo \Flowaxy\Support\Helpers\ModalHelper::render($config);
    }
}
}
