<?php

/** @phpstan-ignore-file */

// Используем функции-хелперы для работы с путями (изоляция от фреймворка)
// Функции должны быть загружены фреймворком перед загрузкой этого файла
if (!function_exists('path_content_admin')) {
    // Функции-хелперы должны быть загружены фреймворком
    return;
}

// Завантажуємо функции страниц перед реєстрацією маршрутів
// Используем функции-хелперы вместо прямого обращения к классам
$contentAdminDir = path_content_admin();
$pagesDir = $contentAdminDir . DS . 'pages';
$includesDir = $contentAdminDir . DS . 'includes';

// Завантажуємо вспомогательные функции
$functionsFile = $includesDir . DS . 'functions.php';
if (\file_exists($functionsFile)) {
    require_once $functionsFile;
}

// Завантажуємо всі сторінки адмінки (функции)
$pageFiles = [
    'dashboard.php',
    'login.php',
    'logout.php',
    'settings.php',
    'site-settings.php',
    'database.php',
    'cache-clear.php',
    'profile.php',
    'plugins.php',
    'themes.php',
    'roles.php',
    'users.php',
    'widgets.php',
    'theme-navigation.php',
    'theme-customization.php',
];

foreach ($pageFiles as $pageFile) {
    $pageFilePath = $pagesDir . DS . $pageFile;
    if (\file_exists($pageFilePath) && \is_readable($pageFilePath)) {
        require_once $pageFilePath;
    }
}

// Реєструємо базові маршрути адмінки через функции
// Увага: всі сторінки адмінки повинні підтримувати GET та POST для AJAX запитів
// Використовуємо имена функций
// Middleware 'admin.auth' автоматически применяется ко всем маршрутам кроме login/logout

// Маршруты без авторизации (login/logout)
$router->add(['GET', 'POST'], 'login', 'admin_login_page');
$router->add(['GET', 'POST'], 'logout', 'admin_logout_page');

// Маршруты с авторизацией (middleware применяется автоматически)
$router->add(['GET', 'POST'], '', 'admin_dashboard_page', ['middleware' => ['admin.auth']]);
$router->add(['GET', 'POST'], 'dashboard', 'admin_dashboard_page', ['middleware' => ['admin.auth']]);
$router->add(['GET', 'POST'], 'settings', 'admin_settings_page', ['middleware' => ['admin.auth']]);
$router->add(['GET', 'POST'], 'site-settings', 'admin_site_settings_page', ['middleware' => ['admin.auth']]);
$router->add(['GET', 'POST'], 'database', 'admin_database_page', ['middleware' => ['admin.auth']]);
$router->add(['GET', 'POST'], 'cache-clear', 'admin_cache_clear_page', ['middleware' => ['admin.auth']]);
$router->add(['GET', 'POST'], 'profile', 'admin_profile_page', ['middleware' => ['admin.auth']]);
$router->add(['GET', 'POST'], 'plugins', 'admin_plugins_page', ['middleware' => ['admin.auth']]);
$router->add(['GET', 'POST'], 'themes', 'admin_themes_page', ['middleware' => ['admin.auth']]);
// Системні сторінки управління користувачами та ролями
$router->add(['GET', 'POST'], 'roles', 'admin_roles_page', ['middleware' => ['admin.auth']]);
$router->add(['GET', 'POST'], 'users', 'admin_users_page', ['middleware' => ['admin.auth']]);
// Страницы управления темой (регистрируются автоматически через тему, но базовые маршруты нужны)
$router->add(['GET', 'POST'], 'widgets', 'admin_widgets_page', ['middleware' => ['admin.auth']]);
$router->add(['GET', 'POST'], 'theme-navigation', 'admin_theme_navigation_page', ['middleware' => ['admin.auth']]);
$router->add(['GET', 'POST'], 'theme-customization', 'admin_theme_customization_page', ['middleware' => ['admin.auth']]);

// Реєстрація базових пунктів меню через хук (вместо AdminModule)
// Плагины могут добавлять пункты меню через хук admin_menu
// if (function_exists('add_filter')) {
//     add_filter('admin_menu', function($menu) {
//         // Dashboard
//         $menu[] = [
//             'text' => 'Панель',
//             'title' => 'Панель управління',
//             'icon' => 'fas fa-home',
//             'href' => admin_url('dashboard'),
//             'page' => 'dashboard',
//             'permission' => 'admin.access',
//             'order' => 10,
//         ];
//
//         // Плагіни
//         $menu[] = [
//             'text' => 'Плагіни',
//             'title' => 'Управління плагінами',
//             'icon' => 'fas fa-puzzle-piece',
//             'href' => admin_url('plugins'),
//             'page' => 'plugins',
//             'permission' => 'admin.access',
//             'order' => 30,
//         ];
//
//         // Теми
//         $menu[] = [
//             'text' => 'Теми',
//             'title' => 'Управління темами',
//             'icon' => 'fas fa-palette',
//             'href' => admin_url('themes'),
//             'page' => 'themes',
//             'permission' => 'admin.access',
//             'order' => 31,
//         ];
//
//         return $menu;
//     });
// }

// ВАЖЛИВО: не очищаємо кеш меню під час реєстрації маршрутів.
// Інвалідація кешу має відбуватись у lifecycle подій (активація/деактивація плагінів, зміни меню),
// а не на кожному HTTP-запиті.
//
// Спочатку ініціалізуємо активну тему, щоб її Theme.php (і hooks.php) були завантажені навіть в адмінці.
// Це дозволяє темі зареєструвати підтримку меню та власні admin_menu / admin_register_routes хуки.
if (\function_exists('themeManager')) {
    /** @var \Flowaxy\Support\Managers\ThemeManager|null $themeManager */
    $themeManager = \themeManager();
    if ($themeManager && \method_exists($themeManager, 'getActiveTheme')) {
        $themeManager->getActiveTheme();
    }
}

// Ініціалізуємо плагіни перед викликом хука, щоб вони могли зареєструвати свої маршрути
if (\function_exists('pluginManager')) {
    // @phpstan-ignore-next-line - pluginManager() is a global function
    $pluginManager = \pluginManager();
    if ($pluginManager && \method_exists($pluginManager, 'initializePlugins')) {
        $pluginManager->initializePlugins();
    }
}

// Хук для реєстрації маршрутів модулів та плагінів
// Без глобальних wp-обгорток: використовуємо Flowaxy hooks
if (class_exists('\Flowaxy\Core\Hooks\Action')) {
    \Flowaxy\Core\Hooks\Action::do('admin_register_routes', $router);
} elseif (class_exists('\Flowaxy\Support\Facades\Hooks')) {
    \Flowaxy\Support\Facades\Hooks::dispatch('admin_register_routes', $router);
}
