<?php
/**
 * Компонент таблицы данных с адаптивностью
 * Мигрирован из _OLD_CODE/engine/interface/admin-ui/components/data-table.php
 * Использует функции вместо классов
 *
 * @param array $headers Массив заголовков колонок
 * @param array $rows Массив строк данных
 * @param array $mobileConfig Конфигурация для мобильных карточек
 * @param string $emptyMessage Сообщение когда нет данных
 * @param string $emptyIcon Иконка для пустого состояния
 * @param array $classes Дополнительные CSS классы
 */
if (!isset($headers)) {
    $headers = [];
}
if (!isset($rows)) {
    $rows = [];
}
if (!isset($mobileConfig)) {
    $mobileConfig = [];
}
if (!isset($emptyMessage)) {
    $emptyMessage = 'Немає даних';
}
if (!isset($emptyIcon)) {
    $emptyIcon = 'fas fa-inbox';
}
if (!isset($classes)) {
    $classes = [];
}

$tableClasses = ['table', 'table-striped', 'table-hover'];
if (!empty($classes)) {
    $tableClasses = array_merge($tableClasses, $classes);
}
$tableClass = implode(' ', array_map('htmlspecialchars', $tableClasses));

$keyColumn = $mobileConfig['keyColumn'] ?? 0;
$showColumns = $mobileConfig['showColumns'] ?? [];
$deleteButton = $mobileConfig['deleteButton'] ?? null;
?>
<?php if (empty($rows)): ?>
    <div class="text-center py-5">
        <i class="<?= htmlspecialchars($emptyIcon) ?> fa-3x text-muted mb-3"></i>
        <p class="text-muted"><?= htmlspecialchars($emptyMessage) ?></p>
    </div>
<?php else: ?>
    <!-- Десктопная таблица -->
    <div class="table-responsive d-none d-md-block">
        <table class="<?= $tableClass ?>">
            <?php if (!empty($headers)): ?>
            <thead>
                <tr>
                    <?php foreach ($headers as $header): ?>
                        <?php if (is_array($header)): ?>
                            <th class="<?= htmlspecialchars($header['class'] ?? '') ?>" style="<?= isset($header['width']) ? 'width: ' . htmlspecialchars($header['width']) : '' ?>">
                                <?php if (!empty($header['icon'])): ?>
                                    <i class="fas fa-<?= htmlspecialchars($header['icon']) ?>"></i>
                                <?php endif; ?>
                                <?= htmlspecialchars($header['text'] ?? '') ?>
                            </th>
                        <?php else: ?>
                            <th><?= htmlspecialchars($header) ?></th>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <?php endif; ?>
            <tbody>
                <?php foreach ($rows as $row): ?>
                    <tr>
                        <?php foreach ($row as $index => $cell): ?>
                            <td>
                                <?php if (is_array($cell)): ?>
                                    <?php if (!empty($cell['icon'])): ?>
                                        <i class="fas fa-<?= htmlspecialchars($cell['icon']) ?>"></i>
                                    <?php endif; ?>
                                    <?= $cell['content'] ?? '' ?>
                                <?php else: ?>
                                    <?= htmlspecialchars($cell) ?>
                                <?php endif; ?>
                            </td>
                        <?php endforeach; ?>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Мобильные карточки -->
    <div class="d-md-none">
        <?php foreach ($rows as $row): ?>
            <?php
            $key = is_array($row[$keyColumn] ?? null)
                ? ($row[$keyColumn]['content'] ?? '')
                : ($row[$keyColumn] ?? '');
            ?>
            <div class="card mb-3">
                <div class="card-body">
                    <?php foreach ($row as $index => $cell): ?>
                        <?php if (empty($showColumns) || in_array($index, $showColumns, true)): ?>
                            <div class="mb-2">
                                <?php if (isset($headers[$index])): ?>
                                    <strong><?= is_array($headers[$index]) ? htmlspecialchars($headers[$index]['text'] ?? '') : htmlspecialchars($headers[$index]) ?>:</strong>
                                <?php endif; ?>
                                <?php if (is_array($cell)): ?>
                                    <?= $cell['content'] ?? '' ?>
                                <?php else: ?>
                                    <?= htmlspecialchars($cell) ?>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>

                    <?php if ($deleteButton): ?>
                        <button type="button" class="btn btn-danger btn-sm"
                                data-bs-toggle="modal"
                                data-bs-target="#<?= htmlspecialchars($deleteButton['modal'] ?? '') ?>"
                                <?= isset($deleteButton['dataAttribute']) ? $deleteButton['dataAttribute'] . '="' . htmlspecialchars($key) . '"' : '' ?>>
                            <i class="fas fa-trash"></i> Видалити
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
