<?php
/**
 * Компонент системы уведомлений
 * Мигрирован из _OLD_CODE/engine/interface/admin-ui/components/notifications.php
 */
?>
<!-- Контейнер для сповіщень -->
<div id="notifications-container" class="notifications-container"></div>

<!-- Стилі для сповіщень винесені в SCSS: components/_notifications.scss -->

<script>
// Система уведомлений
(function() {
    const container = document.getElementById('notifications-container');
    if (!container) return;

    window.showNotification = function(message, type = 'info', duration = 5000) {
        const notification = document.createElement('div');
        notification.className = 'notification ' + type;

        const icon = {
            'success': '<i class="fas fa-check-circle"></i>',
            'error': '<i class="fas fa-exclamation-circle"></i>',
            'danger': '<i class="fas fa-exclamation-circle"></i>',
            'warning': '<i class="fas fa-exclamation-triangle"></i>',
            'info': '<i class="fas fa-info-circle"></i>'
        }[type] || icon.info;

        // Создаем кнопку закрытия с правильным обработчиком
        const closeBtn = document.createElement('button');
        closeBtn.className = 'notification-close';
        closeBtn.innerHTML = '<i class="fas fa-times"></i>';
        closeBtn.setAttribute('aria-label', 'Закрити');
        closeBtn.addEventListener('click', function() {
            notification.classList.add('fade-out');
            setTimeout(() => {
                if (notification.parentNode) {
                    notification.remove();
                }
            }, 300);
        });

        notification.innerHTML = `
            <div class="notification-icon">${icon}</div>
            <div class="notification-message">${message}</div>
        `;
        notification.appendChild(closeBtn);

        container.appendChild(notification);

        if (duration > 0) {
            setTimeout(() => {
                notification.classList.add('fade-out');
                setTimeout(() => {
                    if (notification.parentNode) {
                        notification.remove();
                    }
                }, 300);
            }, duration);
        }
    };
})();
</script>
