<?php
/**
 * Компонент Sidebar админ-панели
 * Мигрирован из _OLD_CODE/engine/interface/admin-ui/components/sidebar.php
 * Использует функции вместо классов
 */

// Получаем меню через хук
$menuItems = [];
if (function_exists('apply_filters')) {
    $menuItems = apply_filters('admin_menu', $menuItems);
}

$currentPage = $currentPage ?? '';
if (empty($currentPage) && function_exists('get_current_admin_page')) {
    $currentPage = get_current_admin_page();
}

// Получаем полный путь из URI для правильного сравнения
$currentUri = $_SERVER['REQUEST_URI'] ?? '';
$fullCurrentPage = '';
// Извлекаем полный путь после /admin/
if (preg_match('#/admin(?:/(.+?))?(?:\?|$)#', $currentUri, $matches)) {
    $fullCurrentPage = trim($matches[1] ?? '', '/');
}
// Если полный путь не получен, используем текущую страницу
if (empty($fullCurrentPage)) {
    $fullCurrentPage = $currentPage;
}
// Нормализуем: убираем лишние слэши
$fullCurrentPage = trim($fullCurrentPage, '/');
$currentPage = trim($currentPage, '/');

// Сортируем меню по order
usort($menuItems, function($a, $b) {
    $orderA = $a['order'] ?? 999;
    $orderB = $b['order'] ?? 999;
    return $orderA <=> $orderB;
});
?>
<nav id="sidebarMenu" class="sidebar d-md-block show">
    <div class="sidebar-content">
        <ul class="nav flex-column wp-menu">
            <?php if (empty($menuItems)): ?>
                <li class="nav-item">
                    <div class="sidebar-empty-state">
                        <div class="sidebar-empty-icon"><i class="fas fa-folder-open"></i></div>
                        <p class="sidebar-empty-text">Розділів немає</p>
                    </div>
                </li>
            <?php else: ?>
                <?php foreach ($menuItems as $item): ?>
                    <?php
                    $text = $item['text'] ?? '';
                    $href = $item['href'] ?? '#';
                    $icon = $item['icon'] ?? '';
                    $page = $item['page'] ?? '';
                    $isActive = ($page === $currentPage);
                    $hasSubmenu = !empty($item['submenu']) && is_array($item['submenu']);

                    // Проверяем, есть ли активный пункт в подменю
                    $hasActiveSubmenu = false;
                    if ($hasSubmenu) {
                        foreach ($item['submenu'] as $subItem) {
                            $subPage = $subItem['page'] ?? '';
                            // Сравниваем как точное совпадение, так и начало пути
                            if ($subPage === $currentPage || $subPage === $fullCurrentPage ||
                                (!empty($fullCurrentPage) && strpos($fullCurrentPage, $subPage) === 0) ||
                                (!empty($subPage) && strpos($currentPage, $subPage) === 0)) {
                                $hasActiveSubmenu = true;
                                break;
                            }
                        }
                    }

                    // Если есть активный пункт в подменю, родитель должен быть открыт
                    $shouldBeOpen = $hasActiveSubmenu;
                    ?>
                    <li class="nav-item <?= $hasSubmenu ? 'has-submenu' : '' ?> <?= $isActive ? 'active' : '' ?> <?= $shouldBeOpen ? 'open' : '' ?>">
                        <a class="nav-link d-flex align-items-center justify-content-between" href="<?= htmlspecialchars($href) ?>" <?= $hasSubmenu ? 'onclick="toggleSubmenu(this, event); return false;"' : '' ?>>
                            <span class="d-flex align-items-center">
                                <?php if ($icon): ?>
                                    <i class="<?= htmlspecialchars($icon) ?>"></i>
                                <?php endif; ?>
                                <span class="menu-text"><?= htmlspecialchars($text) ?></span>
                            </span>
                            <?php if ($hasSubmenu): ?>
                                <i class="fas fa-chevron-down submenu-toggle ms-auto"></i>
                            <?php endif; ?>
                        </a>
                        <?php if ($hasSubmenu): ?>
                            <ul class="submenu <?= $shouldBeOpen ? 'show' : '' ?>">
                                <?php foreach ($item['submenu'] as $subItem): ?>
                                    <?php
                                    $subText = $subItem['text'] ?? '';
                                    $subHref = $subItem['href'] ?? '#';
                                    $subPage = $subItem['page'] ?? '';
                                    $subIcon = $subItem['icon'] ?? '';
                                    // Сравниваем как точное совпадение, так и начало пути
                                    $subIsActive = ($subPage === $currentPage || $subPage === $fullCurrentPage ||
                                                   (!empty($fullCurrentPage) && strpos($fullCurrentPage, $subPage) === 0) ||
                                                   (!empty($subPage) && strpos($currentPage, $subPage) === 0));
                                    ?>
                                    <li class="<?= $subIsActive ? 'active' : '' ?>">
                                        <a href="<?= htmlspecialchars($subHref) ?>" class="d-flex align-items-center <?= $subIsActive ? 'active' : '' ?>">
                                            <?php if ($subIcon): ?>
                                                <i class="<?= htmlspecialchars($subIcon) ?>"></i>
                                            <?php endif; ?>
                                            <span><?= htmlspecialchars($subText) ?></span>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>
    </div>
</nav>
