<?php
/**
 * Компонент заголовка страницы
 * Мигрирован из _OLD_CODE/engine/interface/admin-ui/components/page-header.php
 */
?>
<?php if (!empty($title ?? '')): ?>
<div class="page-header">
    <div class="container-fluid">
        <div class="page-header-content d-flex justify-content-between align-items-center flex-wrap">
            <div class="page-title-section">
                <?php if (!empty($icon ?? '')): ?>
                    <div class="page-icon-wrapper">
                        <div class="page-icon">
                            <i class="<?= htmlspecialchars($icon) ?>"></i>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="page-title-content">
                    <h1><?= htmlspecialchars($title) ?></h1>
                    <?php if (!empty($description ?? '')): ?>
                        <p class="page-description"><?= htmlspecialchars($description) ?></p>
                    <?php endif; ?>
                </div>
            </div>

            <?php if (!empty($buttons ?? '')): ?>
                <div class="page-actions d-flex align-items-center gap-2">
                    <?= $buttons ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php endif; ?>
