<?php
/**
 * Компонент пустого стану (empty state)
 *
 * Універсальний компонент для відображення порожніх станів у плагінах та системних сторінках.
 *
 * @param string $icon Іконка Font Awesome (без fas fa-, наприклад: 'database' або повний клас 'fas fa-database')
 * @param string $title Заголовок
 * @param string $message Повідомлення/опис
 * @param string $actions HTML кнопок/дій (необов'язково)
 * @param array $classes Додаткові CSS класи
 *
 * Приклад використання:
 * ```php
 * $componentsPath = __DIR__ . '/../../engine/interface/admin-ui/components/';
 * $icon = 'database';
 * $title = 'Кеш порожній';
 * $message = 'На даний момент у системі немає збережених елементів кешу.';
 * $actions = '<button class="btn btn-primary">Створити</button>';
 * include $componentsPath . 'empty-state.php';
 * ```
 */
if (! isset($icon)) {
    $icon = 'folder-open';
}
if (! isset($title)) {
    $title = 'Немає елементів';
}
if (! isset($message)) {
    $message = '';
}
if (! isset($actions)) {
    $actions = '';
}
if (! isset($classes)) {
    $classes = [];
}

// Якщо іконка не містить 'fa-', додаємо стандартний префікс
if (strpos($icon, 'fa-') === false && strpos($icon, ' ') === false) {
    $iconClass = 'fas fa-' . htmlspecialchars($icon);
} else {
    // Якщо це повний клас іконки, використовуємо як є
    $iconClass = htmlspecialchars($icon);
}

$containerClasses = ['empty-state'];
if (! empty($classes)) {
    $containerClasses = array_merge($containerClasses, $classes);
}
$containerClass = implode(' ', array_map('htmlspecialchars', $containerClasses));
?>
<div class="<?= $containerClass ?>">
    <?php if (! empty($icon)): ?>
    <div class="empty-state-icon">
        <i class="<?= $iconClass ?>"></i>
    </div>
    <?php endif; ?>

    <?php if (! empty($title)): ?>
    <h4 class="empty-state-title"><?= htmlspecialchars($title) ?></h4>
    <?php endif; ?>

    <?php if (! empty($message)): ?>
    <p class="empty-state-message"><?= htmlspecialchars($message) ?></p>
    <?php endif; ?>

    <?php if (! empty($actions)): ?>
    <div class="empty-state-actions">
        <?= $actions ?>
    </div>
    <?php endif; ?>
</div>

<!-- Стилі винесені в SCSS: components/_empty-state.scss -->
