<?php
/**
 * Компонент хлебных крошек
 * Мигрирован из _OLD_CODE/engine/interface/admin-ui/components/breadcrumbs.php
 * Обновлен: добавлена поддержка иконки в каждом элементе и кнопки справа
 */

// Загружаем функцию для получения иконок из меню, если она еще не определена
if (!function_exists('get_breadcrumb_icon_from_menu')) {
    /**
     * Функция для получения иконки из меню по page/slug
     */
    function get_breadcrumb_icon_from_menu(string $page): ?string {
        if (empty($page)) {
            return null;
        }

        // Получаем меню через хук
        $menuItems = [];
        if (function_exists('apply_filters')) {
            $menuItems = apply_filters('admin_menu', $menuItems);
        }

        // Нормализуем page для сравнения
        $normalizedPage = trim($page, '/');

        // Ищем в основном меню
        foreach ($menuItems as $item) {
            $itemPage = trim($item['page'] ?? '', '/');
            if ($itemPage === $normalizedPage && !empty($item['icon'] ?? '')) {
                return $item['icon'];
            }

            // Ищем в подменю
            if (!empty($item['submenu'] ?? []) && is_array($item['submenu'])) {
                foreach ($item['submenu'] as $subItem) {
                    $subItemPage = trim($subItem['page'] ?? '', '/');
                    if ($subItemPage === $normalizedPage && !empty($subItem['icon'] ?? '')) {
                        return $subItem['icon'];
                    }
                }
            }
        }

        return null;
    }
}

// Иконки по умолчанию для стандартных страниц
$defaultIcons = [
    'dashboard' => 'fas fa-home',
    'Головна' => 'fas fa-home',
    'Home' => 'fas fa-home',
    'plugins' => 'fas fa-puzzle-piece',
    'Керування плагінами' => 'fas fa-puzzle-piece',
    'themes' => 'fas fa-palette',
    'Керування темами' => 'fas fa-palette',
    'settings' => 'fas fa-cog',
    'Налаштування' => 'fas fa-cog',
    'users' => 'fas fa-users',
    'Користувачі' => 'fas fa-users',
    'roles' => 'fas fa-user-shield',
    'Ролі та права' => 'fas fa-user-shield',
    'profile' => 'fas fa-user',
    'Профіль користувача' => 'fas fa-user',
    'database' => 'fas fa-database',
    'База даних' => 'fas fa-database',
    'site-settings' => 'fas fa-globe',
    'Налаштування сайту' => 'fas fa-globe',
];

?>
<?php if (!empty($pageBreadcrumbs ?? []) && is_array($pageBreadcrumbs ?? [])): ?>
<div class="page-breadcrumbs-wrapper">
    <div class="container-fluid">
        <div class="page-breadcrumbs-container d-flex justify-content-between align-items-center">
            <nav class="page-breadcrumbs" aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <?php foreach ($pageBreadcrumbs as $index => $crumb): ?>
                        <?php if (isset($crumb['title'])): ?>
                            <?php
                            // Определяем иконку для элемента
                            $crumbIcon = null;

                            // Если иконка указана явно в breadcrumb
                            if (!empty($crumb['icon'] ?? '')) {
                                $crumbIcon = $crumb['icon'];
                            }
                            // Если это последний элемент и есть pageBreadcrumbIcon
                            elseif ($index === count($pageBreadcrumbs) - 1 && !empty($pageBreadcrumbIcon ?? '')) {
                                $crumbIcon = $pageBreadcrumbIcon;
                            }
                            // Пытаемся найти иконку в меню по page
                            elseif (!empty($crumb['page'] ?? '')) {
                                $crumbIcon = get_breadcrumb_icon_from_menu($crumb['page']);
                            }
                            // Пытаемся найти иконку в меню по title (для совместимости)
                            elseif (!empty($crumb['title'])) {
                                $crumbIcon = get_breadcrumb_icon_from_menu($crumb['title']);
                            }
                            // Используем иконку по умолчанию по title
                            if (empty($crumbIcon) && isset($defaultIcons[$crumb['title']])) {
                                $crumbIcon = $defaultIcons[$crumb['title']];
                            }
                            // Используем иконку по умолчанию по page
                            if (empty($crumbIcon) && !empty($crumb['page'] ?? '') && isset($defaultIcons[$crumb['page']])) {
                                $crumbIcon = $defaultIcons[$crumb['page']];
                            }
                            // Для "Головна" всегда используем иконку дома
                            if (empty($crumbIcon) && ($crumb['title'] === 'Головна' || $crumb['title'] === 'Home')) {
                                $crumbIcon = 'fas fa-home';
                            }
                            ?>
                            <?php if ($index === count($pageBreadcrumbs) - 1): ?>
                                <li class="breadcrumb-item active" aria-current="page">
                                    <?php if (!empty($crumbIcon)): ?>
                                        <i class="<?= htmlspecialchars($crumbIcon) ?>"></i>
                                    <?php endif; ?>
                                    <span><?= htmlspecialchars($crumb['title']) ?></span>
                                </li>
                            <?php else: ?>
                                <li class="breadcrumb-item">
                                    <a href="<?= isset($crumb['url']) ? htmlspecialchars($crumb['url']) : '#' ?>">
                                        <?php if (!empty($crumbIcon)): ?>
                                            <i class="<?= htmlspecialchars($crumbIcon) ?>"></i>
                                        <?php endif; ?>
                                        <span><?= htmlspecialchars($crumb['title']) ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ol>
            </nav>
            <?php if (!empty($pageBreadcrumbButtons ?? '')): ?>
                <div class="page-breadcrumbs-actions">
                    <?= $pageBreadcrumbButtons ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php endif; ?>
