<?php
/**
 * Компонент группы формы
 * Мигрирован из _OLD_CODE/engine/interface/admin-ui/components/form-group.php
 * Использует функции вместо классов
 *
 * @param string $label Метка поля
 * @param string $name Имя поля
 * @param string $type Тип поля (text, email, password, textarea, select, checkbox, etc.)
 * @param mixed $value Значение поля
 * @param string $placeholder Placeholder
 * @param string $helpText Подсказка под полем
 * @param array $options Опции для select/radio/checkbox
 * @param array $attributes Дополнительные атрибуты
 * @param string $id ID поля (если не указано, генерируется из name)
 */
if (!isset($type)) {
    $type = 'text';
}
if (!isset($value)) {
    $value = '';
}
if (!isset($placeholder)) {
    $placeholder = '';
}
if (!isset($helpText)) {
    $helpText = '';
}
if (!isset($options)) {
    $options = [];
}
if (!isset($attributes)) {
    $attributes = [];
}
if (!isset($id) && isset($name)) {
    $id = $name;
}
if (!isset($id)) {
    $id = '';
}

$fieldId = !empty($id) ? htmlspecialchars($id) : 'field_' . uniqid();
$fieldName = isset($name) ? htmlspecialchars($name) : '';
$fieldLabel = isset($label) ? htmlspecialchars($label) : '';

$attrString = '';
foreach ($attributes as $attrKey => $attrValue) {
    $attrString .= ' ' . htmlspecialchars($attrKey) . '="' . htmlspecialchars($attrValue) . '"';
}
?>
<div class="form-group mb-3">
    <?php if (!empty($fieldLabel) && $type !== 'checkbox' && $type !== 'radio'): ?>
    <label for="<?= $fieldId ?>" class="form-label fw-medium small">
        <?= $fieldLabel ?>
    </label>
    <?php endif; ?>

    <?php if ($type === 'textarea'): ?>
        <textarea class="form-control"
                  id="<?= $fieldId ?>"
                  name="<?= $fieldName ?>"
                  placeholder="<?= htmlspecialchars($placeholder) ?>"
                  <?= $attrString ?>><?= htmlspecialchars($value) ?></textarea>
    <?php elseif ($type === 'select'): ?>
        <select class="form-select"
                id="<?= $fieldId ?>"
                name="<?= $fieldName ?>"
                <?= $attrString ?>>
            <?php foreach ($options as $optValue => $optLabel): ?>
                <option value="<?= htmlspecialchars($optValue) ?>" <?= ($value == $optValue) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($optLabel) ?>
                </option>
            <?php endforeach; ?>
        </select>
    <?php elseif ($type === 'checkbox'): ?>
        <div class="form-check">
            <input class="form-check-input"
                   type="checkbox"
                   id="<?= $fieldId ?>"
                   name="<?= $fieldName ?>"
                   value="1"
                   <?= $value ? 'checked' : '' ?>
                   <?= $attrString ?>>
            <label class="form-check-label" for="<?= $fieldId ?>">
                <?= $fieldLabel ?>
            </label>
        </div>
    <?php elseif ($type === 'radio'): ?>
        <?php foreach ($options as $optValue => $optLabel): ?>
            <div class="form-check">
                <input class="form-check-input"
                       type="radio"
                       id="<?= $fieldId ?>_<?= htmlspecialchars($optValue) ?>"
                       name="<?= $fieldName ?>"
                       value="<?= htmlspecialchars($optValue) ?>"
                       <?= ($value == $optValue) ? 'checked' : '' ?>
                       <?= $attrString ?>>
                <label class="form-check-label" for="<?= $fieldId ?>_<?= htmlspecialchars($optValue) ?>">
                    <?= htmlspecialchars($optLabel) ?>
                </label>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <input type="<?= htmlspecialchars($type) ?>"
               class="form-control"
               id="<?= $fieldId ?>"
               name="<?= $fieldName ?>"
               value="<?= htmlspecialchars($value) ?>"
               placeholder="<?= htmlspecialchars($placeholder) ?>"
               <?= $attrString ?>>
    <?php endif; ?>

    <?php if (!empty($helpText)): ?>
        <small class="form-text text-muted"><?= htmlspecialchars($helpText) ?></small>
    <?php endif; ?>
</div>
