<?php
require_once '../system/db.php';

// Если функция clean еще не определена в db.php, создадим её на лету
if (!function_exists('clean')) {
    function clean($str) {
        global $db;
        return mysqli_real_escape_string($db, trim(htmlspecialchars($str)));
    }
}

if ($_POST) {
    $login = clean($_POST['login']);
    $res = mysqli_query($db, "SELECT * FROM users WHERE login = '$login' LIMIT 1");
    $user = mysqli_fetch_assoc($res);
    
    if ($user && password_verify($_POST['password'], $user['password'])) {
        // Стартуем сессию, если она еще не запущена
        if (session_status() == PHP_SESSION_NONE) session_start();
        
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['level'] = $user['level'];
        header("Location: /index.php"); // Укажите точный путь к главной
        exit;
    } else {
        $error = "Ошибка входа: неверный логин или пароль!";
    }
}
include '../system/header.php';
?>

<div style="padding: 20px;">
    <h2>Авторизация</h2>
    <?php if(isset($error)) echo "<p style='color:red;'>$error</p>"; ?>
    <form method="post">
        <input type="text" name="login" placeholder="Логин" required><br><br>
        <input type="password" name="password" placeholder="Пароль" required><br><br>
        <button type="submit">Войти</button>
    </form>
</div>

<?php include '../system/footer.php'; ?>

