<?php
require_once '../system/db.php';
include '../system/header.php';

// Проверяем уровень доступа (для кнопок управления)
// Предполагаем, что уровень хранится в $_SESSION['level'] или берется из конфига
$rights = isset($_SESSION['level']) ? intval($_SESSION['level']) : 0;
$is_admin = ($rights >= 7) ? true : false;

echo "<style>
    .participant-list { background: #fff; border-radius: 15px; overflow: hidden; box-shadow: 0 4px 12px rgba(0,0,0,0.05); border: 1px solid #f0f0f0; }
    .user-row { 
        display: flex; align-items: center; padding: 12px 15px; 
        border-bottom: 1px solid #f0f0f0; transition: 0.2s; 
    }
    .user-row:hover { background: #f9f9fb; }
    .user-row:last-child { border-bottom: none; }
    
    .club-info { flex: 1; }
    .club-link { font-weight: bold; color: #2c3e50; text-decoration: none; font-size: 15px; }
    .club-id { font-size: 11px; color: #95a5a6; margin-left: 5px; }
    
    .manager-info { flex: 1; text-align: right; font-size: 13px; }
    .manager-link { color: #3498db; text-decoration: none; font-weight: 600; }
    .status-online { color: #27ae60; font-size: 11px; font-weight: bold; }
    .status-offline { color: #95a5a6; font-size: 11px; }
    
    .vacant { color: #e67e22; font-style: italic; font-size: 13px; background: #fff4e5; padding: 2px 8px; border-radius: 10px; }
    
    .admin-tools { margin-left: 15px; }
    .btn-uvol { 
        background: #fff0f0; color: #e74c3c; padding: 4px 10px; 
        border-radius: 6px; font-size: 11px; text-decoration: none; border: 1px solid #ffcccc;
    }

    .stats-bar { 
        background: #fff; padding: 15px; border-radius: 12px; 
        margin-bottom: 20px; text-align: center; border: 1px solid #eee;
    }
    .progress-bg { background: #e9ecef; height: 10px; border-radius: 5px; margin-top: 10px; overflow: hidden; }
    .progress-fill { background: linear-gradient(90deg, #3498db, #2ecc71); height: 100%; border-radius: 5px; transition: width 0.5s; }
</style>";

echo "<div class='card-title'>👥 Участники футбольного союза</div>";

// Основной запрос
$sql = "SELECT c.id, c.name as club_name, c.user_id, u.login as user_name, u.lastdate 
        FROM fman_clubs c 
        LEFT JOIN users u ON c.user_id = u.id 
        WHERE c.id != 131 
        ORDER BY c.name ASC";

$res = mysqli_query($db, $sql);

if (!$res) {
    echo "<div class='note-item' style='border-left-color: #e74c3c;'>
            <b>Ошибка базы данных:</b><br>
            <small>" . mysqli_error($db) . "</small>
          </div>";
    include '../system/footer.php';
    exit;
}

$total_clubs = mysqli_num_rows($res);
$occupied_clubs = 0;
$list_html = "";

if ($total_clubs > 0) {
    while ($a = mysqli_fetch_assoc($res)) {
        $list_html .= "<div class='user-row'>";
        
        // Клуб
        $list_html .= "<div class='club-info'>
                        <a href='club.php?id={$a['id']}' class='club-link'>" . htmlspecialchars($a['club_name']) . "</a>
                        <span class='club-id'>#{$a['id']}</span>
                      </div>";
        
        // Менеджер
        $list_html .= "<div class='manager-info'>";
        if (!empty($a['user_id'])) {
            $occupied_clubs++;
            $last_visit = intval($a['lastdate']);
            $is_online = (time() - $last_visit < 300);
            
            // ИСПРАВЛЕНИЕ ЗДЕСЬ: заменяем functions::display_date на date()
            $date_formatted = ($last_visit > 0) ? date("d.m.Y H:i", $last_visit) : "Никогда";
            
            $online_status = $is_online 
                ? "<span class='status-online'>● Online</span>" 
                : "<span class='status-offline'>Был: " . $date_formatted . "</span>";
                
            $list_html .= "<a href='/users/profile.php?user={$a['user_id']}' class='manager-link'>" . htmlspecialchars($a['user_name']) . "</a><br>$online_status";
        } else {
            $list_html .= "<span class='vacant'>Свободно</span>";
        }
        $list_html .= "</div>";

        // Кнопка увольнения для админа
        if ($is_admin && !empty($a['user_id'])) {
            $list_html .= "<div class='admin-tools'>
                            <a href='uvol.php?id={$a['id']}' class='btn-uvol' onclick='return confirm(\"Вы уверены?\")'>Уволить</a>
                          </div>";
        }

        $list_html .= "</div>";
    }

    // Вывод статистики
    $percent = ($total_clubs > 0) ? round(($occupied_clubs / $total_clubs) * 100) : 0;
    echo "<div class='stats-bar'>
            <div style='font-weight:bold; color:#2c3e50;'>Занято мест: $occupied_clubs из $total_clubs ($percent%)</div>
            <div class='progress-bg'>
                <div class='progress-fill' style='width: $percent%'></div>
            </div>
          </div>";

    echo "<div class='participant-list'>$list_html</div>";

} else {
    echo "<div class='note-item'>Список клубов пуст.</div>";
}

echo "<div style='margin-top:20px; text-align:center;'>
        <a href='index.php' class='btn-land' style='background:#f1f2f6; padding: 10px 20px; border-radius: 20px; text-decoration:none; color:#333;'>⬅ Назад в меню</a>
      </div>";

include '../system/footer.php';
?>

