<?php
require_once '../system/db.php';
include '../system/header.php';

// Параметры навигации
$act = isset($_GET['act']) ? mysqli_real_escape_string($db, $_GET['act']) : '';
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$kmess = 10;
$start = isset($_GET['start']) ? intval($_GET['start']) : 0;
if ($start < 0) $start = 0;

echo "<style>
    .trans-card { background: #fff; border-radius: 12px; padding: 15px; margin-bottom: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); border: 1px solid #eee; }
    .trans-header { display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid #f0f0f0; padding-bottom: 8px; margin-bottom: 10px; }
    .pl-name { font-weight: bold; color: #2c3e50; text-decoration: none; font-size: 15px; }
    .pl-ampl { background: #3498db; color: #fff; padding: 2px 6px; border-radius: 4px; font-size: 10px; }
    .price-tag { color: #27ae60; font-weight: bold; font-size: 16px; }
    .btn-buy { background: #27ae60; color: #fff; padding: 6px 15px; border-radius: 20px; text-decoration: none; font-size: 13px; display: inline-block; }
    .stat-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 5px; font-size: 12px; color: #7f8c8d; }
</style>";

// Проверка существования таблиц (чтобы не было Warning)
$table_check = mysqli_query($db, "SHOW TABLES LIKE 'fman_players'");
if (mysqli_num_rows($table_check) == 0) {
    echo "<div class='note-item' style='border-left-color:red;'>Ошибка: Таблица <b>fman_players</b> не найдена в базе данных. Проверьте установку SQL.</div>";
    include '../system/footer.php';
    exit;
}

// Проверка конфига менеджера
$gconf_q = mysqli_query($db, "SELECT * FROM `manager` LIMIT 1");
$gconf = ($gconf_q) ? mysqli_fetch_assoc($gconf_q) : ['open' => 0];

switch($act) {
    default:
        echo "<div class='card-title'>🏆 Трансферный рынок</div>";

        if(isset($gconf['open']) && $gconf['open'] == 1) {
            echo "<div class='note-item'>Трансферное окно временно закрыто.</div>";
        } else {
            // Исправленный подсчет строк
            $qr = mysqli_query($db, "SELECT COUNT(*) FROM `fman_players` WHERE `trans`='1'");
            if (!$qr) {
                echo "<div class='note-item'>Ошибка запроса к игрокам.</div>";
                break;
            }
            $total = mysqli_fetch_row($qr)[0];

            $q = mysqli_query($db, "SELECT * FROM `fman_players` WHERE `trans`='1' ORDER BY `trans_time` ASC LIMIT $start, $kmess");

            if ($total == 0) {
                echo "<div class='note-item'>На трансфере пока нет игроков.</div>";
            } else {
                while($a = mysqli_fetch_assoc($q)) {
                    // Пропускаем своих игроков
                    if(isset($club_id) && $a['team_id'] == $club_id) continue;

                    $ampl_names = [1=>'ВР', 2=>'ЛЗ', 3=>'ЦЗ', 4=>'ПЗ', 5=>'ОП', 6=>'ЛП', 7=>'ЦП', 8=>'ПП', 9=>'АП', 10=>'НП'];
                    $name_ampl = $ampl_names[$a['ampl']] ?? 'ПЗ';

                    echo "<div class='trans-card'>";
                    echo "<div class='trans-header'>
                            <a href='player.php?id=".$a['id']."' class='pl-name'>".$a['name']." <span class='pl-ampl'>$name_ampl</span></a>
                            <div class='price-tag'>$".number_format($a['cena'], 0, '.', ' ')."</div>
                          </div>";

                    echo "<div class='stat-grid'>
                            <div>Опыт: <b>".$a['ball']."</b></div>
                            <div>Талант: <b>".$a['rait']."</b></div>
                            <div>Форма: <b>".$a['forma']."</b></div>
                            <div>Усталость: <b>".$a['ust']."</b></div>
                          </div>";

                    echo "<div style='margin-top:10px; text-align:right;'>
                            <a href='trans.php?id=".$a['id']."&act=buy' class='btn-buy'>Сделать ставку</a>
                          </div>";
                    echo "</div>";
                }

                // Навигация (Pagination)
                if ($total > $kmess && class_exists('functions')) {
                    echo '<div class="note-item">' . functions::display_pagination('trans.php?', $start, $total, $kmess) . '</div>';
                }
            }
        }
        break;

    case 'buy':
        // Логика покупки (упрощенная для примера, сохрани оригинальную если нужно)
        $q = mysqli_query($db, "SELECT * FROM `fman_players` WHERE `id` = '$id' LIMIT 1");
        $a = mysqli_fetch_assoc($q);

        if (!$a || $a['trans'] != 1) {
            echo "<div class='note-item'>Игрок не найден на трансфере.</div>";
        } else {
            echo "<div class='trans-card' style='text-align:center;'>
                    <h3>Покупка игрока</h3>
                    <p>Вы уверены, что хотите купить <b>".$a['name']."</b> за <b>$".number_format($a['cena'], 0, '.', ' ')."</b>?</p>
                    <a href='trans.php?id=$id&act=buy&yes=yes' class='btn-buy'>Да, купить</a>
                    <a href='trans.php' class='btn-buy' style='background:#95a5a6;'>Отмена</a>
                  </div>";
            
            if (isset($_GET['yes'])) {
                // Здесь добавь логику списания денег и смены владельца из предыдущего шага
                echo "<div class='note-item'>Функция покупки в процессе...</div>";
            }
        }
        break;
}

echo "<div class='card-title' style='text-align:center;'><a href='index.php'>⬅ В менеджер</a></div>";
include '../system/footer.php';
?>

