<?php
// Используем пути из вашего рабочего примера
require_once '../system/db.php';
include '../system/header.php';

// Функция turn() и match() должны быть в manfunc.php
// Убедитесь, что путь к manfunc.php верный
require_once "manfunc.php"; 

$land = isset($_GET['land']) ? clean($_GET['land']) : '';
$act = isset($_GET['act']) ? clean($_GET['act']) : '';
$tur_get = isset($_GET['tur']) ? intval($_GET['tur']) : 0;

// Название турнира
$textl = turn($act, 0, $land);

// --- CSS СТИЛИ ДЛЯ ТАБЛИЦ И МАТЧЕЙ ---
echo '<style>
    .fman-table-res { width: 100%; border-collapse: collapse; background: #fff; border-radius: 12px; overflow: hidden; box-shadow: 0 2px 8px rgba(0,0,0,0.05); margin-bottom: 20px; font-size: 13px; }
    .fman-table-res th { background: #2c3e50; color: #fff; padding: 12px 8px; text-align: center; }
    .fman-table-res td { padding: 10px 8px; border-bottom: 1px solid #f0f0f0; text-align: center; }
    .fman-table-res tr:nth-child(even) { background: #fcfcfc; }
    .team-name-cell { text-align: left !important; font-weight: 600; color: #2c3e50; }
    .my-team-row { background: #fff9c4 !important; border-left: 4px solid #f1c40f; }
    .stage-header { background: #f1f2f6; padding: 10px 15px; font-weight: bold; color: #2f3542; border-left: 4px solid #3498db; margin: 15px 0 10px 0; border-radius: 0 8px 8px 0; }
    .grid-nav { display: grid; grid-template-columns: repeat(auto-fill, minmax(45px, 1fr)); gap: 5px; padding: 10px; background: #fff; border-radius: 10px; }
    .nav-btn { background: #f8f9fa; border: 1px solid #eee; text-align: center; padding: 5px; text-decoration: none; color: #333; font-size: 11px; border-radius: 4px; }
    .nav-btn:hover { background: #3498db; color: #fff; }
</style>';

// Функции вывода данных (переписаны на mysqli)
function cupvivod($tur) {
    global $db, $act, $club_id, $land;
    $stages = [
        11 => '🏆 Финал', 121 => '1/2 финала (I)', 122 => '1/2 финала (II)',
        141 => '1/4 финала (I)', 142 => '1/4 финала (II)', 181 => '1/8 финала (I)',
        182 => '1/8 финала (II)', 1161 => '1/16 финала (I)', 1162 => '1/16 финала (II)',
        12 => '1/2 финала', 14 => '1/4 финала', 18 => '1/8 финала', 1 => 'Квалификация'
    ];
    
    $q = mysqli_query($db, "SELECT * FROM fman_matches WHERE turn='$act' AND tur=$tur AND land='$land' ORDER BY kom1 ASC");
    if (mysqli_num_rows($q)) {
        echo "<div class='stage-header'>" . ($stages[$tur] ?? "Раунд $tur") . "</div>";
        while ($a = mysqli_fetch_assoc($q)) {
            match($a, $club_id, 0); // Функция вывода матча из manfunc.php
        }
    }
}

function groupvivod($tur) {
    global $db, $act, $club_id, $land;
    echo "<div class='card-title'>Матчи: $tur тур</div>";
    $q = mysqli_query($db, "SELECT * FROM fman_matches WHERE turn='$act' AND tur=$tur AND land='$land'");
    while ($a = mysqli_fetch_assoc($q)) {
        match($a, $club_id, 0);
    }
}

echo "<div class='fman-container'>";
echo "<h2 style='text-align:center; color:#2c3e50;'>$textl</h2>";

// 1. Суперкубок
if ($act == "sc" || $act == "supercup") {
    $q = mysqli_query($db, "SELECT * FROM fman_matches WHERE turn='$act' AND land='$land' LIMIT 1");
    if (mysqli_num_rows($q) == 0) echo "<div class='note-item'>Матчей не запланировано</div>"; 
    else { $a = mysqli_fetch_assoc($q); match($a, $club_id, 0); }
}

// 2. Кубки и Группы ЛЧ/ЛЕ (общий вид еврокубков)
if ($act == "cup" || (($act == "lc" || $act == "le") && $land == "eu")) {
    $st_arr = [11, 12, 14, 18, 121, 122, 141, 142, 181, 182, 1161, 1162, 1];
    foreach ($st_arr as $s) cupvivod($s);

    if ($act == "lc" || $act == "le") {
        echo "<div class='card-title'>Групповой этап</div>";
        echo "<div class='grid-nav' style='grid-template-columns: repeat(4, 1fr);'>";
        $groups = range('a', ($act == 'le' ? 'l' : 'h'));
        foreach ($groups as $g) {
            echo "<a class='nav-btn' href='table.php?act=$act&amp;land=$g'>Группа ".strtoupper($g)."</a>";
        }
        echo "</div>";
    }
}

// 3. Таблица конкретной группы ЛЧ/ЛЕ
if (($act == "lc" || $act == "le") && $land != "eu" && !empty($land)) {
    $qtb = mysqli_query($db, "SELECT id1, id2 FROM fman_matches WHERE turn='$act' AND tur=1 AND land='$land'");
    $uch = [];
    while ($atb = mysqli_fetch_assoc($qtb)) {
        $uch[] = $atb['id1']; $uch[] = $atb['id2'];
    }
    
    if (!empty($uch)) {
        $ids = implode(',', array_unique($uch));
        $q_tour = mysqli_query($db, "SELECT u2, u3, u4 FROM fman_clubs WHERE id='{$uch[0]}' LIMIT 1");
        $dr = mysqli_fetch_assoc($q_tour);
        $tour_num = $dr['u2'] + $dr['u3'] + $dr['u4'];

        echo "<div class='card-title'>Таблица группы ".strtoupper($land)." ".($tour_num > 0 ? "($tour_num тур)" : "")."</div>";
        echo "<table class='fman-table-res'><tr><th>#</th><th class='team-name-cell'>Клуб</th><th>В</th><th>Н</th><th>П</th><th>Г</th><th>О</th></tr>";
        
        $q_list = mysqli_query($db, "SELECT * FROM fman_clubs WHERE id IN ($ids) ORDER BY u7 DESC, (u5-u6) DESC");
        $pos = 0;
        while ($a = mysqli_fetch_assoc($q_list)) {
            $pos++;
            $is_me = ($a['id'] == $club_id) ? "class='my-team-row'" : "";
            echo "<tr $is_me><td>$pos</td><td class='team-name-cell'><a href='club.php?id={$a['id']}'>{$a['name']}</a></td>
                  <td>{$a['u2']}</td><td>{$a['u3']}</td><td>{$a['u4']}</td><td>{$a['u5']}-{$a['u6']}</td><td><b>{$a['u7']}</b></td></tr>";
        }
        echo "</table>";
        for ($i=1; $i<=6; $i++) groupvivod($i);
    }
}

// 4. Чемпионат
if ($act == "champ") {
    $q_info = mysqli_query($db, "SELECT v, n, p FROM fman_clubs WHERE land='$land' LIMIT 1");
    $inf = mysqli_fetch_assoc($q_info);
    $tour_cur = $inf['v'] + $inf['n'] + $inf['p'];

    echo "<div class='card-title'>Турнирная таблица " . ($tour_cur > 0 ? "($tour_cur тур)" : "") . "</div>";
    echo "<table class='fman-table-res'><tr><th>#</th><th class='team-name-cell'>Клуб</th><th>В</th><th>Н</th><th>П</th><th>Мячи</th><th>О</th></tr>";
    
    $q_champ = mysqli_query($db, "SELECT * FROM fman_clubs WHERE land='$land' ORDER BY o DESC, (zg-pg) DESC, zg DESC");
    $p = 0;
    while ($a = mysqli_fetch_assoc($q_champ)) {
        $p++;
        $is_me = ($a['id'] == $club_id) ? "class='my-team-row'" : "";
        echo "<tr $is_me><td>$p</td><td class='team-name-cell'><a href='club.php?id={$a['id']}'>{$a['name']}</a></td>
              <td>{$a['v']}</td><td>{$a['n']}</td><td>{$a['p']}</td><td>{$a['zg']}-{$a['pg']}</td><td><b>{$a['o']}</b></td></tr>";
    }
    echo "</table>";

    // Результаты и анонсы
    if ($tour_cur > 0) {
        echo "<div class='stage-header'>Результаты: $tour_cur тур</div>";
        $qp = mysqli_query($db, "SELECT * FROM fman_matches WHERE turn='$act' AND tur='$tour_cur' AND land='$land' ORDER BY id ASC");
        while ($ap = mysqli_fetch_assoc($qp)) match($ap, $club_id, 0);
    }

    $next = $tour_cur + 1;
    $qn = mysqli_query($db, "SELECT * FROM fman_matches WHERE turn='$act' AND tur='$next' AND land='$land' ORDER BY id ASC");
    if (mysqli_num_rows($qn)) {
        echo "<div class='stage-header'>Анонс: $next тур</div>";
        while ($an = mysqli_fetch_assoc($qn)) match($an, $club_id, 0);
    }

    // Навигация по турам
    echo "<div class='card-title'>Календарь чемпионата</div>";
    echo "<div class='grid-nav'>";
    $max_tours = 39;
    $limits = ['ru'=>31, 'ua'=>31, 'pt'=>31, 'de'=>35, 'nl'=>35, 'by'=>34];
    if (isset($limits[$land])) $max_tours = $limits[$land];
    for ($i = 1; $i < $max_tours; $i++) {
        echo "<a href='matches.php?act=$land&amp;tur=$i' class='nav-btn'>$i</a>";
    }
    echo "</div>";
}

echo "</div>"; // Конец контейнера

echo "<div style='text-align:center; margin: 20px 0;'>
        <a href='index.php' class='btn-land' style='background:var(--primary); color:#fff; padding: 10px 20px;'>🏠 В офис менеджера</a>
      </div>";

include '../system/footer.php';
?>

