<?php
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php";

// 1. Проверка авторизации
$my_id = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : 0;
if (!$my_id) {
    echo "<div class='note-item'>Доступ запрещен. Пожалуйста, авторизуйтесь.</div>";
    include '../system/footer.php'; exit;
}

// 2. Получаем данные клуба текущего пользователя
$qc = mysqli_query($db, "SELECT * FROM fman_clubs WHERE user_id = $my_id LIMIT 1");
$dataclub = mysqli_fetch_assoc($qc);

if (!$dataclub) {
    echo "<div class='note-item'>У вас нет клуба. Зарегистрируйте или выберите клуб в менеджере.</div>";
    include '../system/footer.php'; exit;
}

$club_id = $dataclub['id'];

// Функция определения позиции (сохраняем оригинальную логику схем)
function get_required_pos($i, $tdata) {
    $r = 10; // По умолчанию Нападающий
    if($i==1) $r=1;
    if($i==2) $r=2;
    if($i==3) $r=3;
    if($i==4) $r=3;
    if($i==5) $r=4;
    if($i==6) $r=6;
    if($i==7) $r=5;
    if($i==8) $r=9;
    if($i==9) $r=8;
    if($i==10) $r=10;
    if($i==11) $r=10;

    $t = (int)$tdata['tren'];
    if($t==3){ if($i==7)$r=7; if($i==8)$r=8; if($i==9)$r=10; }
    if($t==2){ if($i==7)$r=7; if($i==8)$r=7; }
    if($t==4){ if($i==7)$r=5; if($i==8)$r=5; if($i==9)$r=9; if($i==10)$r=8; }
    if($t==5){ if($i==7)$r=5; if($i==8)$r=9; if($i==9)$r=9; if($i==10)$r=8; }
    if($t==6){ if($i==7)$r=5; if($i==8)$r=7; if($i==9)$r=9; if($i==10)$r=8; }
    if($t==7){ if($i==7)$r=7; if($i==8)$r=7; if($i==9)$r=7; if($i==10)$r=8; }
    if($t==8){ if($i==5)$r=3; if($i==6)$r=4; if($i==7)$r=6; if($i==8)$r=5; if($i==9)$r=9; if($i==10)$r=8; }
    if($t==9){ if($i==5)$r=3; if($i==6)$r=4; if($i==7)$r=6; if($i==8)$r=7; if($i==9)$r=7; if($i==10)$r=8; }
    if($t==10){ if($i==4)$r=4; if($i==5)$r=6; if($i==6)$r=5; if($i==7)$r=9; if($i==8)$r=8; if($i==9)$r=10; }
    if($t==11){ if($i==4)$r=4; if($i==5)$r=6; if($i==6)$r=7; if($i==7)$r=7; if($i==8)$r=8; if($i==9)$r=10; }
    if($t==12){ if($i==4)$r=4; if($i==5)$r=6; if($i==6)$r=5; if($i==7)$r=5; if($i==8)$r=9; if($i==9)$r=8; }
    if($t==13){ if($i==4)$r=4; if($i==5)$r=6; if($i==6)$r=5; if($i==7)$r=9; if($i==8)$r=9; if($i==9)$r=8; }
    if($t==14){ if($i==4)$r=4; if($i==5)$r=6; if($i==6)$r=5; if($i==7)$r=7; if($i==8)$r=9; if($i==9)$r=8; }
    if($t==15){ if($i==4)$r=4; if($i==5)$r=6; if($i==6)$r=7; if($i==7)$r=7; if($i==8)$r=7; if($i==9)$r=8; }
    
    return $r;
}
?>

<style>
    .field-position { 
        background: #fff; border-radius: 10px; padding: 10px; margin-bottom: 8px; 
        box-shadow: 0 2px 5px rgba(0,0,0,0.05); border-left: 5px solid #27ae60;
        display: flex; align-items: center; justify-content: space-between;
    }
    .pos-label { font-weight: bold; width: 45px; color: #27ae60; text-align: center; background: #e8f5e9; border-radius: 5px; padding: 2px; margin-right: 10px; }
    .pos-select { flex-grow: 1; padding: 8px; border: 1px solid #ddd; border-radius: 8px; font-size: 14px; background: white; }
    .tactic-box { background: #f9f9f9; padding: 15px; border-radius: 12px; margin: 10px 0; border: 1px solid #eee; }
    .radio-group { display: block; margin-bottom: 10px; cursor: pointer; font-size: 14px; position: relative; padding-left: 30px; }
    .radio-group input { position: absolute; left: 0; top: 2px; width: 18px; height: 18px; }
    .field-bg { background: #2ecc71; color: white; padding: 12px; border-radius: 12px 12px 0 0; font-weight: bold; text-align: center; text-transform: uppercase; letter-spacing: 1px; }
    .btn-save { background: #27ae60; color: white; border: none; width: 100%; padding: 15px; border-radius: 12px; font-weight: bold; font-size: 16px; cursor: pointer; margin-top: 10px; box-shadow: 0 4px 10px rgba(39, 174, 96, 0.3); }
</style>

<div style="padding: 10px;">
<?php
// 3. Проверка, идет ли сейчас матч
$qd = mysqli_query($db, "SELECT id FROM fman_matches WHERE time < ".time()." AND end = 0 AND (id1 = $club_id OR id2 = $club_id) LIMIT 1");

if ($qd && mysqli_num_rows($qd) > 0) {
    echo "<div class='note-item' style='border-left:4px solid #e74c3c; background: #fdf2f2; padding: 15px;'>Вы не можете изменять стартовый состав, так как команда проводит матч.</div>";
} else {
    echo "<h2 align='center'>Управление составом</h2>";

    // 4. Логика сохранения
    if (isset($_POST['submit'])) {
        $players = [];
        $valid = true;
        for ($i = 1; $i <= 11; $i++) {
            if (isset($_POST["p$i"])) {
                $players[] = (int)$_POST["p$i"];
            } else {
                $valid = false;
            }
        }
        
        if (!$valid || count(array_unique($players)) < 11) {
            echo "<div class='note-item' style='border-left:4px solid #e74c3c; margin-bottom:15px;'>Ошибка! Один игрок не может играть на нескольких позициях!</div>";
        } else {
            $tren = (int)$_POST['tren'];
            $tak = (int)$_POST['tak'];
            
            // Обновляем клуб
            mysqli_query($db, "UPDATE fman_clubs SET tren=$tren, tak=$tak, 
                p1={$players[0]}, p2={$players[1]}, p3={$players[2]}, p4={$players[3]}, p5={$players[4]}, 
                p6={$players[5]}, p7={$players[6]}, p8={$players[7]}, p9={$players[8]}, p10={$players[9]}, p11={$players[10]} 
                WHERE id = $club_id");

            // Обновляем позиции игроков
            for ($i = 1; $i <= 11; $i++) {
                $p_id = $players[$i-1];
                $req_pos = (int)$_POST["z$i"];
                
                // Если позиция "В" (1), проверяем через БД (оригинальная логика)
                if ($req_pos == 1) {
                    $q_pl = mysqli_query($db, "SELECT ampl FROM fman_players WHERE id = $p_id");
                    $pl_data = mysqli_fetch_assoc($q_pl);
                    $req_pos = $pl_data['ampl'];
                }
                mysqli_query($db, "UPDATE fman_players SET pos = $req_pos WHERE id = $p_id");
            }
            
            // Перезагружаем данные клуба для корректного отображения формы
            $qc = mysqli_query($db, "SELECT * FROM fman_clubs WHERE id = $club_id");
            $dataclub = mysqli_fetch_assoc($qc);
            echo "<div class='note-item' style='border-left:4px solid #27ae60; background: #f0fdf4; margin-bottom:15px;'>Стартовый состав успешно изменен!</div>";
        }
    }

    echo "<form action='sostav.php' method='post'>";
    echo "<div class='field-bg'>🛡️ СТАРТОВЫЙ СОСТАВ</div>";
    
    $pos_names = array(1=>'В',2=>'ЛЗ',3=>'ЦЗ',4=>'ПЗ',5=>'ОП',6=>'ЛП',7=>'ЦП',8=>'ПП',9=>'АП',10=>'Н');
    
    // Получаем список всех здоровых игроков клуба (один запрос)
    $all_players = [];
    $qp = mysqli_query($db, "SELECT id, name, ampl FROM fman_players WHERE team_id = $club_id AND travm = 0 ORDER BY ampl ASC");
    if ($qp) {
        while($row = mysqli_fetch_assoc($qp)) $all_players[] = $row;
    }

    // Вывод 11 позиций
    for ($i = 1; $i <= 11; $i++) {
        $required_pos = get_required_pos($i, $dataclub);
        $current_player_id = isset($dataclub["p$i"]) ? (int)$dataclub["p$i"] : 0;
        
        echo "<div class='field-position'>";
        echo "<div class='pos-label'>" . $pos_names[$required_pos] . "</div>";
        echo "<select name='p$i' class='pos-select'>";
        foreach ($all_players as $pl) {
            $sel = ($current_player_id == $pl['id']) ? "selected" : "";
            echo "<option value='{$pl['id']}' $sel>{$pl['name']} (" . $pos_names[$pl['ampl']] . ")</option>";
        }
        echo "</select>";
        echo "<input type='hidden' name='z$i' value='$required_pos'>";
        echo "</div>";
    }

    // Секция Тактики
    echo "<div class='card-title' style='margin-top:15px;'>⚙️ ТАКТИКА</div>";
    echo "<div class='tactic-box'>";
    $tactics = [1=>'Нормально', 2=>'Контратаки', 3=>'Прессинг', 4=>'Атака по центру', 5=>'Атака по флангам'];
    foreach ($tactics as $tid => $tname) {
        $ch = ($dataclub['tak'] == $tid) ? "checked" : "";
        echo "<label class='radio-group'><input type='radio' name='tak' value='$tid' $ch> $tname</label>";
    }
    echo "</div>";

    // Секция Расстановки
    echo "<div class='card-title'>📋 РАССТАНОВКА</div>";
    echo "<div class='tactic-box'>";
    $formations = array(
        1=>'4-4-2 (ОП, АП)', 2=>'4-4-2 (2ЦП)', 3=>'4-3-3', 4=>'4-5-1 (2ОП, АП)', 5=>'4-5-1 (ОП, 2АП)', 
        6=>'4-5-1 (ОП, ЦП, АП)', 7=>'4-5-1 (3ЦП)', 8=>'5-4-1 (ОП, АП)', 9=>'5-4-1 (2ЦП)', 10=>'3-4-3 (ОП, АП)', 
        11=>'3-4-3 (2ЦП)', 12=>'3-5-2 (2ОП, АП)', 13=>'3-5-2 (ОП, 2АП)', 14=>'3-5-2 (ОП, ЦП, АП)', 15=>'3-5-2 (3ЦП)'
    );
    foreach ($formations as $fid => $fname) {
        $ch = ($dataclub['tren'] == $fid) ? "checked" : "";
        echo "<label class='radio-group'><input type='radio' name='tren' value='$fid' $ch> $fname</label>";
    }
    echo "</div>";

    echo "<input type='submit' name='submit' value='СОХРАНИТЬ ИЗМЕНЕНИЯ' class='btn-save'>";
    echo "</form>";
}
?>

<div style="text-align:center; margin-top:20px; padding-bottom: 20px;">
    <a href="club.php" style="text-decoration:none; color:#3498db; font-weight: bold;">⬅ Назад в клуб</a><br><br>
    <a href="index.php" style="text-decoration:none; color:#7f8c8d; font-size: 14px;">🏠 Офис менеджера</a>
</div>
</div>

<?php include '../system/footer.php'; ?>

