<?php
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php";

// --- НАСТРОЙКИ ПАГИНАЦИИ ---
$kmess = 15; // Количество новостей на страницу
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$start = ($page - 1) * $kmess;

$act = isset($_GET['act']) ? mysqli_real_escape_string($db, $_GET['act']) : '';
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// --- ЛОГИКА ФИЛЬТРАЦИИ ---
if ($act == "trans") {
    $zu = "pl_id > 0 AND club_id = 0";
    $v = 'трансферов';
} else {
    $zu = "pl_id = 0 AND club_id = 0";
    $v = 'менеджеров';
}

if ($id) {
    $qcj = mysqli_query($db, "SELECT name FROM fman_clubs WHERE id = $id LIMIT 1");
    $t = mysqli_fetch_assoc($qcj);
    $zu = "club_id = $id";
    $v = "клуба " . htmlspecialchars($t['name']);
}

// Подсчет общего количества для пагинации
$total_res = mysqli_query($db, "SELECT COUNT(*) FROM fman_news WHERE $zu");
$total = mysqli_fetch_row($total_res)[0];
$total_pages = ceil($total / $kmess);
?>

<style>
    .news-container { padding: 10px; font-family: 'Segoe UI', sans-serif; }
    .news-card {
        background: white; border-radius: 12px; padding: 15px; margin-bottom: 12px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.06); border-left: 4px solid #3498db;
    }
    .news-date { font-size: 11px; color: #95a5a6; margin-bottom: 8px; display: block; }
    .news-text { font-size: 14px; color: #2c3e50; line-height: 1.4; }
    
    /* Оформление трансферных новостей */
    .transfer-box { background: #f8f9fa; border-radius: 8px; padding: 10px; margin-top: 8px; }
    .transfer-arrow { color: #27ae60; font-weight: bold; margin: 0 5px; }
    .club-link { color: #3498db; text-decoration: none; font-weight: 600; }
    
    /* Пагинация */
    .pagination { text-align: center; margin: 20px 0; }
    .page-link { 
        padding: 8px 12px; background: white; border: 1px solid #ddd; 
        color: #333; text-decoration: none; border-radius: 5px; margin: 2px;
    }
    .page-active { background: #3498db; color: white; border-color: #3498db; }
</style>

<div class="news-container">
    <h2 align="center" style="color: #2c3e50;">📰 Новости <?php echo $v; ?></h2>

    <?php
    $q = mysqli_query($db, "SELECT * FROM fman_news WHERE $zu ORDER BY time DESC LIMIT $start, $kmess");

    if (mysqli_num_rows($q) > 0) {
        while ($a = mysqli_fetch_assoc($q)) {
            echo "<div class='news-card'>";
            echo "<span class='news-date'>🕒 " . date("d.m.Y H:i", $a['time']) . "</span>";

            // Если это текстовая новость (назначение менеджера или событие клуба)
            if (!$a['pl_id']) {
                echo "<div class='news-text'>" . $a['text'] . "</div>";
            } 
            // Если это трансферная новость
            else {
                echo "<div class='news-text'>Игрок: <b>" . htmlspecialchars($a['name']) . "</b></div>";
                echo "<div class='transfer-box'>";
                
                // Откуда
                echo "🏠 Откуда: ";
                if ($a['id1']) {
                    $q3 = mysqli_query($db, "SELECT name FROM fman_clubs WHERE id = " . (int)$a['id1']);
                    $data1 = mysqli_fetch_assoc($q3);
                    echo "<a href='club.php?id={$a['id1']}' class='club-link'>" . htmlspecialchars($data1['name']) . "</a>";
                } else {
                    echo "<span style='color:#7f8c8d;'>Свободный агент</span>";
                }

                echo "<br><span class='transfer-arrow'>↓</span> Куда: ";
                
                // Куда
                if ($a['id2']) {
                    $q4 = mysqli_query($db, "SELECT name FROM fman_clubs WHERE id = " . (int)$a['id2']);
                    $data2 = mysqli_fetch_assoc($q4);
                    echo "<a href='club.php?id={$a['id2']}' class='club-link'>" . htmlspecialchars($data2['name']) . "</a>";
                } else {
                    echo "<span style='color:#e74c3c;'>Уволен / Без клуба</span>";
                }
                echo "</div>";
            }
            echo "</div>";
        }

        // Вывод пагинации
        if ($total_pages > 1) {
            echo "<div class='pagination'>";
            for ($i = 1; $i <= $total_pages; $i++) {
                $active = ($i == $page) ? 'page-active' : '';
                echo "<a href='news.php?act=$act&id=$id&page=$i' class='page-link $active'>$i</a>";
            }
            echo "</div>";
        }

    } else {
        echo "<div class='note-item'>Новостей пока нет.</div>";
    }
    ?>

    <div class="info-card" style="text-align:center; padding:10px; font-size:12px; color:#7f8c8d;">
        Всего записей: <b><?php echo $total; ?></b>
    </div>

    <div style="text-align:center; margin-top:20px;">
        <?php if($id): ?>
            <a href="club.php?id=<?php echo $id; ?>" style="text-decoration:none; color:#3498db; font-weight:bold;">⬅ Назад в <?php echo htmlspecialchars($t['name']); ?></a><br><br>
        <?php endif; ?>
        <a href="index.php" style="text-decoration:none; color:#7f8c8d;">🏠 В офис менеджера</a>
    </div>
</div>

<?php include '../system/footer.php'; ?>

