<?php
// 1. Подключаем БД и заголовок
require_once '../system/db.php';
date_default_timezone_set('Europe/Moscow');
include '../system/header.php';

// 2. Подключаем основной файл функций (который теперь тянет за собой ab.php)
require_once "manfunc.php"; 

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Определение прав (уровень 9)
$user_rights = 0;
if (isset($rights)) $user_rights = (int)$rights;
elseif (isset($user_data['level'])) $user_rights = (int)$user_data['level'];
$is_admin = ($user_rights >= 9);

// 3. Получаем данные матча
$qm = mysqli_query($db, "SELECT * FROM `fman_matches` WHERE `id` = '$id' LIMIT 1");
$data = mysqli_fetch_assoc($qm);

if (!$data) {
    echo "<div class='rmenu'>Матч не найден</div>";
    include '../system/footer.php'; exit;
}

// --- ОБРАБОТКА ПРИНУДИТЕЛЬНОГО ЗАПУСКА ---
if ($is_admin && isset($_POST['force_start']) && $data['end'] == 0) {
    if (function_exists('siv')) {
        // Запускаем симуляцию (в вашем ab.php она сама обновит БД)
        siv($id); 
        
        echo "<div class='gmenu'>✅ Матч успешно сгенерирован администратором!</div>";
        
        // Перезагружаем данные для отображения счета
        $qm = mysqli_query($db, "SELECT * FROM `fman_matches` WHERE `id` = '$id' LIMIT 1");
        $data = mysqli_fetch_assoc($qm);
    } else {
        echo "<div class='rmenu'>❌ Критическая ошибка: Функция siv() всё еще не видна. Проверьте путь к ab.php в manfunc.php</div>";
    }
}

// Авто-генерация по времени (если пользователь просто зашел)
if ($data['time'] <= time() && $data['end'] == 0 && function_exists('siv')) {
    siv($id);
    $data = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `fman_matches` WHERE `id` = '$id' LIMIT 1"));
}

// Дизайн страницы...
?>

<div style="max-width: 600px; margin: 0 auto; padding: 10px;">
    <?php if ($is_admin && $data['end'] == 0): ?>
    <div style="background: #fff3cd; padding: 15px; border-radius: 10px; text-align: center; margin-bottom: 10px;">
        <form method="post">
            <button type="submit" name="force_start" style="background: #d9534f; color: #fff; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; font-weight: bold;">
                ⚡ ЗАПУСТИТЬ МАТЧ ПРИНУДИТЕЛЬНО
            </button>
        </form>
    </div>
    <?php endif; ?>

    <div style="background: #1c1c1e; border-radius: 15px; padding: 25px; color: #fff; text-align: center;">
        <div style="font-size: 12px; opacity: 0.6; margin-bottom: 10px;">
            <?php echo ($data['end'] == 1) ? 'МАТЧ ЗАВЕРШЕН' : 'ПРЯМОЙ ЭФИР / ОЖИДАНИЕ'; ?>
        </div>
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <div style="flex: 1; font-weight: bold;"><?php echo $data['kom1']; ?></div>
            <div style="flex: 1; font-size: 36px; font-weight: 900;"><?php echo $data['sc1']; ?> : <?php echo $data['sc2']; ?></div>
            <div style="flex: 1; font-weight: bold;"><?php echo $data['kom2']; ?></div>
        </div>
    </div>

    <div class="card" style="margin-top: 15px; padding: 0;">
        <div style="background: #f2f2f7; padding: 10px; font-weight: bold; border-bottom: 1px solid #ddd;">СОБЫТИЯ</div>
        <?php
        $has_events = false;
        for ($i = 1; $i <= 16; $i++) {
            if (!empty($data['s'.$i])) {
                $has_events = true;
                $e = explode('|', $data['s'.$i]);
                echo "<div style='display:flex; padding:10px; border-bottom:1px solid #eee; font-size: 14px;'>
                        <span style='width:35px; color:#888; font-weight:bold;'>{$e[0]}'</span>
                        <span>" . ($e[1] ?? '') . "</span>
                      </div>";
            }
        }
        if (!$has_events) echo "<div style='padding: 20px; text-align: center; color: #999;'>Событий еще нет...</div>";
        ?>
    </div>
</div>

<?php include '../system/footer.php'; ?>

