<?php
require_once '../system/db.php';
include '../system/header.php';

// --- ПРОВЕРКА АВТОРИЗАЦИИ (как в рабочем профиле) ---
$my_id = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : 0;

if (!$my_id) {
    echo "<div style='padding:20px; text-align:center;'>
            <div class='note-item' style='border-left:4px solid #e74c3c; display:inline-block;'>
                Для игры необходимо <a href='/users/login.php'>войти в аккаунт</a>.
            </div>
          </div>";
    include '../system/footer.php'; 
    exit;
}

// Получаем актуальные данные пользователя (уровень доступа)
$res_user = mysqli_query($db, "SELECT level FROM users WHERE id = $my_id");
$user_data = mysqli_fetch_assoc($res_user);
$rights = $user_data['level'] ?? 0;

$realtime = time();

// Заменяем clean() на безопасный метод mysqli
$act = isset($_GET['act']) ? mysqli_real_escape_string($db, $_GET['act']) : '';

// --- CSS СТИЛИ (оставляем ваши красивые стили) ---
?>
<style>
    :root {
        --primary: #2c3e50; --accent: #3498db; --bg-card: #ffffff;
        --text-main: #333; --success: #27ae60; --danger: #e74c3c;
        --shadow: 0 2px 8px rgba(0,0,0,0.08);
    }
    .fman-container { font-family: 'Segoe UI', sans-serif; padding: 10px; color: var(--text-main); }
    .card-title { font-size: 14px; font-weight: 700; text-transform: uppercase; color: #7f8c8d; margin: 20px 0 10px 5px; letter-spacing: 1px; }
    .menu-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(140px, 1fr)); gap: 10px; margin-bottom: 20px; }
    .menu-item { background: var(--bg-card); padding: 15px 10px; border-radius: 12px; text-align: center; text-decoration: none; color: var(--primary); font-weight: 600; font-size: 13px; box-shadow: var(--shadow); transition: all 0.3s ease; display: flex; flex-direction: column; align-items: center; justify-content: center; border: 1px solid #f0f0f0; }
    .menu-item:active { transform: scale(0.95); background: #f8f9fa; }
    .lands-box { display: flex; flex-wrap: wrap; gap: 8px; background: var(--bg-card); padding: 15px; border-radius: 12px; box-shadow: var(--shadow); }
    .btn-land { background: #f1f2f6; padding: 8px 12px; border-radius: 20px; font-size: 12px; text-decoration: none; color: var(--primary); transition: 0.2s; }
    .btn-land:hover { background: var(--accent); color: white; }
    .club-status { background: linear-gradient(135deg, #2c3e50, #4b6584); color: white; padding: 20px; border-radius: 15px; margin-bottom: 20px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
    .club-status a { color: #fff; text-decoration: underline; font-weight: bold; }
    .badge { background: var(--danger); color: white; font-size: 10px; padding: 2px 6px; border-radius: 10px; margin-left: 5px; }
</style>

<div class="fman-container">

<?php
// Получаем клуб текущего менеджера
$res_club = mysqli_query($db, "SELECT id, name FROM fman_clubs WHERE user_id='$my_id' LIMIT 1");
$dc = mysqli_fetch_assoc($res_club);
$club_id = $dc['id'] ?? 0;
$club_name = $dc['name'] ?? "";

// Если выбрана конкретная страна (act содержит код страны)
$check_land = mysqli_query($db, "SELECT name FROM fman_lands WHERE code = '$act' LIMIT 1");
if (mysqli_num_rows($check_land) > 0) {
    $land_info = mysqli_fetch_assoc($check_land);
    
    echo "<div class='club-status' style='text-align:center;'>
            <div style='font-size:24px; margin-bottom:10px;'>🏁</div>
            <h2 style='margin:0;'>" . $land_info['name'] . "</h2>
          </div>";
    
    echo "<div class='menu-grid'>
            <a href='table.php?act=champ&land=$act' class='menu-item'>🏆 Чемпионат</a>
            <a href='table.php?act=cup&land=$act' class='menu-item'>🍷 Кубок</a>
            <a href='table.php?act=supercup&land=$act' class='menu-item'>⭐ Суперкубок</a>
          </div>";
    echo "<a href='index.php' class='menu-item' style='width:100%; max-width:200px; margin:0 auto;'>⬅ Назад в офис</a>";

} else {
    // --- ГЛАВНЫЙ ЭКРАН ---
    if (!$club_id) {
        echo "<div class='club-status' style='background:linear-gradient(135deg, #f39c12, #e67e22);'>
                <b>У вас еще нет команды!</b><br>
                <small>Начните свою карьеру прямо сейчас</small><br><br>
                <a href='zayv.php' style='background:#fff; color:#e67e22; padding:5px 15px; border-radius:15px; text-decoration:none; font-weight:bold;'>Выбрать клуб</a>
              </div>";
    } else {
        echo "<div class='club-status'>
                <div style='font-size:12px; opacity:0.8;'>Ваш клуб:</div>
                <div style='font-size:20px;'>⚽ <a href='club.php?id=$club_id'>$club_name</a></div>
                <div style='margin-top:10px; font-size:13px;'>
                    <a href='matches.php?act=b'>📅 Календарь</a> &nbsp;&nbsp; 
                    <a href='matches.php?act=p'>📜 Результаты</a>
                </div>
              </div>";
    }

    // Счётчик трансферных новостей
    $count_trans_res = mysqli_query($db, "SELECT COUNT(*) FROM fman_news WHERE pl_id > 0 AND club_id = 0");
    $count_trans = mysqli_fetch_row($count_trans_res)[0];

    if ($rights >= 7) {
        echo "<a href='adminka.php' class='menu-item' style='background:#ffebee; color:var(--danger); border:1px solid #ffcdd2; margin-bottom:15px; width:100%;'>⚙️ Панель управления</a>";
    }

    echo "<div class='card-title'>🏠 Игровое меню</div>";
    echo "<div class='menu-grid'>
            <a href='pravila.php' class='menu-item'>📜 Правила</a>
            <a href='trans.php' class='menu-item'>⚖️ Трансферы " . ($count_trans > 0 ? "<span class='badge'>$count_trans</span>" : "") . "</a>
            <a href='rait_bomb.php' class='menu-item'>👟 Бомбардиры</a>
            <a href='uch.php' class='menu-item'>👥 Участники</a>
          </div>";

    echo "<div class='card-title'>💼 Офис и Финансы</div>";
    echo "<div class='menu-grid'>
            <a href='build.php' class='menu-item'>🏗 Постройки</a>
            <a href='spons.php' class='menu-item'>💰 Спонсоры</a>
            <a href='bank.php' class='menu-item'>🏦 Банк</a>
            <a href='shop.php' class='menu-item'>🛒 Магазин</a>
          </div>";

    echo "<div class='card-title'>🌍 Страны Европы</div>";
    echo "<div class='lands-box'>";
    $ql = mysqli_query($db, "SELECT * FROM fman_lands ORDER BY name ASC");
    while ($al = mysqli_fetch_assoc($ql)) {
        echo "<a href='index.php?act=".$al['code']."' class='btn-land'>".$al['name']."</a>";
    }
    echo "</div>";
}
?>
</div>
<?php
include '../system/footer.php';
?>

