<?php
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php"; 

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$my_id = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : 0;

// Если ID не передан, пытаемся открыть финансы клуба текущего юзера
if (!$id && $my_id) {
    $res_my_club = mysqli_query($db, "SELECT id FROM fman_clubs WHERE user_id = $my_id LIMIT 1");
    $my_club_data = mysqli_fetch_assoc($res_my_club);
    $id = $my_club_data['id'] ?? 0;
}

if (!$id) {
    echo "<div class='note-item'>Клуб не выбран.</div>";
    include '../system/footer.php'; exit;
}

// Получаем данные клуба
$q = mysqli_query($db, "SELECT * FROM fman_clubs WHERE id = $id LIMIT 1");
$a = mysqli_fetch_assoc($q);

if (!$a) {
    echo "<div class='note-item'>Клуб не найден.</div>";
    include '../system/footer.php'; exit;
}

// РАСЧЕТ ЗАРПЛАТЫ (ваша оригинальная формула)
$qp = mysqli_query($db, "SELECT * FROM fman_players WHERE team_id = $id");
$total_salary = 0;
while($aj = mysqli_fetch_assoc($qp))
{
    // Формула рыночной стоимости и зарплаты
    $markt = (1000000 * $aj['rait']) + (($aj['u'] + $aj['vyn'] + $aj['ig'] + $aj['otb'] + $aj['drib'] + ($aj['gk'] * 4) + $aj['f'] + $aj['toch'] + $aj['priem'] + $aj['pas']) * 500000);
    $zarplat = round($markt / 800);
    $total_salary += $zarplat;
}

$stadium_cost = $a['stadv'] * 20; // Содержание стадиона
$buildings_income = $a['plus']; // Доход от построек
$weekly_balance = $buildings_income - ($total_salary + $stadium_cost);
?>

<style>
    .finance-card {
        background: white; border-radius: 15px; padding: 20px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05); margin-bottom: 20px;
    }
    .budget-main {
        text-align: center; background: linear-gradient(135deg, #2ecc71, #27ae60);
        color: white; padding: 25px; border-radius: 15px; margin-bottom: 20px;
    }
    .budget-main small { opacity: 0.8; text-transform: uppercase; font-size: 12px; letter-spacing: 1px; }
    .budget-main h2 { margin: 5px 0 0; font-size: 28px; }

    .fin-row { 
        display: flex; justify-content: space-between; align-items: center;
        padding: 12px 0; border-bottom: 1px solid #f1f2f6;
    }
    .fin-row:last-child { border-bottom: none; }
    .fin-label { color: #7f8c8d; font-size: 14px; }
    .fin-value { font-weight: bold; color: #2c3e50; }
    
    .negative { color: #e74c3c !important; }
    .positive { color: #27ae60 !important; }

    .balance-box {
        margin-top: 15px; padding: 15px; border-radius: 10px;
        background: #f8f9fa; text-align: center;
    }
</style>

<div style="padding: 10px;">
    <h2 align="center">Финансовый отчет</h2>

    <div class="budget-main">
        <small>Текущий бюджет клуба</small>
        <h2>$<?php echo number_format($a['budj'], 0, '.', ' '); ?></h2>
    </div>

    <div class="finance-card">
        <div class="card-title" style="margin-bottom:10px; font-weight:bold; color:#2c3e50;">📊 Еженедельный оборот</div>
        
        <div class="fin-row">
            <span class="fin-label">📈 Доход от построек</span>
            <span class="fin-value positive">+$<?php echo number_format($buildings_income, 0, '.', ' '); ?></span>
        </div>

        <div class="fin-row">
            <span class="fin-label">📉 Зарплата игроков</span>
            <span class="fin-value negative">-$<?php echo number_format($total_salary, 0, '.', ' '); ?></span>
        </div>

        <div class="fin-row">
            <span class="fin-label">🏟️ Содержание стадиона</span>
            <span class="fin-value negative">-$<?php echo number_format($stadium_cost, 0, '.', ' '); ?></span>
        </div>

        <div class="balance-box">
            <div style="font-size: 12px; color: #7f8c8d;">ПРОГНОЗ БАЛАНСА В НЕДЕЛЮ</div>
            <div style="font-size: 18px; font-weight: bold;" class="<?php echo ($weekly_balance >= 0 ? 'positive' : 'negative'); ?>">
                <?php echo ($weekly_balance >= 0 ? '+' : ''); ?>$<?php echo number_format($weekly_balance, 0, '.', ' '); ?>
            </div>
        </div>
    </div>
    
    

    <div class="menu" style="text-align: center;">
        <a href="club.php?id=<?php echo $id; ?>" style="font-weight: bold; text-decoration: none; color: #3498db;">
            ⬅ Назад в <?php echo htmlspecialchars($a['name']); ?>
        </a>
    </div>

    <div class="phdr" style="text-align: center; margin-top: 15px;">
        <a href="index.php">Футбольный Менеджер</a>
    </div>
</div>

<?php include '../system/footer.php'; ?>

