<?php
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php"; 

// --- НАСТРОЙКИ ДОСТУПА ---
$my_id = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : 0;
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Узнаем ID моего клуба
$my_club_id = 0;
if ($my_id) {
    $res_my_c = mysqli_query($db, "SELECT id FROM fman_clubs WHERE user_id = $my_id LIMIT 1");
    $my_club_data = mysqli_fetch_assoc($res_my_c);
    $my_club_id = $my_club_data['id'] ?? 0;
}

// Если ID не задан, открываем свой клуб
if (!$id) $id = $my_club_id;

if (!$id) {
    echo "<div class='note-item' style='border-left:4px solid #e74c3c; margin:20px;'>Клуб не выбран.</div>";
    include '../system/footer.php'; exit;
}

// Загрузка данных текущего клуба
$q = mysqli_query($db, "SELECT * FROM fman_clubs WHERE id = '$id' LIMIT 1");
$a = mysqli_fetch_assoc($q);

if (!$a) {
    echo "<div class='note-item'>Клуб не существует.</div>";
    include '../system/footer.php'; exit;
}

$is_my_club = ($my_id && $a['user_id'] == $my_id);
?>

<style>
    :root {
        --primary: #2c3e50; --accent: #3498db; --success: #27ae60; --danger: #e74c3c; --shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    .club-container { padding: 10px; font-family: 'Segoe UI', sans-serif; }
    .club-header {
        background: linear-gradient(135deg, #1e3799, #009432);
        color: white; padding: 25px 15px; border-radius: 20px; text-align: center; margin-bottom: 20px; box-shadow: var(--shadow);
    }
    .club-logo { width: 80px; height: 80px; background: white; border-radius: 50%; padding: 10px; margin: 0 auto 10px; }
    .club-logo img { width: 100%; height: auto; border-radius: 50%; }
    .info-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 10px; margin-bottom: 20px; }
    .info-card { background: white; padding: 12px; border-radius: 12px; box-shadow: var(--shadow); border-bottom: 3px solid var(--accent); }
    .info-card small { color: #7f8c8d; font-size: 11px; text-transform: uppercase; display: block; }
    .info-card b { font-size: 15px; color: var(--primary); }
    .action-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(105px, 1fr)); gap: 10px; }
    .action-item { 
        background: white; padding: 15px 5px; border-radius: 15px; text-align: center;
        text-decoration: none; color: var(--primary); font-size: 11px; font-weight: 600;
        box-shadow: var(--shadow); border: 1px solid #eee;
    }
    .action-item i { font-size: 20px; display: block; margin-bottom: 5px; }
    .btn-tm { background: #fff9c4; border-color: #f1c40f; }
    .btn-tm-active { background: #e8f5e9; border-color: #2ecc71; color: #27ae60; }
</style>

<div class="club-container">

    <div class="club-header">
        <div class="club-logo">
            <?php 
            $logo = "emblems/{$a['id']}.jpg";
            echo file_exists($logo) ? "<img src='$logo'>" : "<span style='font-size:40px;'>🛡️</span>";
            ?>
        </div>
        <h2 style="margin:0; font-size:22px;"><?php echo htmlspecialchars($a['name']); ?></h2>
        <div style="font-size:13px; opacity:0.9;">📍 <?php echo htmlspecialchars($a['city']); ?></div>
    </div>

    <div class="info-grid">
        <div class="info-card"><small>💰 Бюджет</small><b>$<?php echo number_format($a['budj'], 0, '.', ' '); ?></b></div>
        <div class="info-card"><small>🏟️ Стадион</small><b><?php echo number_format($a['stadv'], 0, '.', ' '); ?></b></div>
        <div class="info-card" style="grid-column: span 2;">
            <small>👤 Менеджер</small>
            <?php 
            if ($a['user_id'] > 0) {
                $udata = mysqli_fetch_assoc(mysqli_query($db, "SELECT login FROM users WHERE id = '{$a['user_id']}'"));
                echo "<b style='color:var(--accent);'>{$udata['login']}</b>";
            } else {
                echo "<span style='color:var(--success);'>Вакантно</span> ";
                // КНОПКА "ЗАНЯТЬ" ТОЛЬКО ЕСЛИ У МЕНЯ НЕТ КЛУБА
                if ($my_id && $my_club_id == 0) {
                    echo "<a href='zayv.php?id=$id' style='font-size:12px; background:#27ae60; color:#white; padding:2px 8px; border-radius:5px; text-decoration:none;'>Занять клуб</a>";
                }
            }
            ?>
        </div>
    </div>

    <div class="card-title" style="font-weight:bold; color:#7f8c8d; font-size:12px; margin-bottom:10px; padding-left:5px;">УПРАВЛЕНИЕ</div>

    <div class="action-grid">
        <a href="list-of-players.php?id=<?php echo $id; ?>" class="action-item"><i>👥</i> Игроки</a>
        <a href="news.php?id=<?php echo $id; ?>" class="action-item"><i>📜</i> Журнал</a>
        
        <?php if($is_my_club): ?>
            <a href="sostav.php" class="action-item" style="background:#e3f2fd;"><i>⚽</i> Состав</a>
            <a href="finance.php" class="action-item"><i>📈</i> Финансы</a>
        <?php else: ?>
            <?php 
            if ($my_club_id > 0 && $a['user_id'] > 0) {
                $check_tm = mysqli_query($db, "SELECT id, sender_club_id FROM fman_tm_requests 
                    WHERE (sender_club_id = '$my_club_id' AND receiver_club_id = '$id') 
                    OR (sender_club_id = '$id' AND receiver_club_id = '$my_club_id') 
                    AND status = 'pending' LIMIT 1");
                $tm_req = mysqli_fetch_assoc($check_tm);

                if (!$tm_req) {
                    echo "<a href='tm.php?id=$id' class='action-item btn-tm'><i>🤝</i> Вызвать на ТМ</a>";
                } elseif ($tm_req['sender_club_id'] == $id) {
                    echo "<a href='tm.php?id=$id' class='action-item btn-tm-active'><i>✅</i> Принять ТМ</a>";
                } else {
                    echo "<div class='action-item' style='opacity:0.6;'><i>⏳</i> Ждем ответа</div>";
                }
            }
            ?>
        <?php endif; ?>

        <a href="matches.php?act=b&id=<?php echo $id; ?>" class="action-item"><i>📅</i> Календарь</a>
        <a href="stad.php?id=<?php echo $id; ?>" class="action-item"><i>🏟️</i> Стадион</a>
    </div>

    <div style="text-align:center; margin-top:25px;">
        <a href="index.php" style="text-decoration:none; color:#7f8c8d; font-size:13px;">⬅ В офис</a>
    </div>
</div>

<?php include '../system/footer.php'; ?>

