<?php
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php"; 

// Проверка прав (уровень 7 и выше)
if (!isset($_SESSION['level']) || $_SESSION['level'] < 7) {
    header("Location: /"); exit;
}

/**
 * ПРОВЕРКА И СОЗДАНИЕ ТАБЛИЦЫ ИГРОКОВ
 */
mysqli_query($db, "CREATE TABLE IF NOT EXISTS `fman_players` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `team_id` int(11) NOT NULL DEFAULT '0',
    `name` varchar(255) NOT NULL,
    `pos` int(2) DEFAULT '1',
    `ampl` int(2) DEFAULT '1',
    `rait` int(3) DEFAULT '1',
    `age` int(2) DEFAULT '20',
    `height` int(3) DEFAULT '180',
    `nationality` varchar(10) DEFAULT 'ru',
    `foto` varchar(255) DEFAULT 'nophoto.jpg',
    `cena` bigint(20) DEFAULT '0',
    `travm` int(1) DEFAULT '0',
    `trans` int(1) DEFAULT '0',
    `forma` int(2) DEFAULT '6',
    `ust` int(2) DEFAULT '6',
    `nast` int(2) DEFAULT '6',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$p_url = $id ? "id=$id" : "";

echo "<div class='fman-container'>";

// Инициализация данных для редактирования
$a = [
    'name' => '', 'team_id' => 0, 'pos' => 1, 'rait' => 10, 
    'foto' => 'nophoto.jpg', 'age' => 22, 'height' => 182, 'nationality' => 'ru'
];

if ($id) {
    $q = mysqli_query($db, "SELECT * FROM `fman_players` WHERE `id` = $id LIMIT 1");
    if (mysqli_num_rows($q) > 0) {
        $a = mysqli_fetch_assoc($q);
    }
}

if (!isset($_POST['submit'])) {
    echo "<div class='card-title'>" . ($id ? "📝 Редактировать: " . htmlspecialchars($a['name']) : "🆕 Создать игрока") . "</div>";
    ?>
    <form action='admplayer.php?<?php echo $p_url; ?>' method='post' class='exchange-form' style='background:#f9f9f9; padding:15px; border-radius:12px;'>
        <label style='font-size:12px; color:#666;'>Полное имя:</label><br/>
        <input type='text' name='name' value='<?php echo htmlspecialchars($a['name']); ?>' style='width:100%; padding:10px; margin-bottom:10px; border-radius:5px; border:1px solid #ccc;' required>

        <div style="display:grid; grid-template-columns: 1fr 1fr; gap:10px;">
            <div>
                <label style='font-size:12px; color:#666;'>ID команды:</label>
                <input type='number' name='team_id' value='<?php echo $a['team_id']; ?>' style='width:100%; padding:10px; border-radius:5px; border:1px solid #ccc;'>
            </div>
            <div>
                <label style='font-size:12px; color:#666;'>Талант (1-20):</label>
                <input type='number' name='rait' value='<?php echo $a['rait']; ?>' min="1" max="25" style='width:100%; padding:10px; border-radius:5px; border:1px solid #ccc;'>
            </div>
        </div>

        <label style='font-size:12px; color:#666; margin-top:10px; display:block;'>Позиция (амплуа):</label>
        <select name='pos' style='width:100%; padding:10px; margin-bottom:10px; border-radius:5px; border:1px solid #ccc;'>
            <?php
            $positions = [
                1 => 'Вратарь (GK)', 2 => 'Левый защ. (LB)', 3 => 'Центр защ. (CB)', 
                4 => 'Правый защ. (RB)', 5 => 'Опорный полузащ. (CDM)', 6 => 'Левый полузащ. (LM)', 
                7 => 'Центр полузащ. (CM)', 8 => 'Правый полузащ. (RM)', 9 => 'Атак. полузащ. (CAM)', 10 => 'Нападающий (ST)'
            ];
            foreach ($positions as $val => $name) {
                $sel = ($a['pos'] == $val) ? "selected" : "";
                echo "<option value='$val' $sel>$name</option>";
            }
            ?>
        </select>

        <label style='font-size:12px; color:#666;'>Ссылка на фото:</label>
        <input type='text' name='foto' value='<?php echo $a['foto']; ?>' style='width:100%; padding:10px; margin-bottom:10px; border-radius:5px; border:1px solid #ccc;'>

        <div style="display:grid; grid-template-columns: 1fr 1fr 1fr; gap:10px;">
            <div>
                <label style='font-size:11px;'>Возраст:</label>
                <input type='number' name='age' value='<?php echo $a['age']; ?>' style='width:100%; padding:8px;'>
            </div>
            <div>
                <label style='font-size:11px;'>Рост (см):</label>
                <input type='number' name='height' value='<?php echo $a['height']; ?>' style='width:100%; padding:8px;'>
            </div>
            <div>
                <label style='font-size:11px;'>Нац. (код):</label>
                <input type='text' name='nationality' value='<?php echo $a['nationality']; ?>' style='width:100%; padding:8px;'>
            </div>
        </div>

        <?php if ($id): ?>
            <div style="margin: 15px 0; background: #fee; padding: 10px; border-radius: 5px; border: 1px solid #fcc;">
                <input type='checkbox' name='del' value='1' id="delcheck"> <label for="delcheck" style="color:red; font-weight:bold;">УДАЛИТЬ ИГРОКА</label>
            </div>
        <?php endif; ?>

        <button type='submit' name='submit' value='1' style='margin-top:15px; background:var(--primary); color:white; border:none; padding:12px; width:100%; border-radius:8px; font-weight:bold; cursor:pointer;'>
            💾 Сохранить изменения
        </button>
    </form>
    <?php
} else {
    // ОБРАБОТКА ДАННЫХ
    $name = mysqli_real_escape_string($db, trim($_POST['name']));
    $team_id = intval($_POST['team_id']);
    $rait = intval($_POST['rait']);
    $pos = intval($_POST['pos']);
    $age = intval($_POST['age']);
    $height = intval($_POST['height']);
    $nationality = mysqli_real_escape_string($db, $_POST['nationality']);
    $foto = mysqli_real_escape_string($db, $_POST['foto']);
    
    // Авторасчет цены: Талант * Возраст * Коэффициент (примерная логика)
    $cena = ($rait * 100000) - ($age * 5000);
    if ($cena < 10000) $cena = 10000;

    if (!empty($name) && $rait > 0) {
        if ($id) {
            if (isset($_POST['del']) && $_POST['del'] == 1) {
                mysqli_query($db, "DELETE FROM `fman_players` WHERE `id` = $id");
                echo "<div class='note-item' style='border-left-color:red;'>Игрок удален!</div>";
            } else {
                mysqli_query($db, "UPDATE `fman_players` SET 
                    `team_id` = '$team_id', `name` = '$name', `rait` = '$rait', 
                    `pos` = '$pos', `ampl` = '$pos', `foto` = '$foto', 
                    `age` = '$age', `height` = '$height', `nationality` = '$nationality' 
                    WHERE `id` = $id");
                echo "<div class='note-item' style='border-left-color:green;'>Данные обновлены!</div>";
            }
        } else {
            mysqli_query($db, "INSERT INTO `fman_players` SET 
                `team_id` = '$team_id', `name` = '$name', `rait` = '$rait', 
                `pos` = '$pos', `ampl` = '$pos', `foto` = '$foto', 
                `age` = '$age', `height` = '$height', `nationality` = '$nationality',
                `cena` = '$cena', `travm` = 0, `trans` = 0, `forma` = 6, `ust` = 6, `nast` = 6");
            echo "<div class='note-item' style='border-left-color:green;'>Игрок успешно создан!</div>";
        }
    } else {
        echo "<div class='note-item' style='border-left-color:red;'>Ошибка: Имя и талант обязательны!</div>";
    }

    echo "<div style='text-align:center; margin-top:20px;'>
            <a href='admplayer.php' class='btn-land'>Создать еще одного</a><br><br>
            <a href='adminka.php' style='color:#666;'>Вернуться в админку</a>
          </div>";
}

echo "</div>";

include '../system/footer.php';
?>

