<?php
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php"; 

// Проверка прав (уровень 5 и выше)
if (!isset($_SESSION['level']) || $_SESSION['level'] < 5) {
    header("Location: /"); exit;
}

/**
 * БЛОК ПРОВЕРКИ И СОЗДАНИЯ ТАБЛИЦ
 */
$tables_check = [
    'fman_clubs' => "CREATE TABLE IF NOT EXISTS `fman_clubs` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(255) NOT NULL,
        `user_id` int(11) DEFAULT '0',
        `u9` int(1) DEFAULT '0',
        `fan` int(11) DEFAULT '0',
        `budj` bigint(20) DEFAULT '0',
        `last_pay` int(11) DEFAULT '0',
        `plus` int(11) DEFAULT '0',
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
    
    'fman_matches' => "CREATE TABLE IF NOT EXISTS `fman_matches` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `time` int(11) NOT NULL,
        `turn` varchar(50) DEFAULT '',
        `tur` int(11) DEFAULT '0',
        `kom1` varchar(255) DEFAULT '',
        `id1` int(11) DEFAULT '0',
        `kom2` varchar(255) DEFAULT '',
        `id2` int(11) DEFAULT '0',
        `sc1` int(5) DEFAULT '0',
        `sc2` int(5) DEFAULT '0',
        `end` int(1) DEFAULT '0',
        `land` varchar(10) DEFAULT '',
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;"
];

foreach ($tables_check as $table => $sql) {
    mysqli_query($db, $sql);
}

// Параметры
$act = isset($_GET['act']) ? clean($_GET['act']) : 'default';
$do = isset($_GET['do']) ? clean($_GET['do']) : '';
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

echo "<div class='fman-container'>";

switch ($act) {
    // --- ГЛАВНОЕ МЕНЮ АДМИНКИ ---
    default:
        echo "<div class='card-title'>⚙️ Управление менеджером</div>";
        echo "<div class='menu-grid'>
            <a href='adminka.php?act=pod' class='menu-item'>✅ Заявки</a>
            <a href='uch.php?act=adm' class='menu-item'>👥 Клубы</a>
            <a href='addbuild.php' class='menu-item'>🏗 Постройки</a>
            <a href='addspons.php' class='menu-item'>💰 Спонсоры</a>
            <a href='addmatches.php' class='menu-item'>⚽ Матчи</a>
            <a href='admplayer.php' class='menu-item'>🏃 Игроки</a>
            <a href='admin.php' class='menu-item'>⚖️ Трансферы</a>
            <a href='/medal/add.php' class='menu-item'>🏆 Трофеи</a>
        </div>";

        echo "<div class='card-title'>📅 Сезонные работы</div>";
        echo "<div class='menu-grid'>
            <a href='adminka.php?act=calendar' class='menu-item' style='border-bottom:3px solid #e74c3c;'>📅 Новый календарь</a>
        </div>";
        break;

    // --- ПОДТВЕРЖДЕНИЕ ЗАЯВОК ---
    case 'pod':
        echo "<div class='card-title'>Заявки на вступление</div>";
        if (!$id) {
            $q = mysqli_query($db, "SELECT * FROM `fman_clubs` WHERE `user_id` > 0 AND `u9` < 1");
            
            if ($q && mysqli_num_rows($q) > 0) {
                while ($a = mysqli_fetch_assoc($q)) {
                    $user_q = mysqli_query($db, "SELECT `name` FROM `users` WHERE `id`='{$a['user_id']}' LIMIT 1");
                    $udata = ($user_q) ? mysqli_fetch_assoc($user_q) : ['name' => 'Удален'];
                    
                    echo "<div class='menu' style='border-bottom:1px solid #eee; padding:10px;'>
                        <b>" . htmlspecialchars($udata['name']) . "</b> хочет клуб <b>" . htmlspecialchars($a['name']) . "</b><br/>
                        <div style='margin-top:5px;'>
                            <a href='adminka.php?act=pod&amp;do=prin&amp;id={$a['id']}' style='color:green; font-weight:bold;'>[Принять]</a> 
                            <a href='adminka.php?act=pod&amp;do=otkl&amp;id={$a['id']}' style='color:red; margin-left:15px;'>[Отклонить]</a>
                        </div>
                    </div>";
                }
            } else {
                echo "<div class='note-item'>Новых заявок нет</div>";
            }
        } else {
            if ($do == "prin") {
                mysqli_query($db, "UPDATE `fman_clubs` SET `u9` = 1 WHERE `id` = $id");
                echo "<div class='note-item' style='border-left-color:green;'>Заявка принята!</div>";
            } elseif ($do == "otkl") {
                mysqli_query($db, "UPDATE `fman_clubs` SET `u9` = 0, `user_id` = 0 WHERE `id` = $id");
                echo "<div class='note-item' style='border-left-color:red;'>Заявка отклонена!</div>";
            }
            echo "<br><a href='adminka.php?act=pod' class='btn-land'>Назад к списку</a>";
        }
        break;

    // --- ГЕНЕРАЦИЯ КАЛЕНДАРЯ ---
    case 'calendar':
        echo "<div class='card-title'>Генератор календаря</div>";
        
        if (!isset($_POST['submit'])) {
            echo "<div class='exchange-form' style='background:#f9f9f9; padding:15px; border-radius:10px;'>
                <form action='adminka.php?act=calendar' method='post'>
                    <label style='font-size:12px; color:#666;'>Выберите дату начала (1-й тур):</label><br/>
                    <input type='date' name='start_date' value='".date("Y-m-d")."' style='width:100%; padding:10px; margin:10px 0;' required><br/>
                    <div style='background:#fff3cd; padding:10px; border-radius:8px; font-size:11px; margin-bottom:10px; color:#856404;'>
                        ⚠️ Внимание! Все старые матчи чемпионатов будут безвозвратно удалены!
                    </div>
                    <button type='submit' name='submit' style='background:#e74c3c; color:white; border:none; padding:12px; width:100%; border-radius:8px; cursor:pointer;'>Сгенерировать календарь</button>
                </form>
            </div>";
        } else {
            $start_date = $_POST['start_date'];
            $time_start = strtotime($start_date . " 18:00:00");
            
            // Очистка
            mysqli_query($db, "DELETE FROM `fman_matches` WHERE `turn` != 'tm' OR (`turn` = 'tm' AND `time` < ".time().")");
            
            $path = "calendar/calendar.dat";
            if (!file_exists($path)) {
                echo "<div class='note-item' style='border-left-color:red;'>Файл шаблона calendar.dat не найден по пути /man/calendar/calendar.dat</div>";
            } else {
                $file = file($path);
                $count = 0;
                foreach ($file as $line) {
                    $a = explode('|', trim($line));
                    if (count($a) < 6) continue;
                    
                    $tm = $time_start + (3600 * 24 * 2 * (intval($a[1]) - 1));
                    $land = mysqli_real_escape_string($db, $a[0]);
                    $tur = intval($a[1]);
                    $kom1 = mysqli_real_escape_string($db, $a[2]);
                    $id1 = intval($a[3]);
                    $kom2 = mysqli_real_escape_string($db, $a[4]);
                    $id2 = intval($a[5]);
                    
                    $res = mysqli_query($db, "INSERT INTO `fman_matches` SET 
                        `time` = '$tm', `turn` = 'champ', `tur` = '$tur', `end` = 0, 
                        `kom1` = '$kom1', `id1` = '$id1', `kom2` = '$kom2', `id2` = '$id2', 
                        `sc1` = 0, `sc2` = 0, `land` = '$land'");
                    if($res) $count++;
                }
                echo "<div class='note-item' style='border-left-color:green;'>
                    <b>Готово!</b><br>Создано матчей: $count<br>Старт: ".date("d.m.Y H:i", $time_start)."
                </div>";
            }
        }
        break;
}

echo "<div style='text-align:center; margin-top:20px;'>
    <a href='index.php' class='btn-land' style='text-decoration:none; padding:10px 20px; background:#eee; border-radius:5px; color:#333;'>🏠 В менеджер</a>
</div>";

echo "</div>";

include '../system/footer.php';
?>

