<?php
require_once '../system/db.php';
// Подключаем header.php (он начинает вывод HTML)
include '../system/header.php';
require_once "manfunc.php"; 

// Исправленная проверка прав: используем JS вместо header Location


/**
 * ПРОВЕРКА И СОЗДАНИЕ СИСТЕМНОЙ ТАБЛИЦЫ
 */
mysqli_query($db, "CREATE TABLE IF NOT EXISTS `manager` (
    `id` int(1) NOT NULL DEFAULT '1',
    `open` int(1) DEFAULT '0',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

$check_sys = mysqli_query($db, "SELECT * FROM `manager` WHERE `id` = 1");
if (mysqli_num_rows($check_sys) == 0) {
    mysqli_query($db, "INSERT INTO `manager` SET `id` = 1, `open` = 0");
}

$action = isset($_GET['action']) ? clean($_GET['action']) : 'default';

echo "<div class='fman-container'>";

switch ($action) {

    default:
        $q = mysqli_query($db, "SELECT `open` FROM `manager` WHERE `id` = 1");
        $res = mysqli_fetch_assoc($q);
        $is_open = ($res['open'] == 0);

        echo "<div class='card-title' style='text-align:center;'>⚖️ Управление трансферами</div>";
        echo "<div class='exchange-form' style='background:#f9f9f9; padding:20px; border-radius:12px; text-align:center; border: 1px solid #eee;'>";
        
        echo "<p style='font-size: 14px; color:#666;'>Текущий статус рынка:</p>";
        echo "<div style='font-size: 20px; margin-bottom: 20px;'>" . ($is_open ? "<b style='color:#27ae60;'>🔓 ОТКРЫТО</b>" : "<b style='color:#e74c3c;'>🔒 ЗАКРЫТО</b>") . "</div>";

        echo "<form action='admin.php?action=savesys' method='post'>";
        
        echo "<div style='display:flex; justify-content:center; gap:25px; margin-bottom:25px;'>";
        echo "<label style='cursor:pointer; display:flex; align-items:center; gap:5px;'>
                <input name='open' type='radio' value='0' ".($is_open ? "checked" : "")." /> Открыть
              </label>";
        echo "<label style='cursor:pointer; display:flex; align-items:center; gap:5px;'>
                <input name='open' type='radio' value='1' ".(!$is_open ? "checked" : "")." /> Закрыть
              </label>";
        echo "</div>";

        echo "<button type='submit' class='btn-exchange' style='background:#3498db; color:#fff; border:none; padding:12px 35px; border-radius:8px; cursor:pointer; font-weight:bold; width:100%;'>Сохранить настройки</button>";
        echo "</form>";
        echo "</div>";
        break;

    case 'savesys':
        $open = isset($_POST['open']) ? intval($_POST['open']) : 1;
        
        $update = mysqli_query($db, "UPDATE `manager` SET `open`='$open' WHERE `id` = 1");
        
        if ($update) {
            echo "<div class='note-item' style='border-left-color:#27ae60; background:#f0fff4;'>✅ Настройки трансферного окна сохранены!</div>";
        } else {
            echo "<div class='note-item' style='border-left-color:#e74c3c;'>❌ Ошибка при обращении к базе данных.</div>";
        }
        
        echo "<div style='margin-top:20px; text-align:center;'>
                <a href='adminka.php' class='btn-land' style='display:inline-block; text-decoration:none; padding:10px 20px; background:#f1f2f6; border-radius:8px; color:#2c3e50;'>⬅ Назад в Админку</a>
              </div>";
        break;
}

echo "<div style='text-align:center; margin-top:30px; border-top:1px solid #f1f2f6; padding-top:15px;'>
        <a href='index.php' style='text-decoration:none; color:#7f8c8d; font-size:13px;'>🔙 Вернуться в управление</a>
      </div>";
echo "</div>";

include '../system/footer.php';
?>
