<?php
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php"; 

// Проверка прав (уровень 7 и выше)
if (!isset($_SESSION['level']) || $_SESSION['level'] < 7) {
    header("Location: /"); exit;
}

/**
 * ПРОВЕРКА И СОЗДАНИЕ ТАБЛИЦЫ СПОНСОРОВ
 */
mysqli_query($db, "CREATE TABLE IF NOT EXISTS `fman_spons` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `name` varchar(255) NOT NULL,
    `pic` varchar(255) DEFAULT 'nopic.jpg',
    `pay` bigint(20) DEFAULT '0',
    `plus` int(11) DEFAULT '0',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

echo "<div class='fman-container'>";
echo "<div class='card-title' style='text-align:center;'>🤝 Добавление нового спонсора</div>";

if (isset($_POST['submit'])) {
    $name = isset($_POST['name']) ? mysqli_real_escape_string($db, trim($_POST['name'])) : false;
    $pic = !empty($_POST['pic']) ? mysqli_real_escape_string($db, trim($_POST['pic'])) : 'nopic.jpg';
    $pay = isset($_POST['pay']) ? abs(intval($_POST['pay'])) : 0; // Стоимость контракта
    $plus = isset($_POST['plus']) ? abs(intval($_POST['plus'])) : 0; // Доход за матч

    if (empty($name) || $pay <= 0 || $plus <= 0) {
        echo "<div class='note-item' style='border-left-color:var(--danger); color:var(--danger);'>
                <b>Ошибка:</b> Заполните название, сумму контракта и выплату за матч!
              </div>";
    } else {
        $res = mysqli_query($db, "INSERT INTO `fman_spons` SET 
            `name` = '$name', 
            `pic` = '$pic', 
            `plus` = '$plus', 
            `pay` = '$pay'");
            
        if ($res) {
            echo "<div class='note-item' style='border-left-color:var(--success); color:var(--success);'>
                    ✅ Спонсор <b>$name</b> успешно зарегистрирован!
                  </div>";
        } else {
            echo "<div class='note-item' style='border-left-color:var(--danger);'>Ошибка при сохранении в базу данных!</div>";
        }
    }
}

// Форма добавления
echo "<div class='exchange-form' style='background:#f9f9f9; padding:15px; border-radius:12px; border:1px solid #eee;'>
    <form action='addspons.php' method='post'>
        <div style='margin-bottom:10px;'>
            <label style='font-size:12px; color:#666;'>Название бренда/компании:</label><br/>
            <input type='text' name='name' placeholder='Напр: Nike, Emirates' style='width:100%; padding:10px; border-radius:5px; border:1px solid #ccc;'>
        </div>
        
        <div style='margin-bottom:10px;'>
            <label style='font-size:12px; color:#666;'>Логотип (имя файла):</label><br/>
            <input type='text' name='pic' value='nopic.jpg' style='width:100%; padding:10px; border-radius:5px; border:1px solid #ccc;'>
        </div>

        <div style='display: grid; grid-template-columns: 1fr 1fr; gap: 10px; margin-bottom:15px;'>
            <div>
                <label style='font-size:12px; color:#666;'>Сумма контракта ($):</label><br/>
                <input type='number' name='pay' placeholder='500000' style='width:100%; padding:10px; border-radius:5px; border:1px solid #ccc;'>
            </div>
            <div>
                <label style='font-size:12px; color:#666;'>За каждый матч ($):</label><br/>
                <input type='number' name='plus' placeholder='15000' style='width:100%; padding:10px; border-radius:5px; border:1px solid #ccc;'>
            </div>
        </div>

        <button type='submit' name='submit' value='1' style='background:var(--primary); color:white; border:none; padding:12px; width:100%; border-radius:8px; font-weight:bold; cursor:pointer;'>
            🤝 Заключить соглашение
        </button>
    </form>
</div>";

echo "<div style='text-align:center; margin-top:20px;'>
    <a href='adminka.php' class='btn-land' style='background:#f1f2f6; color:#2c3e50; text-decoration:none; padding:8px 15px; border-radius:5px;'>⬅ Назад в админку</a>
</div>";

echo "</div>";

include '../system/footer.php';
?>

