<?php
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php"; 

// Проверка прав доступа
if (!isset($_SESSION['level']) || $_SESSION['level'] < 7) {
    header("Location: /"); exit;
}

echo "<div class='fman-container'>";
echo "<div class='card-title' style='text-align:center;'>⚽ Массовое добавление матчей</div>";

if (!isset($_POST['submit'])) {
    ?>
    <form action='addmatches.php' method='post'>
        <div class='menu' style='background:#f9f9f9; padding:15px; border-radius:12px; margin-bottom:10px;'>
            <label style='font-size:12px; color:#666;'>Выберите турнир:</label><br/>
            <select name="turn" style="width:100%; padding:10px; margin:5px 0; border-radius:5px; border:1px solid #ccc;">
                <option value="champ">Чемпионат (champ)</option>
                <option value="cup">Нац. Кубок (cup)</option>
                <option value="supercup">Нац. Суперкубок (supercup)</option>
                <option value="lc">Лига Чемпионов (lc)</option>
                <option value="le">Лига Европы (le)</option>
                <option value="sc">Суперкубок Европы (sc)</option>
                <option value="tm">Тов. матч (tm)</option>
            </select>

            <label style='font-size:12px; color:#666;'>Код страны / Группа (ru, ua, eu, a, b...):</label><br/>
            <input type='text' name='land' placeholder='Пример: ru' style='width:100%; padding:10px; margin:5px 0; border-radius:5px; border:1px solid #ccc;' required>

            <label style='font-size:12px; color:#666;'>Тур (число):</label><br/>
            <input type='number' name='tur' value='0' style='width:100%; padding:10px; margin:5px 0; border-radius:5px; border:1px solid #ccc;'>

            <div style="display:grid; grid-template-columns: 1fr 1fr; gap:10px; margin-top:10px;">
                <div>
                    <label style='font-size:11px; color:#666;'>Дата:</label>
                    <input type="date" name="start_date" value="<?php echo date('Y-m-d'); ?>" style="width:100%; padding:8px; border-radius:5px; border:1px solid #ccc;">
                </div>
                <div>
                    <label style='font-size:11px; color:#666;'>Время:</label>
                    <input type="time" name="start_time" value="20:00" style="width:100%; padding:8px; border-radius:5px; border:1px solid #ccc;">
                </div>
            </div>
        </div>

        <div class='card-title'>Список пар команд</div>
        <div style="background:#fff; border-radius:12px; padding:10px; box-shadow: 0 2px 8px rgba(0,0,0,0.05);">
            <?php for ($i = 1; $i <= 10; $i++): ?>
                <div style="display:flex; align-items:center; gap:5px; margin-bottom:8px; padding-bottom:8px; border-bottom:1px solid #f0f0f0;">
                    <span style="color:#999; font-size:10px;"><?php echo $i; ?>.</span>
                    <input type='text' name='h_<?php echo $i; ?>' placeholder='Хозяева' style='flex:1; padding:8px; border-radius:5px; border:1px solid #eee; font-size:12px;'>
                    <span style="font-weight:bold; color:#ccc;">-</span>
                    <input type='text' name='g_<?php echo $i; ?>' placeholder='Гости' style='flex:1; padding:8px; border-radius:5px; border:1px solid #eee; font-size:12px;'>
                </div>
            <?php endfor; ?>
        </div>

        <div style="margin-top:20px;">
            <button type='submit' name='submit' value='1' style='background:var(--success); color:white; border:none; padding:15px; width:100%; border-radius:10px; font-weight:bold; cursor:pointer;'>
                🚀 Создать матчи
            </button>
        </div>
    </form>
    <?php
} else {
    // ОБРАБОТКА ПОСЛЕ ОТПРАВКИ
    $start_date = $_POST['start_date'];
    $start_time = $_POST['start_time'];
    $t = strtotime($start_date . " " . $start_time);
    
    $turn = mysqli_real_escape_string($db, $_POST['turn']);
    $land = mysqli_real_escape_string($db, $_POST['land']);
    $tur = intval($_POST['tur']);
    
    $created = 0;
    $errors = [];

    for ($i = 1; $i <= 10; $i++) {
        $h_name = trim($_POST["h_$i"]);
        $g_name = trim($_POST["g_$i"]);

        if (!empty($h_name) && !empty($g_name)) {
            $h_esc = mysqli_real_escape_string($db, $h_name);
            $g_esc = mysqli_real_escape_string($db, $g_name);

            // Ищем ID команд
            $q1 = mysqli_query($db, "SELECT `id` FROM `fman_clubs` WHERE `name`='$h_esc' LIMIT 1");
            $q2 = mysqli_query($db, "SELECT `id` FROM `fman_clubs` WHERE `name`='$g_esc' LIMIT 1");

            if (mysqli_num_rows($q1) > 0 && mysqli_num_rows($q2) > 0) {
                $a1 = mysqli_fetch_assoc($q1);
                $a2 = mysqli_fetch_assoc($q2);

                mysqli_query($db, "INSERT INTO `fman_matches` SET 
                    `time` = '$t', 
                    `turn` = '$turn', 
                    `tur` = '$tur', 
                    `end` = 0, 
                    `kom1` = '$h_esc', 
                    `id1` = '{$a1['id']}', 
                    `kom2` = '$g_esc', 
                    `id2` = '{$a2['id']}', 
                    `sc1` = 0, 
                    `sc2` = 0, 
                    `land` = '$land'");
                $created++;
            } else {
                $errors[] = "Не найдены: $h_name или $g_name";
            }
        }
    }

    if ($created > 0) {
        echo "<div class='note-item' style='border-left-color:var(--success); color:var(--success);'>
                ✅ Успешно создано матчей: <b>$created</b>
              </div>";
    }

    if (!empty($errors)) {
        echo "<div class='note-item' style='border-left-color:var(--danger); color:var(--danger); font-size:12px;'>
                <b>Ошибки:</b><br/>" . implode("<br/>", $errors) . "
              </div>";
    }

    echo "<div style='text-align:center; margin-top:20px;'>
            <a href='addmatches.php' class='btn-land' style='background:var(--primary); color:#fff;'>Добавить еще</a>
            <br/><br/>
            <a href='adminka.php' style='color:#666;'>Назад в админку</a>
          </div>";
}

echo "</div>";

include '../system/footer.php';
?>

