<?php
/**
 * FM Setup Pro v8.0
 * Авто-создание system/db.php + Принудительный UTF-8 для кириллицы
 */
session_start();
header('Content-Type: text/html; charset=utf-8');

$config_file = 'system/db.php'; 
$sql_dump = 'tar.sql';         

// 1. Системный аудит
$php_ver = PHP_VERSION;
$mysqli_ok = extension_loaded('mysqli');
$folder_ok = is_writable('.') || (is_dir('system') && is_writable('system'));

if (isset($_GET['finish'])) {
    if(file_exists(__FILE__)) unlink(__FILE__); 
    die("Установка завершена! Конфиг создан. <a href='/'>Перейти на сайт</a>");
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FM Installation Pro</title>
    <style>
        body { font-family: -apple-system, sans-serif; background: #f0f2f5; display: flex; justify-content: center; padding: 20px; }
        .inst-card { background: #fff; padding: 25px; border-radius: 16px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); width: 100%; max-width: 440px; }
        h2 { margin: 0 0 15px; text-align: center; color: #1a2a3a; border-bottom: 2px solid #eee; padding-bottom: 10px; }
        .sys-info { background: #f8f9fa; border: 1px solid #e9ecef; border-radius: 10px; padding: 15px; margin-bottom: 20px; font-size: 13px; }
        .sys-item { display: flex; justify-content: space-between; margin-bottom: 6px; }
        .ok { color: #27ae60; font-weight: bold; }
        .fail { color: #e74c3c; font-weight: bold; }
        label { display: block; font-size: 11px; font-weight: 700; color: #555; margin-bottom: 4px; text-transform: uppercase; }
        input { width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 8px; box-sizing: border-box; margin-bottom: 12px; }
        .btn { background: #3498db; color: #fff; border: none; padding: 15px; width: 100%; border-radius: 8px; cursor: pointer; font-weight: 700; font-size: 15px; transition: 0.2s; }
        .btn:hover { background: #2980b9; }
        .msg { padding: 12px; border-radius: 8px; margin-bottom: 15px; font-size: 13px; border: 1px solid; line-height: 1.5; }
        .error { background: #fff1f0; color: #cf1322; border-color: #ffa39e; }
        .success { background: #f6ffed; color: #389e0d; border-color: #b7eb8f; }
    </style>
</head>
<body>

<div class="inst-card">
    <h2>FM Установка</h2>

    <div class="sys-info">
        <div style="font-weight:bold; margin-bottom:8px;">🛠 Окружение:</div>
        <div class="sys-item"><span>PHP (7.0+):</span> <span class="<?php echo version_compare($php_ver, '7.0.0', '>=') ? 'ok' : 'fail'; ?>"><?php echo $php_ver; ?></span></div>
        <div class="sys-item"><span>MySQLi:</span> <span class="<?php echo $mysqli_ok ? 'ok' : 'fail'; ?>"><?php echo $mysqli_ok ? 'OK' : 'FAIL'; ?></span></div>
        <div class="sys-item"><span>Запись файлов:</span> <span class="<?php echo $folder_ok ? 'ok' : 'fail'; ?>"><?php echo $folder_ok ? 'ОК' : 'НЕТ ПРАВ'; ?></span></div>
    </div>

    <?php
    if (isset($_POST['setup_admin'])) {
        // Подключаем созданный на прошлом шаге конфиг
        if (file_exists($config_file)) {
            include $config_file;
            
            $login = mysqli_real_escape_string($db, $_POST['adm_login']);
            $pass  = mysqli_real_escape_string($db, $_POST['adm_pass']);
            
            $visit_date = date("Y-m-d H:i:s"); // Для timestamp
            $unix_time = time();               // Для int
            $hashed_password = password_hash($pass, PASSWORD_DEFAULT);

            // Запрос под вашу структуру
            $sql = "INSERT INTO `users` (`login`, `password`, `level`, `last_visit`, `lastdate`, `balans`, `team_id`) 
                    VALUES ('$login', '$hashed_password', '9', '$visit_date', '$unix_time', '1000000', '0')";

            if (mysqli_query($db, $sql)) {
                $user_id = mysqli_insert_id($db);
                mysqli_query($db, "INSERT INTO `fman_clubs` (`user_id`, `name`, `budj`, `id_land`) VALUES ('$user_id', 'Моя Команда', '10000000', '1')");
                $club_id = mysqli_insert_id($db);
                mysqli_query($db, "UPDATE `users` SET `team_id` = '$club_id' WHERE `id` = '$user_id'");

                echo "<div class='msg success'>Всё готово! Конфигурация сохранена в <b>$config_file</b> с поддержкой кириллицы.</div>";
                echo "<a href='?finish=1' class='btn' style='display:block;text-align:center;text-decoration:none;'>УДАЛИТЬ ИНСТАЛЛЕР</a>";
            } else {
                echo "<div class='msg error'>Ошибка: " . mysqli_error($db) . "</div>";
            }
        }
    }
    elseif (isset($_POST['setup_db'])) {
        $host = $_POST['host']; $user = $_POST['user']; $pass = $_POST['pass']; $name = $_POST['name'];
        $db = @mysqli_connect($host, $user, $pass, $name);

        if (!$db) {
            echo "<div class='msg error'>Ошибка подключения: " . mysqli_connect_error() . "</div>";
        } else {
            // Импорт дампа
            $query = file_get_contents($sql_dump);
            if (mysqli_multi_query($db, $query)) {
                while (mysqli_more_results($db) && mysqli_next_result($db));
                
                // СОЗДАНИЕ system/db.php
                if (!is_dir('system')) mkdir('system', 0777, true);
                
                $db_code = "<?php\n"
                         . "// Автоматически созданный файл конфигурации\n"
                         . "\$db = mysqli_connect('$host', '$user', '$pass', '$name');\n\n"
                         . "if (!\$db) {\n"
                         . "    die('Ошибка подключения к БД: ' . mysqli_connect_error());\n"
                         . "}\n\n"
                         . "// Настройка для правильной работы кириллицы\n"
                         . "mysqli_set_charset(\$db, 'utf8mb4');\n"
                         . "mysqli_query(\$db, \"SET NAMES 'utf8mb4'\");\n"
                         . "mysqli_query(\$db, \"SET CHARACTER SET 'utf8mb4'\");\n"
                         . "?>";
                
                file_put_contents($config_file, $db_code);

                echo "<h3>Аккаунт администратора</h3>";
                ?>
                <form method="post">
                    <label>Логин</label><input type="text" name="adm_login" required>
                    <label>Пароль</label><input type="password" name="adm_pass" required>
                    <input type="hidden" name="setup_admin" value="1">
                    <button type="submit" class="btn">Создать админа</button>
                </form>
                <?php
            }
        }
    } else {
    ?>
        <form method="post">
            <label>MySQL Host</label><input type="text" name="host" value="localhost" required>
            <label>User</label><input type="text" name="user" required>
            <label>Password</label><input type="password" name="pass">
            <label>DB Name</label><input type="text" name="name" required>
            <input type="hidden" name="setup_db" value="1">
            <button type="submit" class="btn">Импортировать БД</button>
        </form>
    <?php } ?>
</div>

</body>
</html>
