<?php
require_once '../system/db.php';
include '../system/header.php';

// Проверка прав доступа
if (!isset($_SESSION['user_id']) || $_SESSION['level'] < 9) {
    die("<div style='color:red; padding:20px; text-align:center;'><h2>Доступ запрещен!</h2></div>");
}

// Сбор расширенной статистики для справки
$u_total = mysqli_fetch_assoc(mysqli_query($db, "SELECT COUNT(*) as c FROM users"))['c'];
$db_size_res = mysqli_query($db, "SELECT SUM(data_length + index_length) / 1024 / 1024 AS size FROM information_schema.TABLES WHERE table_schema = (SELECT DATABASE())");
$db_size = round(mysqli_fetch_assoc($db_size_res)['size'], 2);
?>

<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
    :root { --main: #2c3e50; --accent: #3498db; --bg: #f4f7f6; }
    body { background: var(--bg); font-family: -apple-system, sans-serif; }
    .doc-container { max-width: 800px; margin: 0 auto; padding: 15px; }
    .card { background: #fff; padding: 20px; border-radius: 12px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); margin-bottom: 20px; border-left: 5px solid var(--main); }
    .card h3 { margin-top: 0; color: var(--main); display: flex; align-items: center; gap: 8px; }
    code { background: #f0f0f0; padding: 2px 5px; border-radius: 4px; font-family: monospace; color: #c7254e; }
    pre { background: #272822; color: #f8f8f2; padding: 15px; border-radius: 8px; overflow-x: auto; font-size: 13px; line-height: 1.5; }
    .author-box { background: linear-gradient(135deg, #2c3e50, #4ca1af); color: #fff; padding: 20px; border-radius: 12px; text-align: center; }
    .badge { display: inline-block; padding: 3px 10px; background: var(--accent); color: #fff; border-radius: 20px; font-size: 11px; margin-bottom: 10px; }
    .method-list { list-style: none; padding: 0; }
    .method-list li { margin-bottom: 15px; padding-left: 10px; border-left: 2px solid #eee; }
</style>

<div class="doc-container">
    
    <div class="author-box">
        <span class="badge">ВЕРСИЯ ДВИЖКА: 1.0 (BETA)</span>
        <h2 style="margin:5px 0;">GreenCMS Core</h2>
        <p style="opacity: 0.9;">Первая версия игрового движка</p>
        <div style="font-size: 14px;">Автор: <b>mr.kikmret@mail.ru</b></div>
    </div>

    <div class="card" style="border-left-color: #27ae60;">
        <h3>🚀 Системный статус</h3>
        <table style="width:100%; font-size: 13px;">
            <tr><td>PHP: <b><?php echo PHP_VERSION; ?></b></td><td>База: <b><?php echo $db_size; ?> MB</b></td></tr>
            <tr><td>Юзеров: <b><?php echo $u_total; ?></b></td><td>Лимит памяти: <b><?php echo ini_get('memory_limit'); ?></b></td></tr>
        </table>
    </div>

    <div class="card">
        <h3>🛠 Глобальные функции (API)</h3>
        <p>Используйте эти функции в любом месте сайта для безопасности и удобства:</p>
        <ul class="method-list">
            <li>
                <code>clean($data)</code> — <b>Защита №1.</b> Очищает любую строку от кавычек и XSS-кода перед вставкой в базу.<br>
                <i>Пример:</i> <code>$name = clean($_POST['name']);</code>
            </li>
            <li>
                <code>$_SESSION['user_id']</code> — ID текущего игрока. Если пуст — юзер гость.<br>
            </li>
            <li>
                <code>$user_data['...']</code> — Весь массив данных игрока (баланс, уровень) доступен в <code>header.php</code>.
            </li>
        </ul>
    </div>

    <div class="card" style="border-left-color: #f39c12;">
        <h3>💻 Инструкция по модификации</h3>
        <p>Чтобы добавить новую страницу или функцию, следуйте правилам движка:</p>
        
        <b>А. Создание новой страницы:</b>
        <pre>
&lt;?php
require_once '../system/db.php';
include '../system/header.php';

// Твой код тут (например, логика игры)

include '../system/footer.php';
?&gt;</pre>

        <b>Б. Работа с балансом игрока:</b>
        <p>Чтобы выдать деньги (например, 500 монет):</p>
        <pre>
$id = $_SESSION['user_id'];
mysqli_query($db, "UPDATE users SET balans = balans + 500 WHERE id = '$id'");</pre>
    </div>

    <div class="card" style="border-left-color: #e74c3c;">
        <h3>⚠️ Правила безопасности</h3>
        <ol>
            <li>Никогда не вставляйте <code>$_POST</code> напрямую в запрос без <code>clean()</code>.</li>
            <li>Файлы в папке <code>admin/</code> всегда должны начинаться с проверки <code>$_SESSION['level'] >= 9</code>.</li>
            <li>Не удаляйте файл <code>system/db.php</code>, иначе сайт перестанет работать.</li>
        </ol>
    </div>

    <div class="card" style="border-left-color: #9b59b6;">
        <h3>🔮 Предстоящие обновления</h3>
        <p>В следующей версии (v1.1) планируется:</p>
        <ul>
            <li>Система автоматических бэкапов базы данных.</li>
            <li>Модуль внутриигрового рынка (Trade System).</li>
            <li>Логирование действий администрации.</li>
        </ul>
    </div>

    <div style="text-align: center; margin-top: 20px;">
        <a href="index.php" style="text-decoration: none; color: #7f8c8d;">← Назад в управление</a>
    </div>

</div>

<?php include '../system/footer.php'; ?>

