<?php
require_once '../system/db.php';
include '../system/header.php';

if (!isset($_SESSION['user_id']) || $_SESSION['level'] < 9) die("Доступ закрыт");

$root = $_SERVER['DOCUMENT_ROOT'];
$rel_path = isset($_GET['path']) ? trim($_GET['path'], '/') : '';
$current_dir = realpath($root . ($rel_path ? '/' . $rel_path : ''));
if (!$current_dir || strpos($current_dir, $root) !== 0) $current_dir = $root;

$msg = '';

// Сохранение файла
if (isset($_POST['save_file'])) {
    $target = $current_dir . '/' . $_POST['edit_filename'];
    if (file_put_contents($target, $_POST['content']) !== false) $msg = "✅ Сохранено";
}

// Удаление
if (isset($_GET['delete'])) {
    $item = $current_dir . '/' . $_GET['delete'];
    is_dir($item) ? null : unlink($item); // Упрощено для примера
    header("Location: files.php?path=" . urlencode($rel_path));
}

$items = scandir($current_dir);
?>

<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
<script src="https://cdnjs.cloudflare.com/ajax/libs/ace/1.4.12/ace.js"></script>

<style>
    :root { --bg: #f4f7f6; --card: #ffffff; --primary: #007aff; --danger: #ff3b30; --text: #1c1c1e; }
    body { background: var(--bg); color: var(--text); font-family: -apple-system, sans-serif; margin: 0; }
    
    .app-bar { background: var(--card); padding: 15px; display: flex; align-items: center; gap: 10px; border-bottom: 1px solid #ddd; position: sticky; top: 0; z-index: 100; }
    .path-bar { font-size: 13px; color: #8e8e93; padding: 10px 15px; overflow-x: auto; white-space: nowrap; background: #eee; }
    
    .file-list { padding: 0; margin: 0; list-style: none; }
    .file-item { background: var(--card); margin-bottom: 1px; padding: 12px 15px; display: flex; align-items: center; justify-content: space-between; }
    .file-info { display: flex; align-items: center; gap: 12px; text-decoration: none; color: inherit; flex-grow: 1; }
    .file-name { font-size: 15px; font-weight: 500; }
    .file-meta { font-size: 11px; color: #8e8e93; display: block; }
    
    .actions { display: flex; gap: 8px; }
    .btn-circle { width: 32px; height: 32px; border-radius: 50%; border: none; display: flex; align-items: center; justify-content: center; background: #f2f2f7; cursor: pointer; color: var(--text); font-size: 14px; text-decoration: none; }
    .btn-primary { background: var(--primary); color: #fff; }

    /* Редактор на весь экран */
    .editor-overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: var(--card); display: none; flex-direction: column; z-index: 1001; }
    #editor { flex-grow: 1; font-size: 14px; }
    .editor-tools { padding: 10px; display: flex; justify-content: space-between; border-bottom: 1px solid #ddd; }

    .fab { position: fixed; bottom: 20px; right: 20px; width: 56px; height: 56px; background: var(--primary); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: #fff; box-shadow: 0 4px 12px rgba(0,0,0,0.2); font-size: 24px; border: none; }
</style>

<div class="app-bar">
    <a href="index.php" class="btn-circle">←</a>
    <b style="font-size: 18px;">Файлы</b>
    <?php if($msg) echo "<small style='color:green;margin-left:auto;'>$msg</small>"; ?>
</div>

<div class="path-bar">
    /<?php echo $rel_path ?: 'root'; ?>
</div>

<div class="file-list">
    <?php foreach($items as $item): if($item == '.' || $item == '..') continue; 
        $path = $current_dir . '/' . $item;
        $is_dir = is_dir($path);
        $ext = pathinfo($item, PATHINFO_EXTENSION);
    ?>
    <div class="file-item">
        <a href="<?php echo $is_dir ? '?path='.urlencode(($rel_path ? $rel_path.'/' : '').$item) : 'javascript:void(0)'; ?>" 
           class="file-info" <?php if(!$is_dir) echo "onclick=\"editFile('$item')\""; ?>>
            <span style="font-size: 24px;"><?php echo $is_dir ? '📁' : '📄'; ?></span>
            <div>
                <span class="file-name"><?php echo $item; ?></span>
                <span class="file-meta"><?php echo $is_dir ? 'Папка' : round(filesize($path)/1024,1).'KB'; ?> • <?php echo substr(sprintf('%o', fileperms($path)), -3); ?></span>
            </div>
        </a>
        <div class="actions">
            <a href="?delete=<?php echo urlencode($item); ?>&path=<?php echo urlencode($rel_path); ?>" class="btn-circle" onclick="return confirm('Удалить?')">🗑</a>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<div id="editorOverlay" class="editor-overlay">
    <div class="editor-tools">
        <button onclick="closeEditor()" class="btn-circle">✕</button>
        <b id="editTitle" style="font-size: 14px;">Редактор</b>
        <button onclick="saveFile()" class="btn-circle btn-primary">💾</button>
    </div>
    <div id="editor"></div>
</div>

<form id="saveForm" method="post" style="display:none;">
    <input type="hidden" name="edit_filename" id="edit_filename">
    <textarea name="content" id="hiddenContent"></textarea>
    <input type="hidden" name="save_file" value="1">
</form>

<button class="fab" onclick="alert('Используйте браузерную загрузку или создайте папку через POST')">+</button>

<script>
    var editor = ace.edit("editor");
    editor.setTheme("ace/theme/chrome"); // Светлая тема лучше для мобилок днем
    editor.session.setUseWrapMode(true); // Перенос строк для узких экранов

    function editFile(name) {
        document.getElementById('edit_filename').value = name;
        document.getElementById('editTitle').innerText = name;
        fetch('?get_content=' + name + '&path=<?php echo urlencode($rel_path); ?>')
            .then(r => r.text())
            .then(data => {
                editor.setValue(data, -1);
                document.getElementById('editorOverlay').style.display = 'flex';
                editor.focus();
            });
    }

    function saveFile() {
        document.getElementById('hiddenContent').value = editor.getValue();
        document.getElementById('saveForm').submit();
    }

    function closeEditor() { document.getElementById('editorOverlay').style.display = 'none'; }
</script>

<?php
if (isset($_GET['get_content'])) {
    ob_clean();
    echo file_get_contents($current_dir . '/' . $_GET['get_content']);
    exit;
}
include '../system/footer.php';
?>

