<?php
require_once '../system/db.php';
include '../system/header.php';

if (!isset($_SESSION['user_id']) || $_SESSION['level'] < 9) die("Доступ закрыт");

$msg = '';
$table = isset($_GET['table']) ? clean($_GET['table']) : '';

// --- ОБРАБОТКА ДЕЙСТВИЙ ---

// 1. Создание таблицы
if (isset($_POST['create_table'])) {
    $t_name = clean($_POST['new_t_name']);
    $sql = "CREATE TABLE `$t_name` (id INT(11) AUTO_INCREMENT PRIMARY KEY) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    mysqli_query($db, $sql) ? ($msg = "✅ Таблица создана") : ($msg = "❌ " . mysqli_error($db));
}

// 2. Добавление столбца
if (isset($_POST['add_column'])) {
    $c_name = clean($_POST['col_name']);
    $c_type = clean($_POST['col_type']);
    mysqli_query($db, "ALTER TABLE `$table` ADD `$c_name` $c_type") ? ($msg = "✅ Столбец добавлен") : ($msg = "❌ " . mysqli_error($db));
}

// 3. Редактирование записи (Update)
if (isset($_POST['update_row'])) {
    $id = intval($_POST['row_id']);
    $updates = [];
    foreach ($_POST['fields'] as $col => $val) {
        $val = mysqli_real_escape_string($db, $val);
        $updates[] = "`$col` = '$val'";
    }
    $sql = "UPDATE `$table` SET " . implode(', ', $updates) . " WHERE id = $id";
    mysqli_query($db, $sql) ? ($msg = "✅ Запись обновлена") : ($msg = "❌ " . mysqli_error($db));
}

// Данные о версии и весе всей БД
$db_name_res = mysqli_query($db, "SELECT DATABASE()");
$db_name = mysqli_fetch_row($db_name_res)[0];
$db_size_res = mysqli_query($db, "SELECT SUM(data_length + index_length) / 1024 / 1024 AS size FROM information_schema.TABLES WHERE table_schema = '$db_name'");
$db_total_size = round(mysqli_fetch_assoc($db_size_res)['size'], 2);
$db_version = mysqli_get_server_info($db);
?>

<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
<style>
    :root { --bg: #f4f7f6; --card: #ffffff; --primary: #007aff; --text: #1c1c1e; }
    body { background: var(--bg); color: var(--text); font-family: -apple-system, sans-serif; margin: 0; }
    .card { background: var(--card); margin: 10px; padding: 15px; border-radius: 12px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
    .app-bar { background: var(--card); padding: 15px; display: flex; align-items: center; gap: 10px; border-bottom: 1px solid #ddd; position: sticky; top: 0; z-index: 100; }
    .btn-primary { background: var(--primary); color: #fff; padding: 8px 15px; border-radius: 6px; border: none; font-weight: 600; cursor: pointer; }
    .input-style { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 8px; box-sizing: border-box; margin-bottom: 10px; }
    
    /* Стили таблицы данных */
    .data-table { width: 100%; border-collapse: collapse; font-size: 11px; }
    .data-table td { padding: 10px; border-bottom: 1px solid #eee; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; max-width: 100px; }
    .data-table tr:active { background: #e5e5ea; }

    /* Модальное окно */
    .modal { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); display: none; z-index: 200; align-items: flex-end; }
    .modal-content { background: #fff; width: 100%; border-radius: 20px 20px 0 0; padding: 20px; max-height: 80%; overflow-y: auto; }
</style>

<div class="app-bar">
    <a href="<?php echo $table ? 'dbd.php' : 'index.php'; ?>" style="text-decoration:none;">⬅️</a>
    <b><?php echo $table ? "Таблица: $table" : "База данных"; ?></b>
</div>

<?php if($msg): ?><div class="card" style="background:#e1f5fe;"><?php echo $msg; ?></div><?php endif; ?>

<?php if(!$table): ?>
    <div class="card" style="background: linear-gradient(135deg, #1c1c1e, #3a3a3c); color: #fff;">
        <small>Информация о системе</small>
        <div style="display:flex; justify-content:space-between; margin-top:10px;">
            <span>📦 Вес БД: <b><?php echo $db_total_size; ?> MB</b></span>
            <span>💎 Версия: <b><?php echo $db_version; ?></b></span>
        </div>
    </div>

    <div class="card">
        <h3>➕ Создать таблицу</h3>
        <form method="post">
            <input type="text" name="new_t_name" class="input-style" placeholder="Имя таблицы" required>
            <button type="submit" name="create_table" class="btn-primary">Создать</button>
        </form>
    </div>

    <div class="card">
        <h3>Список таблиц</h3>
        <?php $res = mysqli_query($db, "SHOW TABLES"); while($row = mysqli_fetch_array($res)): ?>
            <a href="?table=<?php echo $row[0]; ?>" style="display:block; padding:12px; border-bottom:1px solid #eee; text-decoration:none; color:#000;">
                📁 <?php echo $row[0]; ?>
            </a>
        <?php endwhile; ?>
    </div>

<?php else: ?>
    <div class="card">
        <h3>➕ Добавить столбец в <?php echo $table; ?></h3>
        <form method="post" style="display:flex; gap:5px;">
            <input type="text" name="col_name" class="input-style" placeholder="Имя" required>
            <select name="col_type" class="input-style">
                <option value="INT(11)">INT</option>
                <option value="VARCHAR(255)">VARCHAR</option>
                <option value="TEXT">TEXT</option>
            </select>
            <button type="submit" name="add_column" class="btn-primary">OK</button>
        </form>
    </div>

    <div class="card" style="overflow-x: auto; padding:0;">
        <table class="data-table">
            <tr style="background:#f2f2f7;">
                <?php $cols = mysqli_query($db, "SHOW COLUMNS FROM `$table`"); 
                      $fields = []; while($c = mysqli_fetch_assoc($cols)) { $fields[] = $c['Field']; echo "<th>".$c['Field']."</th>"; } ?>
            </tr>
            <?php $data = mysqli_query($db, "SELECT * FROM `$table` ORDER BY 1 DESC LIMIT 30"); 
                  while($row = mysqli_fetch_assoc($data)): ?>
                <tr onclick='openEdit(<?php echo json_encode($row); ?>)'>
                    <?php foreach($fields as $f): ?>
                        <td><?php echo htmlspecialchars($row[$f]); ?></td>
                    <?php endforeach; ?>
                </tr>
            <?php endwhile; ?>
        </table>
    </div>
<?php endif; ?>

<div id="editModal" class="modal">
    <div class="modal-content">
        <h3 id="modalTitle">Редактирование</h3>
        <form method="post">
            <input type="hidden" name="row_id" id="row_id">
            <div id="modalFields"></div>
            <button type="submit" name="update_row" class="btn-primary" style="width:100%;">Сохранить изменения</button>
            <button type="button" onclick="closeModal()" class="btn-primary" style="width:100%; background:#8e8e93; margin-top:10px;">Отмена</button>
        </form>
    </div>
</div>

<script>
function openEdit(data) {
    const fieldsDiv = document.getElementById('modalFields');
    fieldsDiv.innerHTML = '';
    document.getElementById('row_id').value = data.id;
    
    for (let key in data) {
        if(key === 'id') continue;
        fieldsDiv.innerHTML += `<label style="font-size:12px; color:#666;">${key}</label>
                                <input type="text" name="fields[${key}]" value="${data[key]}" class="input-style">`;
    }
    document.getElementById('editModal').style.display = 'flex';
}
function closeModal() { document.getElementById('editModal').style.display = 'none'; }
</script>

<?php include '../system/footer.php'; ?>

