<?php

// ImmyCMS v0.01 — Финальный рабочий инсталлятор (2025 edition)
// Все ошибки: 1071, HY093 и прочие — УБИТЫ НАВСЕГДА

if (file_exists('../config.php')) {
    die('<h1 style="color:red;">ImmyCMS уже установлен!</h1><p>Удалите install.php вручную.</p>');
}

if (version_compare(PHP_VERSION, '8.0.0', '<')) {
    die('Требуется PHP 8.0+');
}

$required = ['pdo', 'pdo_mysql', 'mbstring', 'gd', 'json'];
foreach ($required as $ext) {
    if (!extension_loaded($ext)) die("Требуется расширение: <b>$ext</b>");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $db_host     = trim($_POST['db_host'] ?? '');
    $db_name     = trim($_POST['db_name'] ?? '');
    $db_user     = trim($_POST['db_user'] ?? '');
    $db_pass     = $_POST['db_pass'] ?? '';
    $admin_login = trim($_POST['admin_username'] ?? '');
    $admin_pass  = $_POST['admin_password'] ?? '';
    $admin_pass2 = $_POST['admin_password_confirm'] ?? '';

    $errors = [];

    if (empty($db_host) || empty($db_name) || empty($db_user) || empty($admin_login) || empty($admin_pass)) {
        $errors[] = 'Заполните все поля.';
    }
    if ($admin_pass !== $admin_pass2) {
        $errors[] = 'Пароли не совпадают.';
    }
    if (strlen($admin_pass) < 8) {
        $errors[] = 'Пароль минимум 8 символов.';
    }
    if (strlen($admin_login) < 3 || strlen($admin_login) > 50) {
        $errors[] = 'Логин: 3–50 символов.';
    }
    if (!filter_var($admin_login . '@immycms.local', FILTER_VALIDATE_EMAIL)) {
        if (!str_contains($admin_login, '@')) {
            // ок, будем использовать как основу email
        } else {
            $errors[] = 'Логин не должен содержать @';
        }
    }

    if ($errors) {
        echo '<div class="alert alert-danger"><ul><li>' . implode('</li><li>', $errors) . '</li></ul></div>';
        goto show_form;
    }

    try {
        $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]);

        $sql = file_get_contents('install.sql');
        if (!$sql) die('install.sql не найден или пустой.');

        $pdo->exec($sql);

        $hashed = password_hash($admin_pass, PASSWORD_DEFAULT);
        $admin_email = $admin_login . '@immycms.local'; // временный email

        $stmt = $pdo->prepare("INSERT INTO users (email, password_hash, name, role, created_at) VALUES (?, ?, ?, 3, NOW())");
        $stmt->execute([$admin_email, $hashed, $admin_login]);

        $config = <<<PHP
<?php
declare(strict_types=1);

return [
    'db' => [
        'dsn'  => 'mysql:host={$db_host};dbname={$db_name};charset=utf8mb4',
        'user' => '{$db_user}',
        'pass' => '{$db_pass}',
    ],
];
PHP;

        file_put_contents('../config.php', $config);

        echo '<div class="container mt-5"><h1 class="text-success">✓ ImmyCMS установлен!</h1>';
        echo '<div class="alert alert-success">
                <p><b>Администратор создан</b></p>
                <p>Логин: <b>' . htmlspecialchars($admin_login) . '</b><br>
                   Email (временный): <b>' . htmlspecialchars($admin_email) . '</b><br>
                   Пароль: тот, что ввели</p>
                <p><b>install.php удалится через 3 секунды...</b></p>
              </div></div>';

        echo '<script>setTimeout(() => location.href="../", 3000);</script>';

        register_shutdown_function(function () {
            @unlink(__FILE__);
        });

        exit;

    } catch (Exception $e) {
        die('<div class="alert alert-danger">Ошибка: ' . htmlspecialchars($e->getMessage()) . '</div>');
    }
}

show_form:
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>ImmyCMS → Установка</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>body{background:#f8f9fa}.container{max-width:600px;}</style>
</head>
<body>
<div class="container mt-5 p-5 bg-white rounded shadow">
    <h1 class="h3 mb-4 text-center">Установка ImmyCMS</h1>
    <form method="POST" novalidate>
        <h5>База данных</h5>
        <div class="mb-3"><input type="text" name="db_host" class="form-control" value="localhost" placeholder="Хост" required></div>
        <div class="mb-3"><input type="text" name="db_name" class="form-control" placeholder="Имя базы" required></div>
        <div class="mb-3"><input type="text" name="db_user" class="form-control" placeholder="Пользователь" required></div>
        <div class="mb-3"><input type="password" name="db_pass" class="form-control" placeholder="Пароль (можно пустой)"></div>

        <hr>
        <h5>Суперадминистратор</h5>
        <div class="mb-3"><input type="text" name="admin_username" class="form-control" placeholder="Логин (без @)" required></div>
        <div class="mb-3"><input type="password" name="admin_password" class="form-control" placeholder="Пароль (мин. 8 символов)" required></div>
        <div class="mb-3"><input type="password" name="admin_password_confirm" class="form-control" placeholder="Повторите пароль" required></div>

        <button type="submit" class="btn btn-success btn-lg w-100">Установить сейчас</button>
    </form>
    <small class="text-muted d-block text-center mt-3">install.php удалится автоматически после установки</small>
</div>
</body>
</html>