const pixelSize = 32;
const pixelCountX = 32;
const pixelCountY = 32;
const worldWidth = pixelCountX * pixelSize;
const worldHeight = pixelCountY * pixelSize;

const worldConfig = {
	type: Phaser.AUTO,
	width: window.innerWidth,
	height: window.innerHeight,
	scene: {
		preload,
		create,
		update,
	}
};

new Phaser.Game(worldConfig);

let player;
let npc;
let coordinate;
let camera;
let targetX;
let targetY;
let deltaX;
let deltaY;

let arrows = {
	
};

function preload() {
	this.load.image('cobblestone', '/png/cobblestone.png');
	this.load.image('npc', '/png/npc.png');
	this.load.image('sandy', '/png/sandy.png');
	this.load.image('wasteland', '/png/wasteland.png');
}

function create() {
	
	for (let randomObjectX = 0; randomObjectX < pixelCountX; randomObjectX++) {
		for (let randomObjectY = 0; randomObjectY < pixelCountY; randomObjectY++) {
			if (randomObjectX === 0 || randomObjectY === 0 || randomObjectX === pixelCountX - 1 || randomObjectY === pixelCountY - 1) {
				this.add.image(randomObjectX * pixelSize, randomObjectY * pixelSize, 'cobblestone').setOrigin(0);
			} else {
				this.add.image(randomObjectX * pixelSize, randomObjectY * pixelSize, randomInt(2) == 0 ? 'sandy' : 'wasteland').setOrigin(0);
			}
		}
	}
	
	player = this.add.image(pixelSize * 4, pixelSize * 4, 'npc').setOrigin(0);
	npc = this.add.image(pixelSize * 8, pixelSize * 3, 'npc').setOrigin(0);
	
	coordinate = this.add.text(pixelSize, pixelSize, '', setFontStyle('#FFFFFF')).setScrollFactor(0);
	
	camera = this.cameras.main;
	camera.setBounds(0, 0, worldWidth, worldHeight);
	camera.startFollow(player);
	
	this.input.on('pointerdown', pointer => {
		
		targetX = Math.floor(pointer.worldX / pixelSize) * pixelSize;
		targetY = Math.floor(pointer.worldY / pixelSize) * pixelSize;
		
		targetX = Phaser.Math.Clamp(targetX, 0, worldWidth - pixelSize);
		targetY = Phaser.Math.Clamp(targetY, 0, worldHeight - pixelSize);
		
		deltaX = Math.abs(targetX - player.x);
		deltaY = Math.abs(targetY - player.y);
		
		if ((deltaX === pixelSize && deltaY === 0) || (deltaX === 0 && deltaY === pixelSize)) {
			player.x = targetX;
			player.y = targetY;
		}
		
		arrows.up.setPosition(player.x, player.y - pixelSize);
		arrows.down.setPosition(player.x, player.y + pixelSize);
		arrows.left.setPosition(player.x - pixelSize, player.y);
		arrows.right.setPosition(player.x + pixelSize, player.y);
		
		const position = positionCalc();
		
		if (position.x === 8 && position.y === 3) {
			alert('Привет, путник! Рад видеть нового лица в наших краях. Я тут, на своей ферме, уже много лет. Жизнь нелегка, но земля всегда вознаграждает труд. Если захочешь помочь, у меня как раз есть несколько дел: заготовить сено или покопать грядки. В ответ я тебя угощу свежими овощами. Ну а если ты просто в поисках отдыха — присаживайся, отдохни у костра. Тут всегда рады гостям!');
		}
	});
	
	arrows.up = this.add.image(player.x, player.y - pixelSize, 'cobblestone').setOrigin(0).setAlpha(0.5);
	arrows.down = this.add.image(player.x, player.y + pixelSize, 'cobblestone').setOrigin(0).setAlpha(0.5);
	arrows.left = this.add.image(player.x - pixelSize, player.y, 'cobblestone').setOrigin(0).setAlpha(0.5);
	arrows.right = this.add.image(player.x + pixelSize, player.y, 'cobblestone').setOrigin(0).setAlpha(0.5);
}

function positionCalc() {
	return {
		x: Math.floor(player.x / pixelSize),
		y: Math.floor(player.y / pixelSize),
	};
}

function update() {
	const position = positionCalc();
	coordinate.setText(`X : ${position.x} Y : ${position.y}`);
}

function randomInt(count) {
	return Math.floor(Math.random() * count);
}

function setFontStyle(color) {
	return {
		font: '16px Arial',
		fill: color,
		fontWeight: 'bold'
	};
}

let start;

if (!start) {
	alert("Управление очень простое: возле персонажа есть маленькие квадратики (не стал искать текстуры стрелочек :)), нажимаешь на них — и гуляешь по карте.");
	start = true;
}