<?php
require 'includes/config.php';
require 'includes/auth_functions.php';
require 'includes/daily_challenge.php';

// Логгирование всех ошибок
ini_set('log_errors', 1);
ini_set('error_log', '/home/f1119954/chalday_errors.log');

// Проверка авторизации
redirectIfNotLoggedIn();

// Получаем данные пользователя и челлендж
$user = getUserById($_SESSION['user_id']);
$dailyChallenge = getDailyChallenge($_SESSION['user_id']);
$pageTitle = 'Главная';
$showFooterNav = true;

// Проверяем активный челлендж
$hasActiveChallenge = ($user['challenge_started'] ?? false) && 
                     (strtotime($user['challenge_started_at'] ?? '') > strtotime('-10 hours');
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Challenge Day - <?= htmlspecialchars($pageTitle) ?></title>
    <link rel="stylesheet" href="<?= SITE_URL ?>/assets/css/main.css">
    <link rel="stylesheet" href="<?= SITE_URL ?>/assets/css/index.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        /* Все стили из предыдущей версии */
        .progress-container { width: 100%; background: #f3f3f3; border-radius: 5px; margin: 15px 0; }
        .progress-bar { height: 10px; background: #4CAF50; border-radius: 5px; width: <?= ($user['today_progress'] / 5) * 100 ?>%; transition: width 0.5s; }
        .challenge-actions { display: flex; align-items: center; gap: 15px; margin-top: 20px; flex-wrap: wrap; }
        .timer-container { display: flex; align-items: center; gap: 8px; font-size: 16px; padding: 8px 12px; background: #f8f9fa; border-radius: 5px; }
        .timer { font-family: monospace; font-size: 18px; font-weight: bold; color: #e74c3c; }
        .complete-button { background-color: #2ecc71; border: none; margin-left: auto; display: flex; align-items: center; }
        .complete-button:hover { background-color: #27ae60; }
    </style>
</head>
<body>
    <?php require 'includes/header.php'; ?>

    <div class="page-content">
        <!-- Ежедневный челлендж -->
        <section class="daily-challenge-card">
            <!-- Остальное содержимое без изменений -->
        </section>

        <!-- Баннер акций -->
        <section class="promo-banner">
            <h3 class="banner-title">Специальное предложение!</h3>
            <p class="banner-text">Получите двойные награды весь день</p>
            <a href="<?= SITE_URL ?>/top.php" class="banner-link">Топ рейтинг →</a>
        </section>
    </div>

    <?php require 'includes/footer.php'; ?>

    <script>
        // Весь JavaScript код из предыдущей версии
        const TEN_HOURS_MS = 10 * 60 * 60 * 1000;
        let challengeTimer;
        
        // Элементы интерфейса
        const startBtn = document.getElementById('startChallenge');
        const completeBtn = document.getElementById('completeChallenge');
        const timerContainer = document.getElementById('timerContainer');
        const challengeTimerEl = document.getElementById('challengeTimer');
        
        // Функции startChallenge, updateTimer, resetChallengeUI, completeChallenge
        // ... (оставить без изменений из предыдущего кода)
        
        // Обработчики событий
        startBtn.addEventListener('click', startChallenge);
        completeBtn.addEventListener('click', completeChallenge);
        
        // Проверка активного челленджа при загрузке
        <?php if ($hasActiveChallenge): ?>
            document.addEventListener('DOMContentLoaded', function() {
                const startTime = new Date('<?= $user['challenge_started_at'] ?>').getTime();
                const endTime = startTime + TEN_HOURS_MS;
                const now = new Date().getTime();
                
                if (now < endTime) {
                    startChallenge();
                    updateTimer(endTime);
                }
            });
        <?php endif; ?>
        
        // Остальные функции (updateProgress, обработчик buyBoost)
        // ... (оставить без изменений)
    </script>
</body>
</html>