<?

/**
 * MobileAppApi
 * Класс для ответов клиентскому приложние
 */

class MobileAppApi {
	public static $errors = array(
		1 => 'Ошибка авторизации', 
		2 => 'Поступили не все параметры'
	);
	protected $nick, 
			  $password, 
			  $token, 
			  $id, 
			  $user, 
			  $events_count = array();

	public function __construct() {}

	/**
	 * Указание ника пользователя
	 * @param string $nick Ник пользователя
	 * @return $this
	 */

	public function setNick($nick) {
		$this -> nick = my_esc($nick);
		return $this;
	}

	/**
	 * Указание пароля пользователя
	 * @param string $password Пароль пользователя
	 * @return $this
	 */

	public function setPassword($password) {
		$this -> password = my_esc($password);
		return $this;
	}

	/**
	 * Указание токена пользователя
	 * @param string $token Токен пользователя
	 * @return $this
	 */

	public function setToken($token) {
		$this -> token = my_esc($token);
		return $this;
	}

	/**
	 * Указание токена пользователя
	 * @param string $token Токен пользователя
	 * @return $this
	 */

	public function setID($id) {
		$this -> id = intval($id);
		return $this;
	}

	/**
	 * Проверка данных авторизации пользователя
	 * @return boolean
	 */

	public function checkUser() {
		$this -> user = mysql_fetch_assoc(mysql_query("SELECT * FROM `user` WHERE `nick` = '{$this -> nick}' AND `pass` = '" . $this -> getCryptedPassword() . "'"));
		return @$this -> user['id'] != 0;
	}

	/**
	 * Проверка токена и ID
	 * @return boolean
	 */

	public function checkTokenAndID() {
		$this -> user = mysql_fetch_assoc(mysql_query("SELECT * FROM `user` WHERE `mobile_app_token` = '{$this -> token}' AND `id` = '{$this -> id}'"));
		return @$this -> user['id'] != 0;
	}

	/**
	 * Возвращает зашифрованный пароль
	 * @return string
	 */

	public function getCryptedPassword() {
		include_once(H . 'sys/inc/shif.php');
		return shif($this -> password);
	}

	/**
	 * Возвращает токен
	 * @return string
	 */

	public function getToken() {
		include_once(H . 'sys/inc/shif.php');

		// если токен ещё пуст
		if (!$this -> user['mobile_app_token'])
			$this -> generateToken();

		return $this -> user['mobile_app_token'];
	}

	/**
	 * Генерирует токен
	 * @return $this
	 */

	public function generateToken() {
		$user = $this -> user;
		include_once(H . 'sys/inc/shif.php');
		$token = shif($this -> user['password'] . $this -> user['nick'] . 'mobile_app_token' . microtime(true));
		mysql_query("UPDATE `user` SET `mobile_app_token` = '$token' WHERE `id` = '$user[id]'");
		$this -> user = get_user($user['id']);
		return $this;
	}

	/**
	 * Возвращает массив новых событий
	 * @return array
	 */

	public function getEventsCount() {
		$user = $this -> user;
		if (empty($this -> events_count))
			$this -> events_count = array(
				'mail' => mysql_result(mysql_query("SELECT COUNT(`mail`.`id`) FROM `mail` LEFT JOIN `users_konts` ON `mail`.`id_user` = `users_konts`.`id_kont` AND `users_konts`.`id_user` = '$user[id]' WHERE `mail`.`id_kont` = '$user[id]' AND (`users_konts`.`type` IS NULL OR `users_konts`.`type` = 'common' OR `users_konts`.`type` = 'favorite') AND `mail`.`read` = '0'"), 0), 
				'discussions' => mysql_result(mysql_query("SELECT COUNT(`count`) FROM `discussions` WHERE `id_user` = '$user[id]' AND `count` > '0' "), 0), 
				'notification' => mysql_result(mysql_query("SELECT COUNT(`read`) FROM `notification` WHERE `id_user` = '$user[id]' AND `read` = '0'"), 0), 
				'tape' => mysql_result(mysql_query("SELECT COUNT(`read`) FROM `tape` WHERE `id_user` = '$user[id]' AND `read` = '0' "), 0), 
				'friends' => mysql_result(mysql_query("SELECT COUNT(id) FROM `frends_new` WHERE `to` = '$user[id]'"), 0), 
				'guests' => mysql_result(mysql_query("SELECT COUNT(*) FROM `my_guests` WHERE `id_ank` = '$user[id]' AND `read` = '1'"), 0)
			);
		return $this -> events_count;
	}

	/**
	 * Возвращает контент новых событий
	 * @return array
	 */

	public function getEventsContent() {
		$user = $this -> user;
		$events_count = $this -> getEventsCount();

		$events_content = array(
			'mail' => array(), 
			'friends' => array(), 
			'guests' => array()
		);

		if ($events_count['mail'] > 0) {
			$messages = mysql_query("SELECT `mail`.*, COUNT(`mail`.`id`) AS `count` FROM `mail` LEFT JOIN `users_konts` ON `mail`.`id_user` = `users_konts`.`id_kont` AND `users_konts`.`id_user` = '$user[id]' WHERE `mail`.`id_kont` = '$user[id]' AND (`users_konts`.`type` IS NULL OR `users_konts`.`type` = 'common' OR `users_konts`.`type` = 'favorite') AND `mail`.`read` = '0' AND `mail`.`id` = (SELECT `id` FROM `mail` AS `mail_new` WHERE `mail_new`.`id_user` = `mail`.`id_user` AND `mail_new`.`id_kont` = '$user[id]' ORDER BY `mail_new`.`time` DESC LIMIT 1) GROUP BY `mail`.`id_user` ORDER BY `mail`.`time` ASC, `count` ASC");
			while ($message = mysql_fetch_assoc($messages)) {
				$message_user = self::getUser($message['id_user']);

				$events_content['mail'][] = array(
					'id' => $message['id'], 
					'user' => $message_user, 
					'message' => $message['msg'], 
					'time' => vremja($message['time'])
				);
			}
		}

		if ($events_count['friends'] > 0) {
			$new_friends = mysql_query("SELECT * FROM `frends_new` WHERE `to` = $user[id] ORDER BY `time`");
			while ($new_friend = mysql_fetch_assoc($new_friends)) {
				$friend_user = self::getUser($new_friend['user']);

				$events_content['friends'][] = array(
					'id' => $new_friend['id'], 
					'user' => $friend_user, 
					'time' => vremja($new_friend['time'])
				);
			}
		}

		if ($events_count['guests'] > 0) {
			$new_guests = mysql_query("SELECT * FROM `my_guests` WHERE `id_ank` = '$user[id]' AND `read` = '1' ORDER BY `time` DESC");
			while ($new_guest = mysql_fetch_assoc($new_guests)) {
				$guest_user = self::getUser($new_guest['id_user']);

				$events_content['guests'][] = array(
					'id' => $new_guest['id'], 
					'user' => $guest_user, 
					'time' => vremja($new_guest['time'])
				);
			}
		}

		return $events_content;
	}

	/**
	 * Возвращает массив с данными пользователя
	 * @param $user_id ID пользователя
	 * @return array
	 */

	public static function getUser($user_id) {
		$user = get_user($user_id);

		return array(
			'id' => $user['id'], 
			'nick' => $user['nick'], 
			'avatar' => self::getAvatar($user['id'])
		);
	}

	/**
	 * Возвращает массив с данными текущего пользователя
	 * @return array
	 */

	public function getCurrentUser() {
		return self::getUser($this -> user['id']);
	}

	/**
	 * Возвращает ссылку на аватар пользователя
	 * @param $user_id ID пользователя
	 * @return array
	 */

	public static function getAvatar($user_id) {
		$user_id = intval($user_id);
		$result = array('exists' => false);

		$sql_query = mysql_query("SELECT * FROM `gallery_foto` WHERE `id_user` = $user_id AND `avatar` = '1' LIMIT 1");
		if (mysql_num_rows($sql_query)) {
			$avatar = mysql_fetch_array($sql_query);
			if (is_file(H . "sys/gallery/48/$avatar[id].$avatar[ras]")) {
				$result['exists'] = true;
				$result['id'] = $avatar['id'];
				$result['extension'] = $avatar['ras'];
			}
		}

		return $result;
	}
}
?>