<?php
$step = 3;
if($_SERVER['HTTP_ACCEPT_ENCODING']) $compress = strtolower($_SERVER['HTTP_ACCEPT_ENCODING']);
else $compress = strtolower($_SERVER['HTTP_TE']);

if(substr_count($compress,'deflate')){
	function compress_output_deflate($output){
		global $step;
		return gzdeflate($output, $step);
	}

	$method = 'deflate';
	header('Content-Encoding: deflate');
	ob_start('compress_output_deflate');
	ob_implicit_flush(0);
}
else if(substr_count($compress,'gzip')){
	function compress_output_gzip($output){
		global $step;
		return gzencode($output, $step);
	}

	$method = 'gzip';
	header('Content-Encoding: gzip');
	ob_start('compress_output_gzip');
	ob_implicit_flush(0);
}
else if(substr_count($compress,'x-gzip')){
	function compress_output_x_gzip($output){
		global $step;
		$size = strlen($output);
		$crc = crc32($output);
		$output = gzcompress($output, $step);
		$output = substr($output, 0, strlen($output) - 4);
		return "\x1f\x8b\x08\x00\x00\x00\x00\x00".$output.pack('V',$crc).pack('V',$size);
	}

	$method = 'x-gzip';
	header('Content-Encoding: x-gzip');
	ob_start('compress_output_x_gzip');
	ob_implicit_flush(0);
}

// Функция определения процента сжатия
function info_compress(){
	global $method, $step;
	$contents = ob_get_contents();
	$in = strlen($contents);
	switch($method){
		case 'deflate':
			$out = strlen(gzdeflate($contents, $step));
			return floor(100-(100/($in/$out)));
		break;
		case 'gzip':
			$out = strlen(gzencode($contents, $step));
			return floor(100-(100/($in/$out)));
		break;
		case 'x-gzip':
			$out = strlen(gzcompress($contents, $step));
			return floor(100-(100/($in/$out)));
		break;
	}
}
?>