<?
/*
* Функция времени
*/

function vremja($time = NULL) {
    global $user;

    if ($time == NULL) {
        $time = time();
    } elseif (isset($user)) {
        $time = $time + $user['set_timesdvig'] * 60 * 60;
    }

    $timep = date("j M Y в H:i", $time);
    $time_p[0] = date("j n Y", $time);
    $time_p[1] = date("H:i", $time);

    if ($time_p[0] == date("j n Y")) {
        $timep = date("H:i:s", $time);
    }

    if (isset($user)) {
        if ($time_p[0] == date("j n Y", time() + $user['set_timesdvig'] * 60 * 60)) {
            $timep = date("H:i:s", $time);
        } elseif ($time_p[0] == date("j n Y", time() - 60 * 60 * (24 - $user['set_timesdvig']))) {
            $timep = "Вчера в $time_p[1]";
        }
    } else {
        if ($time_p[0] == date("j n Y")) {
            $timep = date("H:i:s", $time);
        } elseif ($time_p[0] == date("j n Y", time() - 60 * 60 * 24)) {
            $timep = "Вчера в $time_p[1]";
        }
    }

    $timep = str_replace("Jan", "Янв", $timep);
    $timep = str_replace("Feb", "Фев", $timep);
    $timep = str_replace("Mar", "Марта", $timep);
    $timep = str_replace("May", "Мая", $timep);
    $timep = str_replace("Apr", "Апр", $timep);
    $timep = str_replace("Jun", "Июня", $timep);
    $timep = str_replace("Jul", "Июля", $timep);
    $timep = str_replace("Aug", "Авг", $timep);
    $timep = str_replace("Sep", "Сент", $timep);
    $timep = str_replace("Oct", "Окт", $timep);
    $timep = str_replace("Nov", "Ноября", $timep);
    $timep = str_replace("Dec", "Дек", $timep);
    return $timep;
}

/**
* Конверт месяца
*/
function str_m($time = NULL) {
  $str = date("M", $time);
  
  $str = str_replace("Jan", "Январь", $str);
  $str = str_replace("Feb", "Февраль", $str);
  $str = str_replace("Mar", "Март", $str);
  $str = str_replace("May", "Май", $str);
  $str = str_replace("Apr", "Апрель", $str);
  $str = str_replace("Jun", "Июнь", $str);
  $str = str_replace("Jul", "Июль", $str);
  $str = str_replace("Aug", "Август", $str);
  $str = str_replace("Sep", "Сентябрь", $str);
  $str = str_replace("Oct", "Октябрь", $str);
  $str = str_replace("Nov", "Ноябрь", $str);
  $str = str_replace("Dec", "Декабрь", $str);
  return $str;
}

/**
* Постраничная навигация
*/

// Выдает текущую страницу
function page($k_page=1)
{ 
	$page = 1;

	if (isset($_GET['page']))
	{
		if ($_GET['page'] == 'end')
			$page = intval($k_page);
			
		elseif(is_numeric($_GET['page'])) 
		$page = intval($_GET['page']);
	}

	if ($page < 1)$page = 1;

	if ($page > $k_page)
		$page = $k_page;
		
	return $page;
}

// Высчитывает количество страниц
function k_page($k_post = 0, $k_p_str = 10)
{ 
	if ($k_post != 0) 
	{
		$v_pages = ceil($k_post / $k_p_str);
		return $v_pages;
	}

	else return 1;
}

// Вывод номеров страниц (только на первый взгляд кажется сложно ;))
function str($link = '?', $k_page = 1,$page = 1)
{ 
	if ($page < 1)
		$page = 1;

	?><div class="pagination pagination-centered  pagination-small"><ul><?

	if ($page != 1)
		echo '<li><a href="' . $link . 'page=1" title="Первая страница">&lt;</a></li> ';

	if ($page != 1)
		echo '<li><a href="' . $link . 'page=1" title="Страница №1">1</a></li>';
	else 
		echo ' <li class="disabled"><a href="#"><b>1</b></a></li>';

	for ($ot = -1; $ot <= 1; $ot++)
	{
		if ($page + $ot > 1 && $page + $ot < $k_page)
		{
			if ($ot == -2 && $page + $ot > 2) {
        //echo '<li><a>..</a></li>';
      }
				

			if ($ot != 0)
				echo ' <li><a href="' . $link . 'page=' . ($page + $ot) . '" title="Страница №' . ($page + $ot) . '">' . ($page + $ot) . '</a></li>';
			else 
				echo ' <li class="disabled"><a href="#"><b>' . ($page + $ot) . '</b></a></li>';

			if ($ot == 2 && $page + $ot < $k_page - 1) {
        //echo '<li><a>..</a></li>';
      }
				
		}
	}

	if ($page != $k_page)
		echo ' <li><a href="' . $link . 'page=end" title="Страница №' . $k_page . '">' . $k_page . '</a></li>';
	
	elseif ($k_page > 1)
		echo ' <li class="disabled"><a href="#"><b>' . $k_page . '</b></a></li>';
		
	if ($page != $k_page)
		echo ' <li><a href="' . $link . 'page=end" title="Последняя страница">&gt;</a></li>';

	?></ul></div><?
}

/**
* Сохранение настроек
*/

function save_dat($settings, $ini)
{
  if ($fopen = @fopen(INI . $ini . '.dat', 'w')) {
    @fputs($fopen, serialize($settings));
    @fclose($fopen);
    @chmod(INI . $ini . '.dat', 0777);
    return true;
  } else {
    return false;
  }
}


/**
* Cкачивание файлов
*/

function DownloadFile($filename, $name, $mimetype = 'application/octet-stream')
{
  if (!file_exists($filename)) {
    die('Файл не найден');
  }
  
  @ob_end_clean();
  $from = 0;
  $size = filesize($filename);
  $to = $size;
  
  if (isset($_SERVER['HTTP_RANGE'])) {
    if (preg_match ('#bytes=-([0-9]*)#i',$_SERVER['HTTP_RANGE'], $range)) {
      $from = $size-$range[1];
      $to = $size;
    }  elseif(preg_match('#bytes=([0-9]*)-#i',$_SERVER['HTTP_RANGE'], $range)) {
      $from = $range[1];
      $to = $size;
    } elseif(preg_match('#bytes=([0-9]*)-([0-9]*)#i',$_SERVER['HTTP_RANGE'], $range)) {
      $from = $range[1];
      $to = $range[2];
    }
    header('HTTP/1.1 206 Partial Content');
    $cr = 'Content-Range: bytes '.$from .'-'.$to.'/'.$size;
  }
  else
  header('HTTP/1.1 200 Ok');
  $etag = md5($filename);
  $etag = substr($etag, 0, 8) . '-' . substr($etag, 8, 7) . '-' . substr($etag, 15, 8);
  header('ETag: "' . $etag . '"');
  header('Accept-Ranges: bytes');
  header('Content-Length: ' . ($to-$from));
  if (isset($cr))header($cr);
  header('Connection: close');
  header('Content-Type: ' . $mimetype);
  header('Last-Modified: ' . gmdate('r', filemtime($filename)));
  header("Last-Modified: " . gmdate("D, d M Y H:i:s", filemtime($filename)) . " GMT");
  header("Expires: " . gmdate("D, d M Y H:i:s", time() + 3600) . " GMT");
  $f = fopen($filename, 'rb');


  if (preg_match('#^image/#i', $mimetype))
  header('Content-Disposition: filename="4i4i.Ru_' . $name . '";');
  else
  header('Content-Disposition: attachment; filename="4i4i.Ru_' . $name . '";');

  fseek($f, $from, SEEK_SET);
  $size = $to;
  $downloaded = 0;
  while(!feof($f) and !connection_status() and ($downloaded<$size))
  {
    $block = min(1024 * 8, $size - $downloaded);
    echo fread($f, $block);
    $downloaded += $block;
    flush();
  }
  fclose($f);
}

/**
*  Размер файла
*/

function size_file($filesize=0)
{
$filesize_ed='B';
if ($filesize>=1024){$filesize= round($filesize/1024 , 2);$filesize_ed='KB';}
if ($filesize>=1024){$filesize= round($filesize/1024 , 2);$filesize_ed='MB';}
if ($filesize>=1024){$filesize= round($filesize/1024 , 2);$filesize_ed='GB';}
if ($filesize>=1024){$filesize= round($filesize/1024 , 2);$filesize_ed='TB';}
return $filesize.$filesize_ed;
}

?>