<?php
$Path_Folder = "/var/www/magazin/data/wmsigner/"; // Путь к директории, в которой лежит .kwm
$Path_Signer = "/var/www/magazin/data/wmsigner/wmsigner"; // Путь к WMSigner
$Global_WMID = "383701637577";
$Path_Certs = "/var/www/magazin/data/wmsigner/WMunited.cer";

// URL интерфейсов
$XML_addr[1]="https://w3s.webmoney.ru/asp/XMLInvoice.asp";
$XML_addr[2]="https://w3s.webmoney.ru/asp/XMLTrans.asp";
$XML_addr[3]="https://w3s.webmoney.ru/asp/XMLOperations.asp";
$XML_addr[4]="https://w3s.webmoney.ru/asp/XMLOutInvoices.asp";
$XML_addr[5]="https://w3s.webmoney.ru/asp/XMLFinishProtect.asp";
$XML_addr[6]="https://w3s.webmoney.ru/asp/XMLSendMsg.asp";
$XML_addr[7]="https://w3s.webmoney.ru/asp/XMLClassicAuth.asp";
$XML_addr[8]="https://w3s.webmoney.ru/asp/XMLFindWMPurseNew.asp";
$XML_addr[9]="https://w3s.webmoney.ru/asp/XMLPurses.asp";
$XML_addr[10]="https://w3s.webmoney.ru/asp/XMLInInvoices.asp";
$XML_addr[11]="https://apipassport.webmoney.ru/asp/XMLGetWMPassport.asp";
$XML_addr[13]="https://w3s.webmoney.ru/asp/XMLRejectProtect.asp";
$XML_addr[14]="https://w3s.webmoney.ru/asp/XMLTransMoneyback.asp";
$XML_addr[151]="https://w3s.webmoney.ru/asp/XMLTrustList.asp";
$XML_addr[152]="https://w3s.webmoney.ru/asp/XMLTrustList2.asp";
$XML_addr[153]="https://w3s.webmoney.ru/asp/XMLTrustSave2.asp";
$XML_addr[16]="https://w3s.webmoney.ru/asp/XMLCreatePurse.asp";
$XML_addr[171]="https://arbitrage.webmoney.ru/xml/X17_CreateContract.aspx";
$XML_addr[172]="https://arbitrage.webmoney.ru/xml/X17_GetContractInfo.aspx";
$XML_addr[18]="https://merchant.webmoney.ru/conf/xml/XMLTransGet.asp";
$XML_addr[19]="https://apipassport.webmoney.ru/XMLCheckUser.aspx";
$XML_addr[201]="https://merchant.webmoney.ru/conf/xml/XMLTransRequest.asp";
$XML_addr[202]="https://merchant.webmoney.ru/conf/xml/XMLTransConfirm.asp";
$XML_addr[211]="https://merchant.webmoney.ru/conf/xml/XMLTrustRequest.asp";
$XML_addr[212]="https://merchant.webmoney.ru/conf/xml/XMLTrustConfirm.asp";
$XML_addr[22]="https://merchant.webmoney.ru/conf/xml/XMLTransSave.asp";


// ФУНКЦИЯ ФОРМИРУЕТ УНИКАЛЬНЫЙ УВЕЛИЧИВАЮЩИЙСЯ REQN
function _GetReqn(){
    $time=microtime();
    $int=substr($time,11);
    $flo=substr($time,2,5);
    return $int.$flo;
};


// ФУНКЦИЯ ФОРМИРОВАНИЯ ПОДПИСИ
// На входе: строка для подписи. На выходе: строка с результатом подписывания
function _GetSign($inStr) { 
	global $Path_Folder, $Path_Signer;
	chdir($Path_Folder);
	$descriptorspec = array(
	0 => array("pipe", "r"),
	1 => array("pipe", "w"),
	2 => array("pipe", "r") );
	$process = proc_open($Path_Signer, $descriptorspec, $pipes);
	fwrite($pipes[0], "$inStr\004\r\n");
	fclose($pipes[0]);
	$s = fgets($pipes[1], 133);
	fclose($pipes[1]);
	$return_value = proc_close($process);
	return $s;
}


// АЛЬТЕРНАТИВНАЯ ФУНКЦИЯ ПОДПИСИ ДЛЯ PHP НИЖЕ 4.3.0
// На входе: строка для подписи. На выходе: строка с результатом подписывания
function _GetSign2($inStr){
	global $Path_Folder, $Path_Signer;
	chdir($Path_Folder);
	$PlanStr = "$inStr\004\r\n";
	$fp = popen($Path_Signer, "r+");
	fwrite($fp,$PlanStr);
	$s = fgets($fp, 133);
	pclose($fp);
	return $s;
}


// ОТПРАВКА POST-ЗАПРОСА ЧЕРЕЗ CURL
// На входе: URL для отправки и содержимое XML-запроса. На выходе: XML-ответ от WebMoney
function _GetAnswer($address, $xml){
	global $Path_Certs;
	// Инициализируем сеанс CURL
	$ch = curl_init($address);
	// В выводе CURL http-заголовки не нужны
	curl_setopt($ch, CURLOPT_HEADER, 0);
	// Возвращать результат, а не выводить его в браузер
	curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
	// Метод http-запроса - POST
	curl_setopt($ch, CURLOPT_POST,1);
	// Что передаем?
	curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
	// Проверяем корневой сертификат сервера WebMoney
	curl_setopt($ch, CURLOPT_CAINFO, $Path_Certs);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE);
	// Выполняем запрос, ответ помещаем в переменную $result;
	$result=curl_exec($ch);
	// Раскомментировать следующую строку, чтобы посмотреть ошибки выполнения curl запроса
	//	if(curl_errno($ch)) echo "Curl Error number='".curl_errno($ch)."' err desc='".curl_error($ch)."' \n"; 
	return $result;
}


// ИНТЕРФЕЙС X11. ПОЛУЧЕНИЕ ИНФОРМАЦИИ ИЗ АТТЕСТАТА.
// На выходе: массив ['att'=>код аттестата, 'recalled'=>флаг отзыва аттестата, 'retval'=>код выполнения, 'retdesc'=>описание результата, 'wmids'=>список прикрепленных к аттестату WMID]
function _WMXML11 ($wmid) {
	global $XML_addr;
	$xml="
	<request>
		<wmid></wmid>
		<passportwmid>$wmid</passportwmid>				
		<sign></sign>
		<params>
			<dict>1</dict>
			<info>1</info>
			<mode>0</mode>
		</params>
	</request>";
	$resxml=_GetAnswer($XML_addr[11], $xml);
	//echo $resxml;
	$xmlres = simplexml_load_string($resxml);
	if(!$xmlres) {
	  $result['att']=0;
		$result['retval']=1000;
		$result['retdesc']="Не получен XML-ответ";
		return $result;
	}
	if(!$xmlres->certinfo->attestat->row) {
		$result['att']=0; 
		$result['retval']=1001;
		$result['retdesc']="Информация об аттестате не получена. Возможно, неверно указан WMID.";
		return $result;
	}

$fullaccess = explode("<fullaccess>",$xmlres);
//$fullaccess = $fullaccess[1];
//if ($fullaccess==1) echo "<font color=green><b>Доступ к данным WMID,а Разрешен</b></font><br>";
$fullaccess = explode("</fullaccess>",$xmlres);
$fullaccess = $fullaccess[0];
if ($fullaccess==0) echo "<font color=red><b>Доступ к данным WMID,а Ограничен</b></font><br>";

$result['att']=strval($xmlres->certinfo->attestat->row->attributes()->tid);
$result['recalled']=strval($xmlres->certinfo->attestat->row->attributes()->recalled);
$result['datecrt']=strval($xmlres->certinfo->attestat->row->attributes()->datecrt);
$result['notary']=strval($xmlres->certinfo->attestat->row->attributes()->notary);
$result['datediff']=strval($xmlres->certinfo->attestat->row->attributes()->datediff);
$result['status']=strval($xmlres->certinfo->attestat->row->attributes()->status);
$result['nickname']=strval($xmlres->certinfo->userinfo->value->row->attributes()->nickname);
$result['byear']=strval($xmlres->certinfo->userinfo->value->row->attributes()->byear);
$result['fname']=strval($xmlres->certinfo->userinfo->value->row->attributes()->fname);
$result['iname']=strval($xmlres->certinfo->userinfo->value->row->attributes()->iname);
$result['oname']=strval($xmlres->certinfo->userinfo->value->row->attributes()->oname);
$result['pnomer']=strval($xmlres->certinfo->userinfo->value->row->attributes()->pnomer);

$result['pasdoc']=strval($xmlres->certinfo->userinfo->value->row->attributes()->pasdoc);
$result['regdoc']=strval($xmlres->certinfo->userinfo->value->row->attributes()->regdoc);
$result['inndoc']=strval($xmlres->certinfo->userinfo->value->row->attributes()->inndoc);
$result['photoid']=strval($xmlres->certinfo->userinfo->value->row->attributes()->photoid);


$result['ctype']=strval($xmlres->certinfo->wmids->row->attributes()->ctype);



$result['retval']=strval($xmlres->attributes()->retval);
foreach ($xmlres->certinfo->wmids->row as $row) {
$wmids[]=strval($row->attributes()->wmid);
}
$result['wmids']=$wmids;
return $result;
}



// ИНТЕРФЕЙС X3. ПОЛУЧЕНИЕ ИСТОРИИ ОПЕРАЦИЙ.
// На выходе: массив ['retval'=>код выполнения, 'retdesc'=>описание результата,
// 'cnt'=>количество операций в выборке, 'operations'=>массив с операциями]
function _WMXML3 ($purse,$wmtranid,$tranid,$wminvid,$orderid,$datestart,$datefinish) {
	global $Global_WMID, $XML_addr;
	$reqn=_GetReqn();
	$rsign=_GetSign($purse.$reqn);
	$xml="
	<w3s.request>
		<reqn>$reqn</reqn>
		<wmid>$Global_WMID</wmid>
		<sign>$rsign</sign>
		<getoperations>
			<purse>$purse</purse>
			<wmtranid>$wmtranid</wmtranid>
			<tranid>$tranid</tranid>
			<wminvid>$wminvid</wminvid>
			<orderid>$orderid</orderid>
			<datestart>$datestart</datestart>
			<datefinish>$datefinish</datefinish>
		</getoperations>
	</w3s.request>";
	$resxml=_GetAnswer($XML_addr[3], $xml);
	// echo $resxml;
	$xmlres = simplexml_load_string($resxml);
	if(!$xmlres) {
		$result['retval']=1000;
		$result['retdesc']="Не получен XML-ответ";
		return $result;
	}
	$result['retval']=strval($xmlres->retval);
	//$result['retdesc']=iconv("UTF-8", "CP1251", strval($xmlres->retdesc));
	$result['cnt']=strval($xmlres->operations->attributes()->cnt);
	if($result['cnt']>0) {
		// В элементе $result['operations'] формируем элементы,
		// каждый из которых является
		// массивом с параметрами операции
		foreach ($xmlres->operations->operation as $operation) {
			// определяем тип операции (входящая, исходящая)
			// и кошелёк корреспондента
			$pursesrc=strval($operation->pursesrc);
			$pursedest=strval($operation->pursedest);
			if($pursesrc==$purse) {
				$type="исходящая"; $corrpurse=$pursedest;
			} elseif($pursedest==$purse) {
				$type="входящая"; $corrpurse=$pursesrc;
			}
			$result['operations'][strval($operation->attributes()->id)] = Array
				(
				'tranid'=>strval($operation->tranid),
			 	'wminvid'=>strval($operation->wminvid),
				'orderid'=>strval($operation->orderid),
				'type'=>$type,
				'corrpurse'=>$corrpurse,
				'corrwmid'=>strval($operation->corrwm),
				'amount'=>floatval($operation->amount),
				'comiss'=>floatval($operation->comiss),
				'rest'=>floatval($operation->rest),
				'protection'=>strval($operation->opertype),
				'desc'=> strval($operation->desc),
				'datecrt'=>strval($operation->datecrt)
				);
		}
	}
	return $result;
}
//	$pcode=iconv("CP1251", "UTF-8", $pcode);
  //      $desc=iconv("CP1251", "UTF-8", $desc);
?>