<?

if (!isset($urlType[2])) {
	Redirection('/');
}

$count = $sql->rowCount("SELECT * FROM `news` WHERE `link` = ? LIMIT 1", [$urlType[2]]);
if ($count == 0) {
	Redirection('/');
}

$CacheData = [
	'NameKey' => 'news-'. $urlType[2],
	'LifeTime' => 0,
	'type' => 'news'
];

$CacheData['data'] = [];
$CacheGet = CacheHade::get($CacheData);
if ($CacheGet) {
	$CacheData['data'] = $CacheGet;
} else {
	$CacheData['data'] = $sql->fetch("SELECT * FROM `news` where link = ? ", [$urlType[2]]);
	CacheHade::save($CacheData);
}
$news = $CacheData['data'];

if ($news['act'] == 0 AND ($user['id_level'] == 0 || !$user)) {
	Redirection('/');
}
if ($news['act'] == 2 AND ($user['id_level'] < 2 || !$user)) {
	Redirection('/');
}

if (isset($urlType[3]) AND $urlType[3] == 'delete' AND $user AND $user['id_level'] != 0) {
	$sql->query("UPDATE `news` SET `act` = '2' WHERE `id` = ". $news['id']);
	CacheDelete::news($news['link']);
	
	$sorta = '/';
	if ($user['id_level'] >= 2) {
		$sorta = '/apanel/news-type?t=trash';
	}
	Redirection($sorta, 'Новость удалена');
}

if (isset($urlType[3]) AND $urlType[3] == 'public' AND $user AND $user['id_level'] >= 1) {
	$sql->query("UPDATE `news` SET `act` = '1', `date_public` = '{$system['time']}', `sort` = '0' WHERE `id` = ". $news['id']);
	CacheDelete::news($news['link']);
	Redirection('/', 'Новость опубликована');
}

if (isset($urlType[3]) AND $urlType[3] == 'returnSpeed' AND $user AND $user['id_level'] >= 2) {
	$sql->query("UPDATE `news` SET `act` = '1' WHERE `id` = ". $news['id']);
	CacheDelete::news($news['link']);
	Redirection('/', 'Новость восстановлена');
}

if (isset($urlType[3]) AND $urlType[3] == 'return' AND $user AND $user['id_level'] >= 2) {
	$sql->query("UPDATE `news` SET `act` = '0' WHERE `id` = ". $news['id']);
	CacheDelete::news($news['link']);
	Redirection('/', 'Новость восстановлена (в очереди)');
}

if (isset($urlType[3]) AND $urlType[3] == 'freeze' AND $user AND $user['id_level'] >= 1) {
	$sql->query("UPDATE `news` SET `act` = '4', `sort` = '0' WHERE `id` = ". $news['id']);
	CacheDelete::news($news['link']);
	Redirection('/apanel/news-type?t=freeze', 'Новость в заморозке');
}

$news['image_mid'] = '/files/news-images/mid/'.$news['img'].'.jpg';
$news['image_big'] = '/files/news-images/big/'.$news['img'].'.jpg';
$news['image_min'] = '/files/news-images/min/'.$news['img'].'.jpg';

$news['text'] = output($news['text']);
$news['title'] = output($news['title'], 'html');

if ($news['date_public'] != 0) {
	$news['date_public'] = times::out($news['date_public']);
}

$news['date_create'] = times::out($news['date_create']);

$news['nick'] = user::nick($news['id_user'], 3);

$menu = '<a href="/news/edit/'. $news['link'] .'/">Редактировать</a>';

if ($news['act'] == 0 || $news['act'] == 3 || $news['act'] == 5) {
	$menu .= '<a href="/news/view/'. $news['link'] .'/public/">Опубликовать</a>';
}
if ($news['act'] == 1) {
	$menu .= '<a href="/news/view/'. $news['link'] .'/freeze/">Снять с публикации</a>';
}

$sort = 'all';
if ($news['act'] == 0) {
	$sort = 'queue';
}
if ($news['act'] == 3) {
	$sort = 'users';
}
if ($news['act'] == 4) {
	$sort = 'freeze';
}
$menu .=  (
	($news['act'] != 1) ? 
	'<a href="/apanel/news-type?t='. $sort .'&GetSortType=0&GetSort='. $news['link'] .'">Добавить в конец очереди</a>
	<a href="/apanel/news-type?t='. $sort .'&GetSortType=1&GetSort='. $news['link'] .'">Добавить в начало очереди</a>' : false
);	

if ($news['act'] != 2) {
	$menu .= '<a href="/news/view/'. $news['link'] .'/delete/">Удалить</a>';
}
if ($news['act'] == 2 AND $user['id_level'] >= 2) {
	$menu .= '<a href="/news/view/'. $news['link'] .'/returnSpeed/">Восстановить моментально</a>';
	$menu .= '<a href="/news/view/'. $news['link'] .'/return/">Восстановить и поставить в очередь</a>';	
}
#------------------------------------#


$og_image = "{$set['http']}://{$system['urlHost']}{$news['image_big']}";
$news['ToggleBottom'] = false;
if ($user AND $user['id_level'] != 0){
	$news['ToggleBottom'] = ToggleBottom($menu);
}
$PageConfig = [	
	'title' 		=>  $news['title'],
	'NameKeyPage' 	=>  $urlPage,
	'og_image'		=> $og_image,
	'keywords'		=> $news['keywords'] ,
	'description' 	=> $news['description'] ,		
];
PageConfig($PageConfig);	

if (empty($_COOKIE['view-news-'. $news['link']])) {
	$data_replace = 
	[
		'NameKey' => 'news-'. $urlType[2],
		'type' => 'news',
		'replace' => 
		[
			'view' => ($news['view'] + 1),
		],
	];
	CacheHade::replace($data_replace);
	$sql->query("UPDATE `news` SET `view` = '{$data_replace['replace']['view']}' WHERE `id` = ". $news['id']);
	cookie('view-news-'. $news['link'], 1, 120);
}

$t->assign('news', $news);
echo $t->fetch('news.view');